/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeReservedInstancesOfferings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeReservedInstancesOfferingsRequest extends EC2Request implements
        ToCopyableBuilder<DescribeReservedInstancesOfferingsRequest.Builder, DescribeReservedInstancesOfferingsRequest> {
    private final String availabilityZone;

    private final List<Filter> filters;

    private final Boolean includeMarketplace;

    private final String instanceType;

    private final Long maxDuration;

    private final Integer maxInstanceCount;

    private final Long minDuration;

    private final String offeringClass;

    private final String productDescription;

    private final List<String> reservedInstancesOfferingIds;

    private final String instanceTenancy;

    private final Integer maxResults;

    private final String nextToken;

    private final String offeringType;

    private DescribeReservedInstancesOfferingsRequest(BuilderImpl builder) {
        super(builder);
        this.availabilityZone = builder.availabilityZone;
        this.filters = builder.filters;
        this.includeMarketplace = builder.includeMarketplace;
        this.instanceType = builder.instanceType;
        this.maxDuration = builder.maxDuration;
        this.maxInstanceCount = builder.maxInstanceCount;
        this.minDuration = builder.minDuration;
        this.offeringClass = builder.offeringClass;
        this.productDescription = builder.productDescription;
        this.reservedInstancesOfferingIds = builder.reservedInstancesOfferingIds;
        this.instanceTenancy = builder.instanceTenancy;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.offeringType = builder.offeringType;
    }

    /**
     * <p>
     * The Availability Zone in which the Reserved Instance can be used.
     * </p>
     * 
     * @return The Availability Zone in which the Reserved Instance can be used.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>availability-zone</code> - The Availability Zone where the Reserved Instance can be used.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>duration</code> - The duration of the Reserved Instance (for example, one year or three years), in seconds
     * (<code>31536000</code> | <code>94608000</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fixed-price</code> - The purchase price of the Reserved Instance (for example, 9800.0).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-type</code> - The instance type that is covered by the reservation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>marketplace</code> - Set to <code>true</code> to show only Reserved Instance Marketplace offerings. When
     * this filter is not used, which is the default behavior, all offerings from both AWS and the Reserved Instance
     * Marketplace are listed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>product-description</code> - The Reserved Instance product platform description. Instances that include
     * <code>(Amazon VPC)</code> in the product platform description will only be displayed to EC2-Classic account
     * holders and are for use with Amazon VPC. (<code>Linux/UNIX</code> | <code>Linux/UNIX (Amazon VPC)</code> |
     * <code>SUSE Linux</code> | <code>SUSE Linux (Amazon VPC)</code> | <code>Red Hat Enterprise Linux</code> |
     * <code>Red Hat Enterprise Linux (Amazon VPC)</code> | <code>Windows</code> | <code>Windows (Amazon VPC)</code> |
     * <code>Windows with SQL Server Standard</code> | <code>Windows with SQL Server Standard (Amazon VPC)</code> |
     * <code>Windows with SQL Server Web</code> | <code> Windows with SQL Server Web (Amazon VPC)</code> |
     * <code>Windows with SQL Server Enterprise</code> | <code>Windows with SQL Server Enterprise (Amazon VPC)</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>reserved-instances-offering-id</code> - The Reserved Instances offering ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>scope</code> - The scope of the Reserved Instance (<code>Availability Zone</code> or <code>Region</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>usage-price</code> - The usage price of the Reserved Instance, per hour (for example, 0.84).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>availability-zone</code> - The Availability Zone where the Reserved Instance can be used.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>duration</code> - The duration of the Reserved Instance (for example, one year or three years), in
     *         seconds (<code>31536000</code> | <code>94608000</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fixed-price</code> - The purchase price of the Reserved Instance (for example, 9800.0).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-type</code> - The instance type that is covered by the reservation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>marketplace</code> - Set to <code>true</code> to show only Reserved Instance Marketplace offerings.
     *         When this filter is not used, which is the default behavior, all offerings from both AWS and the Reserved
     *         Instance Marketplace are listed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>product-description</code> - The Reserved Instance product platform description. Instances that
     *         include <code>(Amazon VPC)</code> in the product platform description will only be displayed to
     *         EC2-Classic account holders and are for use with Amazon VPC. (<code>Linux/UNIX</code> |
     *         <code>Linux/UNIX (Amazon VPC)</code> | <code>SUSE Linux</code> | <code>SUSE Linux (Amazon VPC)</code> |
     *         <code>Red Hat Enterprise Linux</code> | <code>Red Hat Enterprise Linux (Amazon VPC)</code> |
     *         <code>Windows</code> | <code>Windows (Amazon VPC)</code> | <code>Windows with SQL Server Standard</code>
     *         | <code>Windows with SQL Server Standard (Amazon VPC)</code> | <code>Windows with SQL Server Web</code> |
     *         <code> Windows with SQL Server Web (Amazon VPC)</code> | <code>Windows with SQL Server Enterprise</code>
     *         | <code>Windows with SQL Server Enterprise (Amazon VPC)</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>reserved-instances-offering-id</code> - The Reserved Instances offering ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>scope</code> - The scope of the Reserved Instance (<code>Availability Zone</code> or
     *         <code>Region</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>usage-price</code> - The usage price of the Reserved Instance, per hour (for example, 0.84).
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * Include Reserved Instance Marketplace offerings in the response.
     * </p>
     * 
     * @return Include Reserved Instance Marketplace offerings in the response.
     */
    public Boolean includeMarketplace() {
        return includeMarketplace;
    }

    /**
     * <p>
     * The instance type that the reservation will cover (for example, <code>m1.small</code>). For more information, see
     * <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeString}.
     * </p>
     * 
     * @return The instance type that the reservation will cover (for example, <code>m1.small</code>). For more
     *         information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the
     *         <i>Amazon Elastic Compute Cloud User Guide</i>.
     * @see InstanceType
     */
    public InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type that the reservation will cover (for example, <code>m1.small</code>). For more information, see
     * <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeString}.
     * </p>
     * 
     * @return The instance type that the reservation will cover (for example, <code>m1.small</code>). For more
     *         information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the
     *         <i>Amazon Elastic Compute Cloud User Guide</i>.
     * @see InstanceType
     */
    public String instanceTypeString() {
        return instanceType;
    }

    /**
     * <p>
     * The maximum duration (in seconds) to filter when searching for offerings.
     * </p>
     * <p>
     * Default: 94608000 (3 years)
     * </p>
     * 
     * @return The maximum duration (in seconds) to filter when searching for offerings.</p>
     *         <p>
     *         Default: 94608000 (3 years)
     */
    public Long maxDuration() {
        return maxDuration;
    }

    /**
     * <p>
     * The maximum number of instances to filter when searching for offerings.
     * </p>
     * <p>
     * Default: 20
     * </p>
     * 
     * @return The maximum number of instances to filter when searching for offerings.</p>
     *         <p>
     *         Default: 20
     */
    public Integer maxInstanceCount() {
        return maxInstanceCount;
    }

    /**
     * <p>
     * The minimum duration (in seconds) to filter when searching for offerings.
     * </p>
     * <p>
     * Default: 2592000 (1 month)
     * </p>
     * 
     * @return The minimum duration (in seconds) to filter when searching for offerings.</p>
     *         <p>
     *         Default: 2592000 (1 month)
     */
    public Long minDuration() {
        return minDuration;
    }

    /**
     * <p>
     * The offering class of the Reserved Instance. Can be <code>standard</code> or <code>convertible</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringClass}
     * will return {@link OfferingClassType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #offeringClassString}.
     * </p>
     * 
     * @return The offering class of the Reserved Instance. Can be <code>standard</code> or <code>convertible</code>.
     * @see OfferingClassType
     */
    public OfferingClassType offeringClass() {
        return OfferingClassType.fromValue(offeringClass);
    }

    /**
     * <p>
     * The offering class of the Reserved Instance. Can be <code>standard</code> or <code>convertible</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringClass}
     * will return {@link OfferingClassType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #offeringClassString}.
     * </p>
     * 
     * @return The offering class of the Reserved Instance. Can be <code>standard</code> or <code>convertible</code>.
     * @see OfferingClassType
     */
    public String offeringClassString() {
        return offeringClass;
    }

    /**
     * <p>
     * The Reserved Instance product platform description. Instances that include <code>(Amazon VPC)</code> in the
     * description are for use with Amazon VPC.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #productDescription} will return {@link RIProductDescription#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #productDescriptionString}.
     * </p>
     * 
     * @return The Reserved Instance product platform description. Instances that include <code>(Amazon VPC)</code> in
     *         the description are for use with Amazon VPC.
     * @see RIProductDescription
     */
    public RIProductDescription productDescription() {
        return RIProductDescription.fromValue(productDescription);
    }

    /**
     * <p>
     * The Reserved Instance product platform description. Instances that include <code>(Amazon VPC)</code> in the
     * description are for use with Amazon VPC.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #productDescription} will return {@link RIProductDescription#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #productDescriptionString}.
     * </p>
     * 
     * @return The Reserved Instance product platform description. Instances that include <code>(Amazon VPC)</code> in
     *         the description are for use with Amazon VPC.
     * @see RIProductDescription
     */
    public String productDescriptionString() {
        return productDescription;
    }

    /**
     * <p>
     * One or more Reserved Instances offering IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more Reserved Instances offering IDs.
     */
    public List<String> reservedInstancesOfferingIds() {
        return reservedInstancesOfferingIds;
    }

    /**
     * <p>
     * The tenancy of the instances covered by the reservation. A Reserved Instance with a tenancy of
     * <code>dedicated</code> is applied to instances that run in a VPC on single-tenant hardware (i.e., Dedicated
     * Instances).
     * </p>
     * <p>
     * <b>Important:</b> The <code>host</code> value cannot be used with this parameter. Use the <code>default</code> or
     * <code>dedicated</code> values only.
     * </p>
     * <p>
     * Default: <code>default</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceTenancy}
     * will return {@link Tenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTenancyString}.
     * </p>
     * 
     * @return The tenancy of the instances covered by the reservation. A Reserved Instance with a tenancy of
     *         <code>dedicated</code> is applied to instances that run in a VPC on single-tenant hardware (i.e.,
     *         Dedicated Instances).</p>
     *         <p>
     *         <b>Important:</b> The <code>host</code> value cannot be used with this parameter. Use the
     *         <code>default</code> or <code>dedicated</code> values only.
     *         </p>
     *         <p>
     *         Default: <code>default</code>
     * @see Tenancy
     */
    public Tenancy instanceTenancy() {
        return Tenancy.fromValue(instanceTenancy);
    }

    /**
     * <p>
     * The tenancy of the instances covered by the reservation. A Reserved Instance with a tenancy of
     * <code>dedicated</code> is applied to instances that run in a VPC on single-tenant hardware (i.e., Dedicated
     * Instances).
     * </p>
     * <p>
     * <b>Important:</b> The <code>host</code> value cannot be used with this parameter. Use the <code>default</code> or
     * <code>dedicated</code> values only.
     * </p>
     * <p>
     * Default: <code>default</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceTenancy}
     * will return {@link Tenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTenancyString}.
     * </p>
     * 
     * @return The tenancy of the instances covered by the reservation. A Reserved Instance with a tenancy of
     *         <code>dedicated</code> is applied to instances that run in a VPC on single-tenant hardware (i.e.,
     *         Dedicated Instances).</p>
     *         <p>
     *         <b>Important:</b> The <code>host</code> value cannot be used with this parameter. Use the
     *         <code>default</code> or <code>dedicated</code> values only.
     *         </p>
     *         <p>
     *         Default: <code>default</code>
     * @see Tenancy
     */
    public String instanceTenancyString() {
        return instanceTenancy;
    }

    /**
     * <p>
     * The maximum number of results to return for the request in a single page. The remaining results of the initial
     * request can be seen by sending another request with the returned <code>NextToken</code> value. The maximum is
     * 100.
     * </p>
     * <p>
     * Default: 100
     * </p>
     * 
     * @return The maximum number of results to return for the request in a single page. The remaining results of the
     *         initial request can be seen by sending another request with the returned <code>NextToken</code> value.
     *         The maximum is 100.</p>
     *         <p>
     *         Default: 100
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to retrieve the next page of results.
     * </p>
     * 
     * @return The token to retrieve the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The Reserved Instance offering type. If you are using tools that predate the 2011-11-01 API version, you only
     * have access to the <code>Medium Utilization</code> Reserved Instance offering type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringType} will
     * return {@link OfferingTypeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #offeringTypeString}.
     * </p>
     * 
     * @return The Reserved Instance offering type. If you are using tools that predate the 2011-11-01 API version, you
     *         only have access to the <code>Medium Utilization</code> Reserved Instance offering type.
     * @see OfferingTypeValues
     */
    public OfferingTypeValues offeringType() {
        return OfferingTypeValues.fromValue(offeringType);
    }

    /**
     * <p>
     * The Reserved Instance offering type. If you are using tools that predate the 2011-11-01 API version, you only
     * have access to the <code>Medium Utilization</code> Reserved Instance offering type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringType} will
     * return {@link OfferingTypeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #offeringTypeString}.
     * </p>
     * 
     * @return The Reserved Instance offering type. If you are using tools that predate the 2011-11-01 API version, you
     *         only have access to the <code>Medium Utilization</code> Reserved Instance offering type.
     * @see OfferingTypeValues
     */
    public String offeringTypeString() {
        return offeringType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(includeMarketplace());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(maxDuration());
        hashCode = 31 * hashCode + Objects.hashCode(maxInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(minDuration());
        hashCode = 31 * hashCode + Objects.hashCode(offeringClassString());
        hashCode = 31 * hashCode + Objects.hashCode(productDescriptionString());
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesOfferingIds());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTenancyString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(offeringTypeString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesOfferingsRequest)) {
            return false;
        }
        DescribeReservedInstancesOfferingsRequest other = (DescribeReservedInstancesOfferingsRequest) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone()) && Objects.equals(filters(), other.filters())
                && Objects.equals(includeMarketplace(), other.includeMarketplace())
                && Objects.equals(instanceTypeString(), other.instanceTypeString())
                && Objects.equals(maxDuration(), other.maxDuration())
                && Objects.equals(maxInstanceCount(), other.maxInstanceCount())
                && Objects.equals(minDuration(), other.minDuration())
                && Objects.equals(offeringClassString(), other.offeringClassString())
                && Objects.equals(productDescriptionString(), other.productDescriptionString())
                && Objects.equals(reservedInstancesOfferingIds(), other.reservedInstancesOfferingIds())
                && Objects.equals(instanceTenancyString(), other.instanceTenancyString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(offeringTypeString(), other.offeringTypeString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(availabilityZone()).append(",");
        }
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (includeMarketplace() != null) {
            sb.append("IncludeMarketplace: ").append(includeMarketplace()).append(",");
        }
        if (instanceTypeString() != null) {
            sb.append("InstanceType: ").append(instanceTypeString()).append(",");
        }
        if (maxDuration() != null) {
            sb.append("MaxDuration: ").append(maxDuration()).append(",");
        }
        if (maxInstanceCount() != null) {
            sb.append("MaxInstanceCount: ").append(maxInstanceCount()).append(",");
        }
        if (minDuration() != null) {
            sb.append("MinDuration: ").append(minDuration()).append(",");
        }
        if (offeringClassString() != null) {
            sb.append("OfferingClass: ").append(offeringClassString()).append(",");
        }
        if (productDescriptionString() != null) {
            sb.append("ProductDescription: ").append(productDescriptionString()).append(",");
        }
        if (reservedInstancesOfferingIds() != null) {
            sb.append("ReservedInstancesOfferingIds: ").append(reservedInstancesOfferingIds()).append(",");
        }
        if (instanceTenancyString() != null) {
            sb.append("InstanceTenancy: ").append(instanceTenancyString()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (offeringTypeString() != null) {
            sb.append("OfferingType: ").append(offeringTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.of(clazz.cast(availabilityZone()));
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "IncludeMarketplace":
            return Optional.of(clazz.cast(includeMarketplace()));
        case "InstanceType":
            return Optional.of(clazz.cast(instanceTypeString()));
        case "MaxDuration":
            return Optional.of(clazz.cast(maxDuration()));
        case "MaxInstanceCount":
            return Optional.of(clazz.cast(maxInstanceCount()));
        case "MinDuration":
            return Optional.of(clazz.cast(minDuration()));
        case "OfferingClass":
            return Optional.of(clazz.cast(offeringClassString()));
        case "ProductDescription":
            return Optional.of(clazz.cast(productDescriptionString()));
        case "ReservedInstancesOfferingIds":
            return Optional.of(clazz.cast(reservedInstancesOfferingIds()));
        case "InstanceTenancy":
            return Optional.of(clazz.cast(instanceTenancyString()));
        case "MaxResults":
            return Optional.of(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "OfferingType":
            return Optional.of(clazz.cast(offeringTypeString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, DescribeReservedInstancesOfferingsRequest> {
        /**
         * <p>
         * The Availability Zone in which the Reserved Instance can be used.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone in which the Reserved Instance can be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone where the Reserved Instance can be used.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>duration</code> - The duration of the Reserved Instance (for example, one year or three years), in
         * seconds (<code>31536000</code> | <code>94608000</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fixed-price</code> - The purchase price of the Reserved Instance (for example, 9800.0).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The instance type that is covered by the reservation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>marketplace</code> - Set to <code>true</code> to show only Reserved Instance Marketplace offerings.
         * When this filter is not used, which is the default behavior, all offerings from both AWS and the Reserved
         * Instance Marketplace are listed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-description</code> - The Reserved Instance product platform description. Instances that include
         * <code>(Amazon VPC)</code> in the product platform description will only be displayed to EC2-Classic account
         * holders and are for use with Amazon VPC. (<code>Linux/UNIX</code> | <code>Linux/UNIX (Amazon VPC)</code> |
         * <code>SUSE Linux</code> | <code>SUSE Linux (Amazon VPC)</code> | <code>Red Hat Enterprise Linux</code> |
         * <code>Red Hat Enterprise Linux (Amazon VPC)</code> | <code>Windows</code> | <code>Windows (Amazon VPC)</code>
         * | <code>Windows with SQL Server Standard</code> | <code>Windows with SQL Server Standard (Amazon VPC)</code>
         * | <code>Windows with SQL Server Web</code> | <code> Windows with SQL Server Web (Amazon VPC)</code> |
         * <code>Windows with SQL Server Enterprise</code> |
         * <code>Windows with SQL Server Enterprise (Amazon VPC)</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reserved-instances-offering-id</code> - The Reserved Instances offering ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>scope</code> - The scope of the Reserved Instance (<code>Availability Zone</code> or
         * <code>Region</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>usage-price</code> - The usage price of the Reserved Instance, per hour (for example, 0.84).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone where the Reserved Instance can be used.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>duration</code> - The duration of the Reserved Instance (for example, one year or three years),
         *        in seconds (<code>31536000</code> | <code>94608000</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fixed-price</code> - The purchase price of the Reserved Instance (for example, 9800.0).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The instance type that is covered by the reservation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>marketplace</code> - Set to <code>true</code> to show only Reserved Instance Marketplace
         *        offerings. When this filter is not used, which is the default behavior, all offerings from both AWS
         *        and the Reserved Instance Marketplace are listed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-description</code> - The Reserved Instance product platform description. Instances that
         *        include <code>(Amazon VPC)</code> in the product platform description will only be displayed to
         *        EC2-Classic account holders and are for use with Amazon VPC. (<code>Linux/UNIX</code> |
         *        <code>Linux/UNIX (Amazon VPC)</code> | <code>SUSE Linux</code> | <code>SUSE Linux (Amazon VPC)</code>
         *        | <code>Red Hat Enterprise Linux</code> | <code>Red Hat Enterprise Linux (Amazon VPC)</code> |
         *        <code>Windows</code> | <code>Windows (Amazon VPC)</code> |
         *        <code>Windows with SQL Server Standard</code> |
         *        <code>Windows with SQL Server Standard (Amazon VPC)</code> | <code>Windows with SQL Server Web</code>
         *        | <code> Windows with SQL Server Web (Amazon VPC)</code> |
         *        <code>Windows with SQL Server Enterprise</code> |
         *        <code>Windows with SQL Server Enterprise (Amazon VPC)</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>reserved-instances-offering-id</code> - The Reserved Instances offering ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>scope</code> - The scope of the Reserved Instance (<code>Availability Zone</code> or
         *        <code>Region</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>usage-price</code> - The usage price of the Reserved Instance, per hour (for example, 0.84).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone where the Reserved Instance can be used.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>duration</code> - The duration of the Reserved Instance (for example, one year or three years), in
         * seconds (<code>31536000</code> | <code>94608000</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fixed-price</code> - The purchase price of the Reserved Instance (for example, 9800.0).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The instance type that is covered by the reservation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>marketplace</code> - Set to <code>true</code> to show only Reserved Instance Marketplace offerings.
         * When this filter is not used, which is the default behavior, all offerings from both AWS and the Reserved
         * Instance Marketplace are listed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-description</code> - The Reserved Instance product platform description. Instances that include
         * <code>(Amazon VPC)</code> in the product platform description will only be displayed to EC2-Classic account
         * holders and are for use with Amazon VPC. (<code>Linux/UNIX</code> | <code>Linux/UNIX (Amazon VPC)</code> |
         * <code>SUSE Linux</code> | <code>SUSE Linux (Amazon VPC)</code> | <code>Red Hat Enterprise Linux</code> |
         * <code>Red Hat Enterprise Linux (Amazon VPC)</code> | <code>Windows</code> | <code>Windows (Amazon VPC)</code>
         * | <code>Windows with SQL Server Standard</code> | <code>Windows with SQL Server Standard (Amazon VPC)</code>
         * | <code>Windows with SQL Server Web</code> | <code> Windows with SQL Server Web (Amazon VPC)</code> |
         * <code>Windows with SQL Server Enterprise</code> |
         * <code>Windows with SQL Server Enterprise (Amazon VPC)</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reserved-instances-offering-id</code> - The Reserved Instances offering ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>scope</code> - The scope of the Reserved Instance (<code>Availability Zone</code> or
         * <code>Region</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>usage-price</code> - The usage price of the Reserved Instance, per hour (for example, 0.84).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone where the Reserved Instance can be used.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>duration</code> - The duration of the Reserved Instance (for example, one year or three years),
         *        in seconds (<code>31536000</code> | <code>94608000</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fixed-price</code> - The purchase price of the Reserved Instance (for example, 9800.0).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The instance type that is covered by the reservation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>marketplace</code> - Set to <code>true</code> to show only Reserved Instance Marketplace
         *        offerings. When this filter is not used, which is the default behavior, all offerings from both AWS
         *        and the Reserved Instance Marketplace are listed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-description</code> - The Reserved Instance product platform description. Instances that
         *        include <code>(Amazon VPC)</code> in the product platform description will only be displayed to
         *        EC2-Classic account holders and are for use with Amazon VPC. (<code>Linux/UNIX</code> |
         *        <code>Linux/UNIX (Amazon VPC)</code> | <code>SUSE Linux</code> | <code>SUSE Linux (Amazon VPC)</code>
         *        | <code>Red Hat Enterprise Linux</code> | <code>Red Hat Enterprise Linux (Amazon VPC)</code> |
         *        <code>Windows</code> | <code>Windows (Amazon VPC)</code> |
         *        <code>Windows with SQL Server Standard</code> |
         *        <code>Windows with SQL Server Standard (Amazon VPC)</code> | <code>Windows with SQL Server Web</code>
         *        | <code> Windows with SQL Server Web (Amazon VPC)</code> |
         *        <code>Windows with SQL Server Enterprise</code> |
         *        <code>Windows with SQL Server Enterprise (Amazon VPC)</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>reserved-instances-offering-id</code> - The Reserved Instances offering ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>scope</code> - The scope of the Reserved Instance (<code>Availability Zone</code> or
         *        <code>Region</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>usage-price</code> - The usage price of the Reserved Instance, per hour (for example, 0.84).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * Include Reserved Instance Marketplace offerings in the response.
         * </p>
         * 
         * @param includeMarketplace
         *        Include Reserved Instance Marketplace offerings in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeMarketplace(Boolean includeMarketplace);

        /**
         * <p>
         * The instance type that the reservation will cover (for example, <code>m1.small</code>). For more information,
         * see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in
         * the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param instanceType
         *        The instance type that the reservation will cover (for example, <code>m1.small</code>). For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in
         *        the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type that the reservation will cover (for example, <code>m1.small</code>). For more information,
         * see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in
         * the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param instanceType
         *        The instance type that the reservation will cover (for example, <code>m1.small</code>). For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in
         *        the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The maximum duration (in seconds) to filter when searching for offerings.
         * </p>
         * <p>
         * Default: 94608000 (3 years)
         * </p>
         * 
         * @param maxDuration
         *        The maximum duration (in seconds) to filter when searching for offerings.</p>
         *        <p>
         *        Default: 94608000 (3 years)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxDuration(Long maxDuration);

        /**
         * <p>
         * The maximum number of instances to filter when searching for offerings.
         * </p>
         * <p>
         * Default: 20
         * </p>
         * 
         * @param maxInstanceCount
         *        The maximum number of instances to filter when searching for offerings.</p>
         *        <p>
         *        Default: 20
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxInstanceCount(Integer maxInstanceCount);

        /**
         * <p>
         * The minimum duration (in seconds) to filter when searching for offerings.
         * </p>
         * <p>
         * Default: 2592000 (1 month)
         * </p>
         * 
         * @param minDuration
         *        The minimum duration (in seconds) to filter when searching for offerings.</p>
         *        <p>
         *        Default: 2592000 (1 month)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minDuration(Long minDuration);

        /**
         * <p>
         * The offering class of the Reserved Instance. Can be <code>standard</code> or <code>convertible</code>.
         * </p>
         * 
         * @param offeringClass
         *        The offering class of the Reserved Instance. Can be <code>standard</code> or <code>convertible</code>.
         * @see OfferingClassType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingClassType
         */
        Builder offeringClass(String offeringClass);

        /**
         * <p>
         * The offering class of the Reserved Instance. Can be <code>standard</code> or <code>convertible</code>.
         * </p>
         * 
         * @param offeringClass
         *        The offering class of the Reserved Instance. Can be <code>standard</code> or <code>convertible</code>.
         * @see OfferingClassType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingClassType
         */
        Builder offeringClass(OfferingClassType offeringClass);

        /**
         * <p>
         * The Reserved Instance product platform description. Instances that include <code>(Amazon VPC)</code> in the
         * description are for use with Amazon VPC.
         * </p>
         * 
         * @param productDescription
         *        The Reserved Instance product platform description. Instances that include <code>(Amazon VPC)</code>
         *        in the description are for use with Amazon VPC.
         * @see RIProductDescription
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RIProductDescription
         */
        Builder productDescription(String productDescription);

        /**
         * <p>
         * The Reserved Instance product platform description. Instances that include <code>(Amazon VPC)</code> in the
         * description are for use with Amazon VPC.
         * </p>
         * 
         * @param productDescription
         *        The Reserved Instance product platform description. Instances that include <code>(Amazon VPC)</code>
         *        in the description are for use with Amazon VPC.
         * @see RIProductDescription
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RIProductDescription
         */
        Builder productDescription(RIProductDescription productDescription);

        /**
         * <p>
         * One or more Reserved Instances offering IDs.
         * </p>
         * 
         * @param reservedInstancesOfferingIds
         *        One or more Reserved Instances offering IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesOfferingIds(Collection<String> reservedInstancesOfferingIds);

        /**
         * <p>
         * One or more Reserved Instances offering IDs.
         * </p>
         * 
         * @param reservedInstancesOfferingIds
         *        One or more Reserved Instances offering IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesOfferingIds(String... reservedInstancesOfferingIds);

        /**
         * <p>
         * The tenancy of the instances covered by the reservation. A Reserved Instance with a tenancy of
         * <code>dedicated</code> is applied to instances that run in a VPC on single-tenant hardware (i.e., Dedicated
         * Instances).
         * </p>
         * <p>
         * <b>Important:</b> The <code>host</code> value cannot be used with this parameter. Use the
         * <code>default</code> or <code>dedicated</code> values only.
         * </p>
         * <p>
         * Default: <code>default</code>
         * </p>
         * 
         * @param instanceTenancy
         *        The tenancy of the instances covered by the reservation. A Reserved Instance with a tenancy of
         *        <code>dedicated</code> is applied to instances that run in a VPC on single-tenant hardware (i.e.,
         *        Dedicated Instances).</p>
         *        <p>
         *        <b>Important:</b> The <code>host</code> value cannot be used with this parameter. Use the
         *        <code>default</code> or <code>dedicated</code> values only.
         *        </p>
         *        <p>
         *        Default: <code>default</code>
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder instanceTenancy(String instanceTenancy);

        /**
         * <p>
         * The tenancy of the instances covered by the reservation. A Reserved Instance with a tenancy of
         * <code>dedicated</code> is applied to instances that run in a VPC on single-tenant hardware (i.e., Dedicated
         * Instances).
         * </p>
         * <p>
         * <b>Important:</b> The <code>host</code> value cannot be used with this parameter. Use the
         * <code>default</code> or <code>dedicated</code> values only.
         * </p>
         * <p>
         * Default: <code>default</code>
         * </p>
         * 
         * @param instanceTenancy
         *        The tenancy of the instances covered by the reservation. A Reserved Instance with a tenancy of
         *        <code>dedicated</code> is applied to instances that run in a VPC on single-tenant hardware (i.e.,
         *        Dedicated Instances).</p>
         *        <p>
         *        <b>Important:</b> The <code>host</code> value cannot be used with this parameter. Use the
         *        <code>default</code> or <code>dedicated</code> values only.
         *        </p>
         *        <p>
         *        Default: <code>default</code>
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder instanceTenancy(Tenancy instanceTenancy);

        /**
         * <p>
         * The maximum number of results to return for the request in a single page. The remaining results of the
         * initial request can be seen by sending another request with the returned <code>NextToken</code> value. The
         * maximum is 100.
         * </p>
         * <p>
         * Default: 100
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return for the request in a single page. The remaining results of the
         *        initial request can be seen by sending another request with the returned <code>NextToken</code> value.
         *        The maximum is 100.</p>
         *        <p>
         *        Default: 100
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The Reserved Instance offering type. If you are using tools that predate the 2011-11-01 API version, you only
         * have access to the <code>Medium Utilization</code> Reserved Instance offering type.
         * </p>
         * 
         * @param offeringType
         *        The Reserved Instance offering type. If you are using tools that predate the 2011-11-01 API version,
         *        you only have access to the <code>Medium Utilization</code> Reserved Instance offering type.
         * @see OfferingTypeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingTypeValues
         */
        Builder offeringType(String offeringType);

        /**
         * <p>
         * The Reserved Instance offering type. If you are using tools that predate the 2011-11-01 API version, you only
         * have access to the <code>Medium Utilization</code> Reserved Instance offering type.
         * </p>
         * 
         * @param offeringType
         *        The Reserved Instance offering type. If you are using tools that predate the 2011-11-01 API version,
         *        you only have access to the <code>Medium Utilization</code> Reserved Instance offering type.
         * @see OfferingTypeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingTypeValues
         */
        Builder offeringType(OfferingTypeValues offeringType);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String availabilityZone;

        private List<Filter> filters;

        private Boolean includeMarketplace;

        private String instanceType;

        private Long maxDuration;

        private Integer maxInstanceCount;

        private Long minDuration;

        private String offeringClass;

        private String productDescription;

        private List<String> reservedInstancesOfferingIds;

        private String instanceTenancy;

        private Integer maxResults;

        private String nextToken;

        private String offeringType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesOfferingsRequest model) {
            availabilityZone(model.availabilityZone);
            filters(model.filters);
            includeMarketplace(model.includeMarketplace);
            instanceType(model.instanceType);
            maxDuration(model.maxDuration);
            maxInstanceCount(model.maxInstanceCount);
            minDuration(model.minDuration);
            offeringClass(model.offeringClass);
            productDescription(model.productDescription);
            reservedInstancesOfferingIds(model.reservedInstancesOfferingIds);
            instanceTenancy(model.instanceTenancy);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            offeringType(model.offeringType);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Boolean getIncludeMarketplace() {
            return includeMarketplace;
        }

        @Override
        public final Builder includeMarketplace(Boolean includeMarketplace) {
            this.includeMarketplace = includeMarketplace;
            return this;
        }

        public final void setIncludeMarketplace(Boolean includeMarketplace) {
            this.includeMarketplace = includeMarketplace;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Long getMaxDuration() {
            return maxDuration;
        }

        @Override
        public final Builder maxDuration(Long maxDuration) {
            this.maxDuration = maxDuration;
            return this;
        }

        public final void setMaxDuration(Long maxDuration) {
            this.maxDuration = maxDuration;
        }

        public final Integer getMaxInstanceCount() {
            return maxInstanceCount;
        }

        @Override
        public final Builder maxInstanceCount(Integer maxInstanceCount) {
            this.maxInstanceCount = maxInstanceCount;
            return this;
        }

        public final void setMaxInstanceCount(Integer maxInstanceCount) {
            this.maxInstanceCount = maxInstanceCount;
        }

        public final Long getMinDuration() {
            return minDuration;
        }

        @Override
        public final Builder minDuration(Long minDuration) {
            this.minDuration = minDuration;
            return this;
        }

        public final void setMinDuration(Long minDuration) {
            this.minDuration = minDuration;
        }

        public final String getOfferingClass() {
            return offeringClass;
        }

        @Override
        public final Builder offeringClass(String offeringClass) {
            this.offeringClass = offeringClass;
            return this;
        }

        @Override
        public final Builder offeringClass(OfferingClassType offeringClass) {
            this.offeringClass(offeringClass.toString());
            return this;
        }

        public final void setOfferingClass(String offeringClass) {
            this.offeringClass = offeringClass;
        }

        public final String getProductDescription() {
            return productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        @Override
        public final Builder productDescription(RIProductDescription productDescription) {
            this.productDescription(productDescription.toString());
            return this;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        public final Collection<String> getReservedInstancesOfferingIds() {
            return reservedInstancesOfferingIds;
        }

        @Override
        public final Builder reservedInstancesOfferingIds(Collection<String> reservedInstancesOfferingIds) {
            this.reservedInstancesOfferingIds = ReservedInstancesOfferingIdStringListCopier.copy(reservedInstancesOfferingIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesOfferingIds(String... reservedInstancesOfferingIds) {
            reservedInstancesOfferingIds(Arrays.asList(reservedInstancesOfferingIds));
            return this;
        }

        public final void setReservedInstancesOfferingIds(Collection<String> reservedInstancesOfferingIds) {
            this.reservedInstancesOfferingIds = ReservedInstancesOfferingIdStringListCopier.copy(reservedInstancesOfferingIds);
        }

        public final String getInstanceTenancy() {
            return instanceTenancy;
        }

        @Override
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        public final Builder instanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy.toString());
            return this;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getOfferingType() {
            return offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        @Override
        public final Builder offeringType(OfferingTypeValues offeringType) {
            this.offeringType(offeringType.toString());
            return this;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeReservedInstancesOfferingsRequest build() {
            return new DescribeReservedInstancesOfferingsRequest(this);
        }
    }
}
