/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeReservedInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeReservedInstancesRequest extends EC2Request implements
        ToCopyableBuilder<DescribeReservedInstancesRequest.Builder, DescribeReservedInstancesRequest> {
    private final List<Filter> filters;

    private final String offeringClass;

    private final List<String> reservedInstancesIds;

    private final String offeringType;

    private DescribeReservedInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.offeringClass = builder.offeringClass;
        this.reservedInstancesIds = builder.reservedInstancesIds;
        this.offeringType = builder.offeringType;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>availability-zone</code> - The Availability Zone where the Reserved Instance can be used.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>duration</code> - The duration of the Reserved Instance (one year or three years), in seconds (
     * <code>31536000</code> | <code>94608000</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>end</code> - The time when the Reserved Instance expires (for example, 2015-08-07T11:54:42.000Z).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fixed-price</code> - The purchase price of the Reserved Instance (for example, 9800.0).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-type</code> - The instance type that is covered by the reservation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>scope</code> - The scope of the Reserved Instance (<code>Region</code> or <code>Availability Zone</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>product-description</code> - The Reserved Instance product platform description. Instances that include
     * <code>(Amazon VPC)</code> in the product platform description will only be displayed to EC2-Classic account
     * holders and are for use with Amazon VPC (<code>Linux/UNIX</code> | <code>Linux/UNIX (Amazon VPC)</code> |
     * <code>SUSE Linux</code> | <code>SUSE Linux (Amazon VPC)</code> | <code>Red Hat Enterprise Linux</code> |
     * <code>Red Hat Enterprise Linux (Amazon VPC)</code> | <code>Windows</code> | <code>Windows (Amazon VPC)</code> |
     * <code>Windows with SQL Server Standard</code> | <code>Windows with SQL Server Standard (Amazon VPC)</code> |
     * <code>Windows with SQL Server Web</code> | <code>Windows with SQL Server Web (Amazon VPC)</code> |
     * <code>Windows with SQL Server Enterprise</code> | <code>Windows with SQL Server Enterprise (Amazon VPC)</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>reserved-instances-id</code> - The ID of the Reserved Instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>start</code> - The time at which the Reserved Instance purchase request was placed (for example,
     * 2014-08-07T11:54:42.000Z).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state</code> - The state of the Reserved Instance (<code>payment-pending</code> | <code>active</code> |
     * <code>payment-failed</code> | <code>retired</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource. Specify
     * the key of the tag in the filter name and the value of the tag in the filter value. For example, for the tag
     * Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
     * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
     * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value is),
     * and the tag value X (regardless of what the tag's key is). If you want to list only resources where Purpose is X,
     * see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
     * <code>tag-key</code> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>usage-price</code> - The usage price of the Reserved Instance, per hour (for example, 0.84).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>availability-zone</code> - The Availability Zone where the Reserved Instance can be used.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>duration</code> - The duration of the Reserved Instance (one year or three years), in seconds (
     *         <code>31536000</code> | <code>94608000</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>end</code> - The time when the Reserved Instance expires (for example, 2015-08-07T11:54:42.000Z).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fixed-price</code> - The purchase price of the Reserved Instance (for example, 9800.0).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-type</code> - The instance type that is covered by the reservation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>scope</code> - The scope of the Reserved Instance (<code>Region</code> or
     *         <code>Availability Zone</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>product-description</code> - The Reserved Instance product platform description. Instances that
     *         include <code>(Amazon VPC)</code> in the product platform description will only be displayed to
     *         EC2-Classic account holders and are for use with Amazon VPC (<code>Linux/UNIX</code> |
     *         <code>Linux/UNIX (Amazon VPC)</code> | <code>SUSE Linux</code> | <code>SUSE Linux (Amazon VPC)</code> |
     *         <code>Red Hat Enterprise Linux</code> | <code>Red Hat Enterprise Linux (Amazon VPC)</code> |
     *         <code>Windows</code> | <code>Windows (Amazon VPC)</code> | <code>Windows with SQL Server Standard</code>
     *         | <code>Windows with SQL Server Standard (Amazon VPC)</code> | <code>Windows with SQL Server Web</code> |
     *         <code>Windows with SQL Server Web (Amazon VPC)</code> | <code>Windows with SQL Server Enterprise</code> |
     *         <code>Windows with SQL Server Enterprise (Amazon VPC)</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>reserved-instances-id</code> - The ID of the Reserved Instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>start</code> - The time at which the Reserved Instance purchase request was placed (for example,
     *         2014-08-07T11:54:42.000Z).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state</code> - The state of the Reserved Instance (<code>payment-pending</code> |
     *         <code>active</code> | <code>payment-failed</code> | <code>retired</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
     *         Specify the key of the tag in the filter name and the value of the tag in the filter value. For example,
     *         for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the
     *         filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
     *         <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
     *         "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's
     *         value is), and the tag value X (regardless of what the tag's key is). If you want to list only resources
     *         where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
     *         <code>tag-key</code> filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>usage-price</code> - The usage price of the Reserved Instance, per hour (for example, 0.84).
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * Describes whether the Reserved Instance is Standard or Convertible.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringClass}
     * will return {@link OfferingClassType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #offeringClassString}.
     * </p>
     * 
     * @return Describes whether the Reserved Instance is Standard or Convertible.
     * @see OfferingClassType
     */
    public OfferingClassType offeringClass() {
        return OfferingClassType.fromValue(offeringClass);
    }

    /**
     * <p>
     * Describes whether the Reserved Instance is Standard or Convertible.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringClass}
     * will return {@link OfferingClassType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #offeringClassString}.
     * </p>
     * 
     * @return Describes whether the Reserved Instance is Standard or Convertible.
     * @see OfferingClassType
     */
    public String offeringClassString() {
        return offeringClass;
    }

    /**
     * <p>
     * One or more Reserved Instance IDs.
     * </p>
     * <p>
     * Default: Describes all your Reserved Instances, or only those otherwise specified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more Reserved Instance IDs.</p>
     *         <p>
     *         Default: Describes all your Reserved Instances, or only those otherwise specified.
     */
    public List<String> reservedInstancesIds() {
        return reservedInstancesIds;
    }

    /**
     * <p>
     * The Reserved Instance offering type. If you are using tools that predate the 2011-11-01 API version, you only
     * have access to the <code>Medium Utilization</code> Reserved Instance offering type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringType} will
     * return {@link OfferingTypeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #offeringTypeString}.
     * </p>
     * 
     * @return The Reserved Instance offering type. If you are using tools that predate the 2011-11-01 API version, you
     *         only have access to the <code>Medium Utilization</code> Reserved Instance offering type.
     * @see OfferingTypeValues
     */
    public OfferingTypeValues offeringType() {
        return OfferingTypeValues.fromValue(offeringType);
    }

    /**
     * <p>
     * The Reserved Instance offering type. If you are using tools that predate the 2011-11-01 API version, you only
     * have access to the <code>Medium Utilization</code> Reserved Instance offering type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringType} will
     * return {@link OfferingTypeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #offeringTypeString}.
     * </p>
     * 
     * @return The Reserved Instance offering type. If you are using tools that predate the 2011-11-01 API version, you
     *         only have access to the <code>Medium Utilization</code> Reserved Instance offering type.
     * @see OfferingTypeValues
     */
    public String offeringTypeString() {
        return offeringType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(offeringClassString());
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesIds());
        hashCode = 31 * hashCode + Objects.hashCode(offeringTypeString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesRequest)) {
            return false;
        }
        DescribeReservedInstancesRequest other = (DescribeReservedInstancesRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(offeringClassString(), other.offeringClassString())
                && Objects.equals(reservedInstancesIds(), other.reservedInstancesIds())
                && Objects.equals(offeringTypeString(), other.offeringTypeString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (offeringClassString() != null) {
            sb.append("OfferingClass: ").append(offeringClassString()).append(",");
        }
        if (reservedInstancesIds() != null) {
            sb.append("ReservedInstancesIds: ").append(reservedInstancesIds()).append(",");
        }
        if (offeringTypeString() != null) {
            sb.append("OfferingType: ").append(offeringTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "OfferingClass":
            return Optional.of(clazz.cast(offeringClassString()));
        case "ReservedInstancesIds":
            return Optional.of(clazz.cast(reservedInstancesIds()));
        case "OfferingType":
            return Optional.of(clazz.cast(offeringTypeString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, DescribeReservedInstancesRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone where the Reserved Instance can be used.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>duration</code> - The duration of the Reserved Instance (one year or three years), in seconds (
         * <code>31536000</code> | <code>94608000</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>end</code> - The time when the Reserved Instance expires (for example, 2015-08-07T11:54:42.000Z).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fixed-price</code> - The purchase price of the Reserved Instance (for example, 9800.0).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The instance type that is covered by the reservation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>scope</code> - The scope of the Reserved Instance (<code>Region</code> or
         * <code>Availability Zone</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-description</code> - The Reserved Instance product platform description. Instances that include
         * <code>(Amazon VPC)</code> in the product platform description will only be displayed to EC2-Classic account
         * holders and are for use with Amazon VPC (<code>Linux/UNIX</code> | <code>Linux/UNIX (Amazon VPC)</code> |
         * <code>SUSE Linux</code> | <code>SUSE Linux (Amazon VPC)</code> | <code>Red Hat Enterprise Linux</code> |
         * <code>Red Hat Enterprise Linux (Amazon VPC)</code> | <code>Windows</code> | <code>Windows (Amazon VPC)</code>
         * | <code>Windows with SQL Server Standard</code> | <code>Windows with SQL Server Standard (Amazon VPC)</code>
         * | <code>Windows with SQL Server Web</code> | <code>Windows with SQL Server Web (Amazon VPC)</code> |
         * <code>Windows with SQL Server Enterprise</code> |
         * <code>Windows with SQL Server Enterprise (Amazon VPC)</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reserved-instances-id</code> - The ID of the Reserved Instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>start</code> - The time at which the Reserved Instance purchase request was placed (for example,
         * 2014-08-07T11:54:42.000Z).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the Reserved Instance (<code>payment-pending</code> | <code>active</code> |
         * <code>payment-failed</code> | <code>retired</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * Specify the key of the tag in the filter name and the value of the tag in the filter value. For example, for
         * the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value
         * is), and the tag value X (regardless of what the tag's key is). If you want to list only resources where
         * Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>usage-price</code> - The usage price of the Reserved Instance, per hour (for example, 0.84).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone where the Reserved Instance can be used.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>duration</code> - The duration of the Reserved Instance (one year or three years), in seconds (
         *        <code>31536000</code> | <code>94608000</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>end</code> - The time when the Reserved Instance expires (for example,
         *        2015-08-07T11:54:42.000Z).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fixed-price</code> - The purchase price of the Reserved Instance (for example, 9800.0).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The instance type that is covered by the reservation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>scope</code> - The scope of the Reserved Instance (<code>Region</code> or
         *        <code>Availability Zone</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-description</code> - The Reserved Instance product platform description. Instances that
         *        include <code>(Amazon VPC)</code> in the product platform description will only be displayed to
         *        EC2-Classic account holders and are for use with Amazon VPC (<code>Linux/UNIX</code> |
         *        <code>Linux/UNIX (Amazon VPC)</code> | <code>SUSE Linux</code> | <code>SUSE Linux (Amazon VPC)</code>
         *        | <code>Red Hat Enterprise Linux</code> | <code>Red Hat Enterprise Linux (Amazon VPC)</code> |
         *        <code>Windows</code> | <code>Windows (Amazon VPC)</code> |
         *        <code>Windows with SQL Server Standard</code> |
         *        <code>Windows with SQL Server Standard (Amazon VPC)</code> | <code>Windows with SQL Server Web</code>
         *        | <code>Windows with SQL Server Web (Amazon VPC)</code> |
         *        <code>Windows with SQL Server Enterprise</code> |
         *        <code>Windows with SQL Server Enterprise (Amazon VPC)</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>reserved-instances-id</code> - The ID of the Reserved Instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>start</code> - The time at which the Reserved Instance purchase request was placed (for example,
         *        2014-08-07T11:54:42.000Z).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the Reserved Instance (<code>payment-pending</code> |
         *        <code>active</code> | <code>payment-failed</code> | <code>retired</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the
         *        resource. Specify the key of the tag in the filter name and the value of the tag in the filter value.
         *        For example, for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and
         *        <code>X</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         *        <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the
         *        filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the
         *        tag's value is), and the tag value X (regardless of what the tag's key is). If you want to list only
         *        resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of
         *        the <code>tag-key</code> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>usage-price</code> - The usage price of the Reserved Instance, per hour (for example, 0.84).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone where the Reserved Instance can be used.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>duration</code> - The duration of the Reserved Instance (one year or three years), in seconds (
         * <code>31536000</code> | <code>94608000</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>end</code> - The time when the Reserved Instance expires (for example, 2015-08-07T11:54:42.000Z).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fixed-price</code> - The purchase price of the Reserved Instance (for example, 9800.0).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The instance type that is covered by the reservation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>scope</code> - The scope of the Reserved Instance (<code>Region</code> or
         * <code>Availability Zone</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-description</code> - The Reserved Instance product platform description. Instances that include
         * <code>(Amazon VPC)</code> in the product platform description will only be displayed to EC2-Classic account
         * holders and are for use with Amazon VPC (<code>Linux/UNIX</code> | <code>Linux/UNIX (Amazon VPC)</code> |
         * <code>SUSE Linux</code> | <code>SUSE Linux (Amazon VPC)</code> | <code>Red Hat Enterprise Linux</code> |
         * <code>Red Hat Enterprise Linux (Amazon VPC)</code> | <code>Windows</code> | <code>Windows (Amazon VPC)</code>
         * | <code>Windows with SQL Server Standard</code> | <code>Windows with SQL Server Standard (Amazon VPC)</code>
         * | <code>Windows with SQL Server Web</code> | <code>Windows with SQL Server Web (Amazon VPC)</code> |
         * <code>Windows with SQL Server Enterprise</code> |
         * <code>Windows with SQL Server Enterprise (Amazon VPC)</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reserved-instances-id</code> - The ID of the Reserved Instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>start</code> - The time at which the Reserved Instance purchase request was placed (for example,
         * 2014-08-07T11:54:42.000Z).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the Reserved Instance (<code>payment-pending</code> | <code>active</code> |
         * <code>payment-failed</code> | <code>retired</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * Specify the key of the tag in the filter name and the value of the tag in the filter value. For example, for
         * the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value
         * is), and the tag value X (regardless of what the tag's key is). If you want to list only resources where
         * Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>usage-price</code> - The usage price of the Reserved Instance, per hour (for example, 0.84).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone where the Reserved Instance can be used.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>duration</code> - The duration of the Reserved Instance (one year or three years), in seconds (
         *        <code>31536000</code> | <code>94608000</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>end</code> - The time when the Reserved Instance expires (for example,
         *        2015-08-07T11:54:42.000Z).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fixed-price</code> - The purchase price of the Reserved Instance (for example, 9800.0).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The instance type that is covered by the reservation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>scope</code> - The scope of the Reserved Instance (<code>Region</code> or
         *        <code>Availability Zone</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-description</code> - The Reserved Instance product platform description. Instances that
         *        include <code>(Amazon VPC)</code> in the product platform description will only be displayed to
         *        EC2-Classic account holders and are for use with Amazon VPC (<code>Linux/UNIX</code> |
         *        <code>Linux/UNIX (Amazon VPC)</code> | <code>SUSE Linux</code> | <code>SUSE Linux (Amazon VPC)</code>
         *        | <code>Red Hat Enterprise Linux</code> | <code>Red Hat Enterprise Linux (Amazon VPC)</code> |
         *        <code>Windows</code> | <code>Windows (Amazon VPC)</code> |
         *        <code>Windows with SQL Server Standard</code> |
         *        <code>Windows with SQL Server Standard (Amazon VPC)</code> | <code>Windows with SQL Server Web</code>
         *        | <code>Windows with SQL Server Web (Amazon VPC)</code> |
         *        <code>Windows with SQL Server Enterprise</code> |
         *        <code>Windows with SQL Server Enterprise (Amazon VPC)</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>reserved-instances-id</code> - The ID of the Reserved Instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>start</code> - The time at which the Reserved Instance purchase request was placed (for example,
         *        2014-08-07T11:54:42.000Z).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the Reserved Instance (<code>payment-pending</code> |
         *        <code>active</code> | <code>payment-failed</code> | <code>retired</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the
         *        resource. Specify the key of the tag in the filter name and the value of the tag in the filter value.
         *        For example, for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and
         *        <code>X</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         *        <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the
         *        filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the
         *        tag's value is), and the tag value X (regardless of what the tag's key is). If you want to list only
         *        resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of
         *        the <code>tag-key</code> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>usage-price</code> - The usage price of the Reserved Instance, per hour (for example, 0.84).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * Describes whether the Reserved Instance is Standard or Convertible.
         * </p>
         * 
         * @param offeringClass
         *        Describes whether the Reserved Instance is Standard or Convertible.
         * @see OfferingClassType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingClassType
         */
        Builder offeringClass(String offeringClass);

        /**
         * <p>
         * Describes whether the Reserved Instance is Standard or Convertible.
         * </p>
         * 
         * @param offeringClass
         *        Describes whether the Reserved Instance is Standard or Convertible.
         * @see OfferingClassType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingClassType
         */
        Builder offeringClass(OfferingClassType offeringClass);

        /**
         * <p>
         * One or more Reserved Instance IDs.
         * </p>
         * <p>
         * Default: Describes all your Reserved Instances, or only those otherwise specified.
         * </p>
         * 
         * @param reservedInstancesIds
         *        One or more Reserved Instance IDs.</p>
         *        <p>
         *        Default: Describes all your Reserved Instances, or only those otherwise specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesIds(Collection<String> reservedInstancesIds);

        /**
         * <p>
         * One or more Reserved Instance IDs.
         * </p>
         * <p>
         * Default: Describes all your Reserved Instances, or only those otherwise specified.
         * </p>
         * 
         * @param reservedInstancesIds
         *        One or more Reserved Instance IDs.</p>
         *        <p>
         *        Default: Describes all your Reserved Instances, or only those otherwise specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesIds(String... reservedInstancesIds);

        /**
         * <p>
         * The Reserved Instance offering type. If you are using tools that predate the 2011-11-01 API version, you only
         * have access to the <code>Medium Utilization</code> Reserved Instance offering type.
         * </p>
         * 
         * @param offeringType
         *        The Reserved Instance offering type. If you are using tools that predate the 2011-11-01 API version,
         *        you only have access to the <code>Medium Utilization</code> Reserved Instance offering type.
         * @see OfferingTypeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingTypeValues
         */
        Builder offeringType(String offeringType);

        /**
         * <p>
         * The Reserved Instance offering type. If you are using tools that predate the 2011-11-01 API version, you only
         * have access to the <code>Medium Utilization</code> Reserved Instance offering type.
         * </p>
         * 
         * @param offeringType
         *        The Reserved Instance offering type. If you are using tools that predate the 2011-11-01 API version,
         *        you only have access to the <code>Medium Utilization</code> Reserved Instance offering type.
         * @see OfferingTypeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingTypeValues
         */
        Builder offeringType(OfferingTypeValues offeringType);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private List<Filter> filters;

        private String offeringClass;

        private List<String> reservedInstancesIds;

        private String offeringType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesRequest model) {
            filters(model.filters);
            offeringClass(model.offeringClass);
            reservedInstancesIds(model.reservedInstancesIds);
            offeringType(model.offeringType);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final String getOfferingClass() {
            return offeringClass;
        }

        @Override
        public final Builder offeringClass(String offeringClass) {
            this.offeringClass = offeringClass;
            return this;
        }

        @Override
        public final Builder offeringClass(OfferingClassType offeringClass) {
            this.offeringClass(offeringClass.toString());
            return this;
        }

        public final void setOfferingClass(String offeringClass) {
            this.offeringClass = offeringClass;
        }

        public final Collection<String> getReservedInstancesIds() {
            return reservedInstancesIds;
        }

        @Override
        public final Builder reservedInstancesIds(Collection<String> reservedInstancesIds) {
            this.reservedInstancesIds = ReservedInstancesIdStringListCopier.copy(reservedInstancesIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesIds(String... reservedInstancesIds) {
            reservedInstancesIds(Arrays.asList(reservedInstancesIds));
            return this;
        }

        public final void setReservedInstancesIds(Collection<String> reservedInstancesIds) {
            this.reservedInstancesIds = ReservedInstancesIdStringListCopier.copy(reservedInstancesIds);
        }

        public final String getOfferingType() {
            return offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        @Override
        public final Builder offeringType(OfferingTypeValues offeringType) {
            this.offeringType(offeringType.toString());
            return this;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeReservedInstancesRequest build() {
            return new DescribeReservedInstancesRequest(this);
        }
    }
}
