/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeSecurityGroupReferencesRequest extends EC2Request implements
        ToCopyableBuilder<DescribeSecurityGroupReferencesRequest.Builder, DescribeSecurityGroupReferencesRequest> {
    private final List<String> groupId;

    private DescribeSecurityGroupReferencesRequest(BuilderImpl builder) {
        super(builder);
        this.groupId = builder.groupId;
    }

    /**
     * <p>
     * One or more security group IDs in your account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more security group IDs in your account.
     */
    public List<String> groupId() {
        return groupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSecurityGroupReferencesRequest)) {
            return false;
        }
        DescribeSecurityGroupReferencesRequest other = (DescribeSecurityGroupReferencesRequest) obj;
        return Objects.equals(groupId(), other.groupId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (groupId() != null) {
            sb.append("GroupId: ").append(groupId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupId":
            return Optional.of(clazz.cast(groupId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, DescribeSecurityGroupReferencesRequest> {
        /**
         * <p>
         * One or more security group IDs in your account.
         * </p>
         * 
         * @param groupId
         *        One or more security group IDs in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(Collection<String> groupId);

        /**
         * <p>
         * One or more security group IDs in your account.
         * </p>
         * 
         * @param groupId
         *        One or more security group IDs in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String... groupId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private List<String> groupId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSecurityGroupReferencesRequest model) {
            groupId(model.groupId);
        }

        public final Collection<String> getGroupId() {
            return groupId;
        }

        @Override
        public final Builder groupId(Collection<String> groupId) {
            this.groupId = GroupIdsCopier.copy(groupId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupId(String... groupId) {
            groupId(Arrays.asList(groupId));
            return this;
        }

        public final void setGroupId(Collection<String> groupId) {
            this.groupId = GroupIdsCopier.copy(groupId);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeSecurityGroupReferencesRequest build() {
            return new DescribeSecurityGroupReferencesRequest(this);
        }
    }
}
