/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeSecurityGroups.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeSecurityGroupsRequest extends EC2Request implements
        ToCopyableBuilder<DescribeSecurityGroupsRequest.Builder, DescribeSecurityGroupsRequest> {
    private final List<Filter> filters;

    private final List<String> groupIds;

    private final List<String> groupNames;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeSecurityGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.groupIds = builder.groupIds;
        this.groupNames = builder.groupNames;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * One or more filters. If using multiple filters for rules, the results include security groups for which any
     * combination of rules - not necessarily a single rule - match all filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>description</code> - The description of the security group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>egress.ip-permission.cidr</code> - An IPv4 CIDR block for an outbound security group rule.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>egress.ip-permission.from-port</code> - For an outbound rule, the start of port range for the TCP and UDP
     * protocols, or an ICMP type number.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>egress.ip-permission.group-id</code> - The ID of a security group that has been referenced in an outbound
     * security group rule.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>egress.ip-permission.group-name</code> - The name of a security group that has been referenced in an
     * outbound security group rule.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>egress.ip-permission.ipv6-cidr</code> - An IPv6 CIDR block for an outbound security group rule.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>egress.ip-permission.prefix-list-id</code> - The ID (prefix) of the AWS service to which a security group
     * rule allows outbound access.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>egress.ip-permission.protocol</code> - The IP protocol for an outbound security group rule (
     * <code>tcp</code> | <code>udp</code> | <code>icmp</code> or a protocol number).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>egress.ip-permission.to-port</code> - For an outbound rule, the end of port range for the TCP and UDP
     * protocols, or an ICMP code.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>egress.ip-permission.user-id</code> - The ID of an AWS account that has been referenced in an outbound
     * security group rule.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>group-id</code> - The ID of the security group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>group-name</code> - The name of the security group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ip-permission.cidr</code> - An IPv4 CIDR block for an inbound security group rule.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ip-permission.from-port</code> - For an inbound rule, the start of port range for the TCP and UDP
     * protocols, or an ICMP type number.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ip-permission.group-id</code> - The ID of a security group that has been referenced in an inbound security
     * group rule.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ip-permission.group-name</code> - The name of a security group that has been referenced in an inbound
     * security group rule.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ip-permission.ipv6-cidr</code> - An IPv6 CIDR block for an inbound security group rule.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ip-permission.prefix-list-id</code> - The ID (prefix) of the AWS service from which a security group rule
     * allows inbound access.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ip-permission.protocol</code> - The IP protocol for an inbound security group rule (<code>tcp</code> |
     * <code>udp</code> | <code>icmp</code> or a protocol number).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ip-permission.to-port</code> - For an inbound rule, the end of port range for the TCP and UDP protocols, or
     * an ICMP code.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ip-permission.user-id</code> - The ID of an AWS account that has been referenced in an inbound security
     * group rule.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>owner-id</code> - The AWS account ID of the owner of the security group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the security group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-value</code> - The value of a tag assigned to the security group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-id</code> - The ID of the VPC specified when the security group was created.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters. If using multiple filters for rules, the results include security groups for which
     *         any combination of rules - not necessarily a single rule - match all filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>description</code> - The description of the security group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>egress.ip-permission.cidr</code> - An IPv4 CIDR block for an outbound security group rule.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>egress.ip-permission.from-port</code> - For an outbound rule, the start of port range for the TCP
     *         and UDP protocols, or an ICMP type number.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>egress.ip-permission.group-id</code> - The ID of a security group that has been referenced in an
     *         outbound security group rule.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>egress.ip-permission.group-name</code> - The name of a security group that has been referenced in
     *         an outbound security group rule.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>egress.ip-permission.ipv6-cidr</code> - An IPv6 CIDR block for an outbound security group rule.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>egress.ip-permission.prefix-list-id</code> - The ID (prefix) of the AWS service to which a security
     *         group rule allows outbound access.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>egress.ip-permission.protocol</code> - The IP protocol for an outbound security group rule (
     *         <code>tcp</code> | <code>udp</code> | <code>icmp</code> or a protocol number).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>egress.ip-permission.to-port</code> - For an outbound rule, the end of port range for the TCP and
     *         UDP protocols, or an ICMP code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>egress.ip-permission.user-id</code> - The ID of an AWS account that has been referenced in an
     *         outbound security group rule.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>group-id</code> - The ID of the security group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>group-name</code> - The name of the security group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ip-permission.cidr</code> - An IPv4 CIDR block for an inbound security group rule.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ip-permission.from-port</code> - For an inbound rule, the start of port range for the TCP and UDP
     *         protocols, or an ICMP type number.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ip-permission.group-id</code> - The ID of a security group that has been referenced in an inbound
     *         security group rule.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ip-permission.group-name</code> - The name of a security group that has been referenced in an
     *         inbound security group rule.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ip-permission.ipv6-cidr</code> - An IPv6 CIDR block for an inbound security group rule.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ip-permission.prefix-list-id</code> - The ID (prefix) of the AWS service from which a security
     *         group rule allows inbound access.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ip-permission.protocol</code> - The IP protocol for an inbound security group rule (
     *         <code>tcp</code> | <code>udp</code> | <code>icmp</code> or a protocol number).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ip-permission.to-port</code> - For an inbound rule, the end of port range for the TCP and UDP
     *         protocols, or an ICMP code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ip-permission.user-id</code> - The ID of an AWS account that has been referenced in an inbound
     *         security group rule.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>owner-id</code> - The AWS account ID of the owner of the security group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the security group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-value</code> - The value of a tag assigned to the security group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vpc-id</code> - The ID of the VPC specified when the security group was created.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * One or more security group IDs. Required for security groups in a nondefault VPC.
     * </p>
     * <p>
     * Default: Describes all your security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more security group IDs. Required for security groups in a nondefault VPC.</p>
     *         <p>
     *         Default: Describes all your security groups.
     */
    public List<String> groupIds() {
        return groupIds;
    }

    /**
     * <p>
     * [EC2-Classic and default VPC only] One or more security group names. You can specify either the security group
     * name or the security group ID. For security groups in a nondefault VPC, use the <code>group-name</code> filter to
     * describe security groups by name.
     * </p>
     * <p>
     * Default: Describes all your security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return [EC2-Classic and default VPC only] One or more security group names. You can specify either the security
     *         group name or the security group ID. For security groups in a nondefault VPC, use the
     *         <code>group-name</code> filter to describe security groups by name.</p>
     *         <p>
     *         Default: Describes all your security groups.
     */
    public List<String> groupNames() {
        return groupNames;
    }

    /**
     * <p>
     * The token to request the next page of results.
     * </p>
     * 
     * @return The token to request the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. To retrieve the remaining results, make another request
     * with the returned <code>NextToken</code> value. This value can be between 5 and 1000.
     * </p>
     * 
     * @return The maximum number of results to return in a single call. To retrieve the remaining results, make another
     *         request with the returned <code>NextToken</code> value. This value can be between 5 and 1000.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(groupIds());
        hashCode = 31 * hashCode + Objects.hashCode(groupNames());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSecurityGroupsRequest)) {
            return false;
        }
        DescribeSecurityGroupsRequest other = (DescribeSecurityGroupsRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(groupIds(), other.groupIds())
                && Objects.equals(groupNames(), other.groupNames()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (groupIds() != null) {
            sb.append("GroupIds: ").append(groupIds()).append(",");
        }
        if (groupNames() != null) {
            sb.append("GroupNames: ").append(groupNames()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "GroupIds":
            return Optional.of(clazz.cast(groupIds()));
        case "GroupNames":
            return Optional.of(clazz.cast(groupNames()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.of(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, DescribeSecurityGroupsRequest> {
        /**
         * <p>
         * One or more filters. If using multiple filters for rules, the results include security groups for which any
         * combination of rules - not necessarily a single rule - match all filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>description</code> - The description of the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.cidr</code> - An IPv4 CIDR block for an outbound security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.from-port</code> - For an outbound rule, the start of port range for the TCP and
         * UDP protocols, or an ICMP type number.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.group-id</code> - The ID of a security group that has been referenced in an
         * outbound security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.group-name</code> - The name of a security group that has been referenced in an
         * outbound security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.ipv6-cidr</code> - An IPv6 CIDR block for an outbound security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.prefix-list-id</code> - The ID (prefix) of the AWS service to which a security
         * group rule allows outbound access.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.protocol</code> - The IP protocol for an outbound security group rule (
         * <code>tcp</code> | <code>udp</code> | <code>icmp</code> or a protocol number).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.to-port</code> - For an outbound rule, the end of port range for the TCP and UDP
         * protocols, or an ICMP code.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.user-id</code> - The ID of an AWS account that has been referenced in an outbound
         * security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-id</code> - The ID of the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-name</code> - The name of the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.cidr</code> - An IPv4 CIDR block for an inbound security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.from-port</code> - For an inbound rule, the start of port range for the TCP and UDP
         * protocols, or an ICMP type number.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.group-id</code> - The ID of a security group that has been referenced in an inbound
         * security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.group-name</code> - The name of a security group that has been referenced in an inbound
         * security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.ipv6-cidr</code> - An IPv6 CIDR block for an inbound security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.prefix-list-id</code> - The ID (prefix) of the AWS service from which a security group
         * rule allows inbound access.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.protocol</code> - The IP protocol for an inbound security group rule (<code>tcp</code> |
         * <code>udp</code> | <code>icmp</code> or a protocol number).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.to-port</code> - For an inbound rule, the end of port range for the TCP and UDP
         * protocols, or an ICMP code.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.user-id</code> - The ID of an AWS account that has been referenced in an inbound security
         * group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The AWS account ID of the owner of the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC specified when the security group was created.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters. If using multiple filters for rules, the results include security groups for
         *        which any combination of rules - not necessarily a single rule - match all filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>description</code> - The description of the security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.cidr</code> - An IPv4 CIDR block for an outbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.from-port</code> - For an outbound rule, the start of port range for the
         *        TCP and UDP protocols, or an ICMP type number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.group-id</code> - The ID of a security group that has been referenced in an
         *        outbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.group-name</code> - The name of a security group that has been referenced
         *        in an outbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.ipv6-cidr</code> - An IPv6 CIDR block for an outbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.prefix-list-id</code> - The ID (prefix) of the AWS service to which a
         *        security group rule allows outbound access.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.protocol</code> - The IP protocol for an outbound security group rule (
         *        <code>tcp</code> | <code>udp</code> | <code>icmp</code> or a protocol number).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.to-port</code> - For an outbound rule, the end of port range for the TCP
         *        and UDP protocols, or an ICMP code.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.user-id</code> - The ID of an AWS account that has been referenced in an
         *        outbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>group-id</code> - The ID of the security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>group-name</code> - The name of the security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.cidr</code> - An IPv4 CIDR block for an inbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.from-port</code> - For an inbound rule, the start of port range for the TCP and
         *        UDP protocols, or an ICMP type number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.group-id</code> - The ID of a security group that has been referenced in an
         *        inbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.group-name</code> - The name of a security group that has been referenced in an
         *        inbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.ipv6-cidr</code> - An IPv6 CIDR block for an inbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.prefix-list-id</code> - The ID (prefix) of the AWS service from which a security
         *        group rule allows inbound access.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.protocol</code> - The IP protocol for an inbound security group rule (
         *        <code>tcp</code> | <code>udp</code> | <code>icmp</code> or a protocol number).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.to-port</code> - For an inbound rule, the end of port range for the TCP and UDP
         *        protocols, or an ICMP code.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.user-id</code> - The ID of an AWS account that has been referenced in an inbound
         *        security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The AWS account ID of the owner of the security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC specified when the security group was created.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters. If using multiple filters for rules, the results include security groups for which any
         * combination of rules - not necessarily a single rule - match all filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>description</code> - The description of the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.cidr</code> - An IPv4 CIDR block for an outbound security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.from-port</code> - For an outbound rule, the start of port range for the TCP and
         * UDP protocols, or an ICMP type number.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.group-id</code> - The ID of a security group that has been referenced in an
         * outbound security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.group-name</code> - The name of a security group that has been referenced in an
         * outbound security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.ipv6-cidr</code> - An IPv6 CIDR block for an outbound security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.prefix-list-id</code> - The ID (prefix) of the AWS service to which a security
         * group rule allows outbound access.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.protocol</code> - The IP protocol for an outbound security group rule (
         * <code>tcp</code> | <code>udp</code> | <code>icmp</code> or a protocol number).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.to-port</code> - For an outbound rule, the end of port range for the TCP and UDP
         * protocols, or an ICMP code.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress.ip-permission.user-id</code> - The ID of an AWS account that has been referenced in an outbound
         * security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-id</code> - The ID of the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-name</code> - The name of the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.cidr</code> - An IPv4 CIDR block for an inbound security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.from-port</code> - For an inbound rule, the start of port range for the TCP and UDP
         * protocols, or an ICMP type number.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.group-id</code> - The ID of a security group that has been referenced in an inbound
         * security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.group-name</code> - The name of a security group that has been referenced in an inbound
         * security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.ipv6-cidr</code> - An IPv6 CIDR block for an inbound security group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.prefix-list-id</code> - The ID (prefix) of the AWS service from which a security group
         * rule allows inbound access.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.protocol</code> - The IP protocol for an inbound security group rule (<code>tcp</code> |
         * <code>udp</code> | <code>icmp</code> or a protocol number).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.to-port</code> - For an inbound rule, the end of port range for the TCP and UDP
         * protocols, or an ICMP code.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-permission.user-id</code> - The ID of an AWS account that has been referenced in an inbound security
         * group rule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The AWS account ID of the owner of the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC specified when the security group was created.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters. If using multiple filters for rules, the results include security groups for
         *        which any combination of rules - not necessarily a single rule - match all filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>description</code> - The description of the security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.cidr</code> - An IPv4 CIDR block for an outbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.from-port</code> - For an outbound rule, the start of port range for the
         *        TCP and UDP protocols, or an ICMP type number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.group-id</code> - The ID of a security group that has been referenced in an
         *        outbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.group-name</code> - The name of a security group that has been referenced
         *        in an outbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.ipv6-cidr</code> - An IPv6 CIDR block for an outbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.prefix-list-id</code> - The ID (prefix) of the AWS service to which a
         *        security group rule allows outbound access.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.protocol</code> - The IP protocol for an outbound security group rule (
         *        <code>tcp</code> | <code>udp</code> | <code>icmp</code> or a protocol number).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.to-port</code> - For an outbound rule, the end of port range for the TCP
         *        and UDP protocols, or an ICMP code.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress.ip-permission.user-id</code> - The ID of an AWS account that has been referenced in an
         *        outbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>group-id</code> - The ID of the security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>group-name</code> - The name of the security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.cidr</code> - An IPv4 CIDR block for an inbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.from-port</code> - For an inbound rule, the start of port range for the TCP and
         *        UDP protocols, or an ICMP type number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.group-id</code> - The ID of a security group that has been referenced in an
         *        inbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.group-name</code> - The name of a security group that has been referenced in an
         *        inbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.ipv6-cidr</code> - An IPv6 CIDR block for an inbound security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.prefix-list-id</code> - The ID (prefix) of the AWS service from which a security
         *        group rule allows inbound access.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.protocol</code> - The IP protocol for an inbound security group rule (
         *        <code>tcp</code> | <code>udp</code> | <code>icmp</code> or a protocol number).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.to-port</code> - For an inbound rule, the end of port range for the TCP and UDP
         *        protocols, or an ICMP code.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-permission.user-id</code> - The ID of an AWS account that has been referenced in an inbound
         *        security group rule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The AWS account ID of the owner of the security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC specified when the security group was created.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more security group IDs. Required for security groups in a nondefault VPC.
         * </p>
         * <p>
         * Default: Describes all your security groups.
         * </p>
         * 
         * @param groupIds
         *        One or more security group IDs. Required for security groups in a nondefault VPC.</p>
         *        <p>
         *        Default: Describes all your security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupIds(Collection<String> groupIds);

        /**
         * <p>
         * One or more security group IDs. Required for security groups in a nondefault VPC.
         * </p>
         * <p>
         * Default: Describes all your security groups.
         * </p>
         * 
         * @param groupIds
         *        One or more security group IDs. Required for security groups in a nondefault VPC.</p>
         *        <p>
         *        Default: Describes all your security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupIds(String... groupIds);

        /**
         * <p>
         * [EC2-Classic and default VPC only] One or more security group names. You can specify either the security
         * group name or the security group ID. For security groups in a nondefault VPC, use the <code>group-name</code>
         * filter to describe security groups by name.
         * </p>
         * <p>
         * Default: Describes all your security groups.
         * </p>
         * 
         * @param groupNames
         *        [EC2-Classic and default VPC only] One or more security group names. You can specify either the
         *        security group name or the security group ID. For security groups in a nondefault VPC, use the
         *        <code>group-name</code> filter to describe security groups by name.</p>
         *        <p>
         *        Default: Describes all your security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupNames(Collection<String> groupNames);

        /**
         * <p>
         * [EC2-Classic and default VPC only] One or more security group names. You can specify either the security
         * group name or the security group ID. For security groups in a nondefault VPC, use the <code>group-name</code>
         * filter to describe security groups by name.
         * </p>
         * <p>
         * Default: Describes all your security groups.
         * </p>
         * 
         * @param groupNames
         *        [EC2-Classic and default VPC only] One or more security group names. You can specify either the
         *        security group name or the security group ID. For security groups in a nondefault VPC, use the
         *        <code>group-name</code> filter to describe security groups by name.</p>
         *        <p>
         *        Default: Describes all your security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupNames(String... groupNames);

        /**
         * <p>
         * The token to request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return in a single call. To retrieve the remaining results, make another
         * request with the returned <code>NextToken</code> value. This value can be between 5 and 1000.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call. To retrieve the remaining results, make
         *        another request with the returned <code>NextToken</code> value. This value can be between 5 and 1000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private List<Filter> filters;

        private List<String> groupIds;

        private List<String> groupNames;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSecurityGroupsRequest model) {
            filters(model.filters);
            groupIds(model.groupIds);
            groupNames(model.groupNames);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getGroupIds() {
            return groupIds;
        }

        @Override
        public final Builder groupIds(Collection<String> groupIds) {
            this.groupIds = GroupIdStringListCopier.copy(groupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupIds(String... groupIds) {
            groupIds(Arrays.asList(groupIds));
            return this;
        }

        public final void setGroupIds(Collection<String> groupIds) {
            this.groupIds = GroupIdStringListCopier.copy(groupIds);
        }

        public final Collection<String> getGroupNames() {
            return groupNames;
        }

        @Override
        public final Builder groupNames(Collection<String> groupNames) {
            this.groupNames = GroupNameStringListCopier.copy(groupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupNames(String... groupNames) {
            groupNames(Arrays.asList(groupNames));
            return this;
        }

        public final void setGroupNames(Collection<String> groupNames) {
            this.groupNames = GroupNameStringListCopier.copy(groupNames);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeSecurityGroupsRequest build() {
            return new DescribeSecurityGroupsRequest(this);
        }
    }
}
