/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeSpotDatafeedSubscription.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeSpotDatafeedSubscriptionResponse extends EC2Response implements
        ToCopyableBuilder<DescribeSpotDatafeedSubscriptionResponse.Builder, DescribeSpotDatafeedSubscriptionResponse> {
    private final SpotDatafeedSubscription spotDatafeedSubscription;

    private DescribeSpotDatafeedSubscriptionResponse(BuilderImpl builder) {
        super(builder);
        this.spotDatafeedSubscription = builder.spotDatafeedSubscription;
    }

    /**
     * <p>
     * The Spot instance data feed subscription.
     * </p>
     * 
     * @return The Spot instance data feed subscription.
     */
    public SpotDatafeedSubscription spotDatafeedSubscription() {
        return spotDatafeedSubscription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(spotDatafeedSubscription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotDatafeedSubscriptionResponse)) {
            return false;
        }
        DescribeSpotDatafeedSubscriptionResponse other = (DescribeSpotDatafeedSubscriptionResponse) obj;
        return Objects.equals(spotDatafeedSubscription(), other.spotDatafeedSubscription());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (spotDatafeedSubscription() != null) {
            sb.append("SpotDatafeedSubscription: ").append(spotDatafeedSubscription()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SpotDatafeedSubscription":
            return Optional.of(clazz.cast(spotDatafeedSubscription()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeSpotDatafeedSubscriptionResponse> {
        /**
         * <p>
         * The Spot instance data feed subscription.
         * </p>
         * 
         * @param spotDatafeedSubscription
         *        The Spot instance data feed subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotDatafeedSubscription(SpotDatafeedSubscription spotDatafeedSubscription);

        /**
         * <p>
         * The Spot instance data feed subscription.
         * </p>
         * This is a convenience that creates an instance of the {@link SpotDatafeedSubscription.Builder} avoiding the
         * need to create one manually via {@link SpotDatafeedSubscription#builder()}.
         *
         * When the {@link Consumer} completes, {@link SpotDatafeedSubscription.Builder#build()} is called immediately
         * and its result is passed to {@link #spotDatafeedSubscription(SpotDatafeedSubscription)}.
         * 
         * @param spotDatafeedSubscription
         *        a consumer that will call methods on {@link SpotDatafeedSubscription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spotDatafeedSubscription(SpotDatafeedSubscription)
         */
        default Builder spotDatafeedSubscription(Consumer<SpotDatafeedSubscription.Builder> spotDatafeedSubscription) {
            return spotDatafeedSubscription(SpotDatafeedSubscription.builder().apply(spotDatafeedSubscription).build());
        }
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private SpotDatafeedSubscription spotDatafeedSubscription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpotDatafeedSubscriptionResponse model) {
            spotDatafeedSubscription(model.spotDatafeedSubscription);
        }

        public final SpotDatafeedSubscription.Builder getSpotDatafeedSubscription() {
            return spotDatafeedSubscription != null ? spotDatafeedSubscription.toBuilder() : null;
        }

        @Override
        public final Builder spotDatafeedSubscription(SpotDatafeedSubscription spotDatafeedSubscription) {
            this.spotDatafeedSubscription = spotDatafeedSubscription;
            return this;
        }

        public final void setSpotDatafeedSubscription(SpotDatafeedSubscription.BuilderImpl spotDatafeedSubscription) {
            this.spotDatafeedSubscription = spotDatafeedSubscription != null ? spotDatafeedSubscription.build() : null;
        }

        @Override
        public DescribeSpotDatafeedSubscriptionResponse build() {
            return new DescribeSpotDatafeedSubscriptionResponse(this);
        }
    }
}
