/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeSpotFleetInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeSpotFleetInstancesResponse extends EC2Response implements
        ToCopyableBuilder<DescribeSpotFleetInstancesResponse.Builder, DescribeSpotFleetInstancesResponse> {
    private final List<ActiveInstance> activeInstances;

    private final String nextToken;

    private final String spotFleetRequestId;

    private DescribeSpotFleetInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.activeInstances = builder.activeInstances;
        this.nextToken = builder.nextToken;
        this.spotFleetRequestId = builder.spotFleetRequestId;
    }

    /**
     * <p>
     * The running instances. Note that this list is refreshed periodically and might be out of date.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The running instances. Note that this list is refreshed periodically and might be out of date.
     */
    public List<ActiveInstance> activeInstances() {
        return activeInstances;
    }

    /**
     * <p>
     * The token required to retrieve the next set of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token required to retrieve the next set of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The ID of the Spot fleet request.
     * </p>
     * 
     * @return The ID of the Spot fleet request.
     */
    public String spotFleetRequestId() {
        return spotFleetRequestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activeInstances());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(spotFleetRequestId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotFleetInstancesResponse)) {
            return false;
        }
        DescribeSpotFleetInstancesResponse other = (DescribeSpotFleetInstancesResponse) obj;
        return Objects.equals(activeInstances(), other.activeInstances()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(spotFleetRequestId(), other.spotFleetRequestId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (activeInstances() != null) {
            sb.append("ActiveInstances: ").append(activeInstances()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (spotFleetRequestId() != null) {
            sb.append("SpotFleetRequestId: ").append(spotFleetRequestId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActiveInstances":
            return Optional.of(clazz.cast(activeInstances()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "SpotFleetRequestId":
            return Optional.of(clazz.cast(spotFleetRequestId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeSpotFleetInstancesResponse> {
        /**
         * <p>
         * The running instances. Note that this list is refreshed periodically and might be out of date.
         * </p>
         * 
         * @param activeInstances
         *        The running instances. Note that this list is refreshed periodically and might be out of date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeInstances(Collection<ActiveInstance> activeInstances);

        /**
         * <p>
         * The running instances. Note that this list is refreshed periodically and might be out of date.
         * </p>
         * 
         * @param activeInstances
         *        The running instances. Note that this list is refreshed periodically and might be out of date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeInstances(ActiveInstance... activeInstances);

        /**
         * <p>
         * The token required to retrieve the next set of results. This value is <code>null</code> when there are no
         * more results to return.
         * </p>
         * 
         * @param nextToken
         *        The token required to retrieve the next set of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The ID of the Spot fleet request.
         * </p>
         * 
         * @param spotFleetRequestId
         *        The ID of the Spot fleet request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotFleetRequestId(String spotFleetRequestId);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<ActiveInstance> activeInstances;

        private String nextToken;

        private String spotFleetRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpotFleetInstancesResponse model) {
            activeInstances(model.activeInstances);
            nextToken(model.nextToken);
            spotFleetRequestId(model.spotFleetRequestId);
        }

        public final Collection<ActiveInstance.Builder> getActiveInstances() {
            return activeInstances != null ? activeInstances.stream().map(ActiveInstance::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder activeInstances(Collection<ActiveInstance> activeInstances) {
            this.activeInstances = ActiveInstanceSetCopier.copy(activeInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeInstances(ActiveInstance... activeInstances) {
            activeInstances(Arrays.asList(activeInstances));
            return this;
        }

        public final void setActiveInstances(Collection<ActiveInstance.BuilderImpl> activeInstances) {
            this.activeInstances = ActiveInstanceSetCopier.copyFromBuilder(activeInstances);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getSpotFleetRequestId() {
            return spotFleetRequestId;
        }

        @Override
        public final Builder spotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
            return this;
        }

        public final void setSpotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
        }

        @Override
        public DescribeSpotFleetInstancesResponse build() {
            return new DescribeSpotFleetInstancesResponse(this);
        }
    }
}
