/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeSpotInstanceRequests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeSpotInstanceRequestsRequest extends EC2Request implements
        ToCopyableBuilder<DescribeSpotInstanceRequestsRequest.Builder, DescribeSpotInstanceRequestsRequest> {
    private final List<Filter> filters;

    private final List<String> spotInstanceRequestIds;

    private DescribeSpotInstanceRequestsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.spotInstanceRequestIds = builder.spotInstanceRequestIds;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>availability-zone-group</code> - The Availability Zone group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>create-time</code> - The time stamp when the Spot instance request was created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fault-code</code> - The fault code related to the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fault-message</code> - The fault message related to the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-id</code> - The ID of the instance that fulfilled the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launch-group</code> - The Spot instance launch group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launch.block-device-mapping.delete-on-termination</code> - Indicates whether the EBS volume is deleted on
     * instance termination.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launch.block-device-mapping.device-name</code> - The device name for the volume in the block device mapping
     * (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launch.block-device-mapping.snapshot-id</code> - The ID of the snapshot for the EBS volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launch.block-device-mapping.volume-size</code> - The size of the EBS volume, in GiB.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launch.block-device-mapping.volume-type</code> - The type of EBS volume: <code>gp2</code> for General
     * Purpose SSD, <code>io1</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized HDD,
     * <code>sc1</code>for Cold HDD, or <code>standard</code> for Magnetic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launch.group-id</code> - The security group for the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launch.image-id</code> - The ID of the AMI.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launch.instance-type</code> - The type of instance (for example, <code>m3.medium</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launch.kernel-id</code> - The kernel ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launch.key-name</code> - The name of the key pair the instance launched with.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launch.monitoring-enabled</code> - Whether detailed monitoring is enabled for the Spot instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launch.ramdisk-id</code> - The RAM disk ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launched-availability-zone</code> - The Availability Zone in which the bid is launched.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.addresses.primary</code> - Indicates whether the IP address is the primary private IP
     * address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.delete-on-termination</code> - Indicates whether the network interface is deleted when
     * the instance is terminated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.description</code> - A description of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.device-index</code> - The index of the device for the network interface attachment on the
     * instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.group-id</code> - The ID of the security group associated with the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.network-interface-id</code> - The ID of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.private-ip-address</code> - The primary private IP address of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.subnet-id</code> - The ID of the subnet for the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>product-description</code> - The product description associated with the instance (<code>Linux/UNIX</code>
     * | <code>Windows</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>spot-instance-request-id</code> - The Spot instance request ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>spot-price</code> - The maximum hourly price for any Spot instance launched to fulfill the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state</code> - The state of the Spot instance request (<code>open</code> | <code>active</code> |
     * <code>closed</code> | <code>cancelled</code> | <code>failed</code>). Spot bid status information can help you
     * track your Amazon EC2 Spot instance requests. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html">Spot Bid Status</a> in the Amazon
     * Elastic Compute Cloud User Guide.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>status-code</code> - The short code describing the most recent evaluation of your Spot instance request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>status-message</code> - The message explaining the status of the Spot instance request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource. Specify
     * the key of the tag in the filter name and the value of the tag in the filter value. For example, for the tag
     * Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
     * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
     * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value is),
     * and the tag value X (regardless of what the tag's key is). If you want to list only resources where Purpose is X,
     * see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
     * <code>tag-key</code> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>type</code> - The type of Spot instance request (<code>one-time</code> | <code>persistent</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>valid-from</code> - The start date of the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>valid-until</code> - The end date of the request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>availability-zone-group</code> - The Availability Zone group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>create-time</code> - The time stamp when the Spot instance request was created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fault-code</code> - The fault code related to the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fault-message</code> - The fault message related to the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-id</code> - The ID of the instance that fulfilled the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launch-group</code> - The Spot instance launch group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launch.block-device-mapping.delete-on-termination</code> - Indicates whether the EBS volume is
     *         deleted on instance termination.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launch.block-device-mapping.device-name</code> - The device name for the volume in the block device
     *         mapping (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launch.block-device-mapping.snapshot-id</code> - The ID of the snapshot for the EBS volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launch.block-device-mapping.volume-size</code> - The size of the EBS volume, in GiB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launch.block-device-mapping.volume-type</code> - The type of EBS volume: <code>gp2</code> for
     *         General Purpose SSD, <code>io1</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized
     *         HDD, <code>sc1</code>for Cold HDD, or <code>standard</code> for Magnetic.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launch.group-id</code> - The security group for the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launch.image-id</code> - The ID of the AMI.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launch.instance-type</code> - The type of instance (for example, <code>m3.medium</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launch.kernel-id</code> - The kernel ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launch.key-name</code> - The name of the key pair the instance launched with.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launch.monitoring-enabled</code> - Whether detailed monitoring is enabled for the Spot instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launch.ramdisk-id</code> - The RAM disk ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launched-availability-zone</code> - The Availability Zone in which the bid is launched.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.addresses.primary</code> - Indicates whether the IP address is the primary
     *         private IP address.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.delete-on-termination</code> - Indicates whether the network interface is deleted
     *         when the instance is terminated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.description</code> - A description of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.device-index</code> - The index of the device for the network interface
     *         attachment on the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.group-id</code> - The ID of the security group associated with the network
     *         interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.network-interface-id</code> - The ID of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.private-ip-address</code> - The primary private IP address of the network
     *         interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.subnet-id</code> - The ID of the subnet for the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>product-description</code> - The product description associated with the instance (
     *         <code>Linux/UNIX</code> | <code>Windows</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>spot-instance-request-id</code> - The Spot instance request ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>spot-price</code> - The maximum hourly price for any Spot instance launched to fulfill the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state</code> - The state of the Spot instance request (<code>open</code> | <code>active</code> |
     *         <code>closed</code> | <code>cancelled</code> | <code>failed</code>). Spot bid status information can help
     *         you track your Amazon EC2 Spot instance requests. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html">Spot Bid Status</a> in the
     *         Amazon Elastic Compute Cloud User Guide.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>status-code</code> - The short code describing the most recent evaluation of your Spot instance
     *         request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>status-message</code> - The message explaining the status of the Spot instance request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
     *         Specify the key of the tag in the filter name and the value of the tag in the filter value. For example,
     *         for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the
     *         filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
     *         <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
     *         "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's
     *         value is), and the tag value X (regardless of what the tag's key is). If you want to list only resources
     *         where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
     *         <code>tag-key</code> filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>type</code> - The type of Spot instance request (<code>one-time</code> | <code>persistent</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>valid-from</code> - The start date of the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>valid-until</code> - The end date of the request.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * One or more Spot instance request IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more Spot instance request IDs.
     */
    public List<String> spotInstanceRequestIds() {
        return spotInstanceRequestIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(spotInstanceRequestIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotInstanceRequestsRequest)) {
            return false;
        }
        DescribeSpotInstanceRequestsRequest other = (DescribeSpotInstanceRequestsRequest) obj;
        return Objects.equals(filters(), other.filters())
                && Objects.equals(spotInstanceRequestIds(), other.spotInstanceRequestIds());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (spotInstanceRequestIds() != null) {
            sb.append("SpotInstanceRequestIds: ").append(spotInstanceRequestIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "SpotInstanceRequestIds":
            return Optional.of(clazz.cast(spotInstanceRequestIds()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, DescribeSpotInstanceRequestsRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone-group</code> - The Availability Zone group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>create-time</code> - The time stamp when the Spot instance request was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fault-code</code> - The fault code related to the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fault-message</code> - The fault message related to the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance that fulfilled the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch-group</code> - The Spot instance launch group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.block-device-mapping.delete-on-termination</code> - Indicates whether the EBS volume is deleted
         * on instance termination.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.block-device-mapping.device-name</code> - The device name for the volume in the block device
         * mapping (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.block-device-mapping.snapshot-id</code> - The ID of the snapshot for the EBS volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.block-device-mapping.volume-size</code> - The size of the EBS volume, in GiB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.block-device-mapping.volume-type</code> - The type of EBS volume: <code>gp2</code> for General
         * Purpose SSD, <code>io1</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized HDD,
         * <code>sc1</code>for Cold HDD, or <code>standard</code> for Magnetic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.group-id</code> - The security group for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.image-id</code> - The ID of the AMI.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.instance-type</code> - The type of instance (for example, <code>m3.medium</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.kernel-id</code> - The kernel ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.key-name</code> - The name of the key pair the instance launched with.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.monitoring-enabled</code> - Whether detailed monitoring is enabled for the Spot instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.ramdisk-id</code> - The RAM disk ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launched-availability-zone</code> - The Availability Zone in which the bid is launched.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.primary</code> - Indicates whether the IP address is the primary private IP
         * address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.delete-on-termination</code> - Indicates whether the network interface is deleted
         * when the instance is terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.description</code> - A description of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.device-index</code> - The index of the device for the network interface attachment on
         * the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.group-id</code> - The ID of the security group associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.network-interface-id</code> - The ID of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.private-ip-address</code> - The primary private IP address of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.subnet-id</code> - The ID of the subnet for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-description</code> - The product description associated with the instance (
         * <code>Linux/UNIX</code> | <code>Windows</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>spot-instance-request-id</code> - The Spot instance request ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>spot-price</code> - The maximum hourly price for any Spot instance launched to fulfill the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the Spot instance request (<code>open</code> | <code>active</code> |
         * <code>closed</code> | <code>cancelled</code> | <code>failed</code>). Spot bid status information can help you
         * track your Amazon EC2 Spot instance requests. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html">Spot Bid Status</a> in the
         * Amazon Elastic Compute Cloud User Guide.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status-code</code> - The short code describing the most recent evaluation of your Spot instance
         * request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status-message</code> - The message explaining the status of the Spot instance request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * Specify the key of the tag in the filter name and the value of the tag in the filter value. For example, for
         * the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value
         * is), and the tag value X (regardless of what the tag's key is). If you want to list only resources where
         * Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>type</code> - The type of Spot instance request (<code>one-time</code> | <code>persistent</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>valid-from</code> - The start date of the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>valid-until</code> - The end date of the request.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availability-zone-group</code> - The Availability Zone group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>create-time</code> - The time stamp when the Spot instance request was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fault-code</code> - The fault code related to the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fault-message</code> - The fault message related to the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-id</code> - The ID of the instance that fulfilled the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch-group</code> - The Spot instance launch group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.block-device-mapping.delete-on-termination</code> - Indicates whether the EBS volume is
         *        deleted on instance termination.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.block-device-mapping.device-name</code> - The device name for the volume in the block
         *        device mapping (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.block-device-mapping.snapshot-id</code> - The ID of the snapshot for the EBS volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.block-device-mapping.volume-size</code> - The size of the EBS volume, in GiB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.block-device-mapping.volume-type</code> - The type of EBS volume: <code>gp2</code> for
         *        General Purpose SSD, <code>io1</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput
         *        Optimized HDD, <code>sc1</code>for Cold HDD, or <code>standard</code> for Magnetic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.group-id</code> - The security group for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.image-id</code> - The ID of the AMI.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.instance-type</code> - The type of instance (for example, <code>m3.medium</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.kernel-id</code> - The kernel ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.key-name</code> - The name of the key pair the instance launched with.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.monitoring-enabled</code> - Whether detailed monitoring is enabled for the Spot instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.ramdisk-id</code> - The RAM disk ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launched-availability-zone</code> - The Availability Zone in which the bid is launched.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.primary</code> - Indicates whether the IP address is the primary
         *        private IP address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.delete-on-termination</code> - Indicates whether the network interface is
         *        deleted when the instance is terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.description</code> - A description of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.device-index</code> - The index of the device for the network interface
         *        attachment on the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.group-id</code> - The ID of the security group associated with the network
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.network-interface-id</code> - The ID of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.private-ip-address</code> - The primary private IP address of the network
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.subnet-id</code> - The ID of the subnet for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-description</code> - The product description associated with the instance (
         *        <code>Linux/UNIX</code> | <code>Windows</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>spot-instance-request-id</code> - The Spot instance request ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>spot-price</code> - The maximum hourly price for any Spot instance launched to fulfill the
         *        request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the Spot instance request (<code>open</code> | <code>active</code> |
         *        <code>closed</code> | <code>cancelled</code> | <code>failed</code>). Spot bid status information can
         *        help you track your Amazon EC2 Spot instance requests. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html">Spot Bid Status</a> in
         *        the Amazon Elastic Compute Cloud User Guide.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status-code</code> - The short code describing the most recent evaluation of your Spot instance
         *        request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status-message</code> - The message explaining the status of the Spot instance request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the
         *        resource. Specify the key of the tag in the filter name and the value of the tag in the filter value.
         *        For example, for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and
         *        <code>X</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         *        <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the
         *        filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the
         *        tag's value is), and the tag value X (regardless of what the tag's key is). If you want to list only
         *        resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of
         *        the <code>tag-key</code> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>type</code> - The type of Spot instance request (<code>one-time</code> | <code>persistent</code>
         *        ).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>valid-from</code> - The start date of the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>valid-until</code> - The end date of the request.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone-group</code> - The Availability Zone group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>create-time</code> - The time stamp when the Spot instance request was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fault-code</code> - The fault code related to the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fault-message</code> - The fault message related to the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance that fulfilled the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch-group</code> - The Spot instance launch group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.block-device-mapping.delete-on-termination</code> - Indicates whether the EBS volume is deleted
         * on instance termination.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.block-device-mapping.device-name</code> - The device name for the volume in the block device
         * mapping (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.block-device-mapping.snapshot-id</code> - The ID of the snapshot for the EBS volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.block-device-mapping.volume-size</code> - The size of the EBS volume, in GiB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.block-device-mapping.volume-type</code> - The type of EBS volume: <code>gp2</code> for General
         * Purpose SSD, <code>io1</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized HDD,
         * <code>sc1</code>for Cold HDD, or <code>standard</code> for Magnetic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.group-id</code> - The security group for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.image-id</code> - The ID of the AMI.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.instance-type</code> - The type of instance (for example, <code>m3.medium</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.kernel-id</code> - The kernel ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.key-name</code> - The name of the key pair the instance launched with.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.monitoring-enabled</code> - Whether detailed monitoring is enabled for the Spot instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch.ramdisk-id</code> - The RAM disk ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launched-availability-zone</code> - The Availability Zone in which the bid is launched.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.primary</code> - Indicates whether the IP address is the primary private IP
         * address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.delete-on-termination</code> - Indicates whether the network interface is deleted
         * when the instance is terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.description</code> - A description of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.device-index</code> - The index of the device for the network interface attachment on
         * the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.group-id</code> - The ID of the security group associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.network-interface-id</code> - The ID of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.private-ip-address</code> - The primary private IP address of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.subnet-id</code> - The ID of the subnet for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-description</code> - The product description associated with the instance (
         * <code>Linux/UNIX</code> | <code>Windows</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>spot-instance-request-id</code> - The Spot instance request ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>spot-price</code> - The maximum hourly price for any Spot instance launched to fulfill the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the Spot instance request (<code>open</code> | <code>active</code> |
         * <code>closed</code> | <code>cancelled</code> | <code>failed</code>). Spot bid status information can help you
         * track your Amazon EC2 Spot instance requests. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html">Spot Bid Status</a> in the
         * Amazon Elastic Compute Cloud User Guide.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status-code</code> - The short code describing the most recent evaluation of your Spot instance
         * request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status-message</code> - The message explaining the status of the Spot instance request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * Specify the key of the tag in the filter name and the value of the tag in the filter value. For example, for
         * the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value
         * is), and the tag value X (regardless of what the tag's key is). If you want to list only resources where
         * Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>type</code> - The type of Spot instance request (<code>one-time</code> | <code>persistent</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>valid-from</code> - The start date of the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>valid-until</code> - The end date of the request.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availability-zone-group</code> - The Availability Zone group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>create-time</code> - The time stamp when the Spot instance request was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fault-code</code> - The fault code related to the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fault-message</code> - The fault message related to the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-id</code> - The ID of the instance that fulfilled the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch-group</code> - The Spot instance launch group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.block-device-mapping.delete-on-termination</code> - Indicates whether the EBS volume is
         *        deleted on instance termination.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.block-device-mapping.device-name</code> - The device name for the volume in the block
         *        device mapping (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.block-device-mapping.snapshot-id</code> - The ID of the snapshot for the EBS volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.block-device-mapping.volume-size</code> - The size of the EBS volume, in GiB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.block-device-mapping.volume-type</code> - The type of EBS volume: <code>gp2</code> for
         *        General Purpose SSD, <code>io1</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput
         *        Optimized HDD, <code>sc1</code>for Cold HDD, or <code>standard</code> for Magnetic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.group-id</code> - The security group for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.image-id</code> - The ID of the AMI.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.instance-type</code> - The type of instance (for example, <code>m3.medium</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.kernel-id</code> - The kernel ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.key-name</code> - The name of the key pair the instance launched with.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.monitoring-enabled</code> - Whether detailed monitoring is enabled for the Spot instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch.ramdisk-id</code> - The RAM disk ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launched-availability-zone</code> - The Availability Zone in which the bid is launched.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.primary</code> - Indicates whether the IP address is the primary
         *        private IP address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.delete-on-termination</code> - Indicates whether the network interface is
         *        deleted when the instance is terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.description</code> - A description of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.device-index</code> - The index of the device for the network interface
         *        attachment on the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.group-id</code> - The ID of the security group associated with the network
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.network-interface-id</code> - The ID of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.private-ip-address</code> - The primary private IP address of the network
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.subnet-id</code> - The ID of the subnet for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-description</code> - The product description associated with the instance (
         *        <code>Linux/UNIX</code> | <code>Windows</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>spot-instance-request-id</code> - The Spot instance request ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>spot-price</code> - The maximum hourly price for any Spot instance launched to fulfill the
         *        request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the Spot instance request (<code>open</code> | <code>active</code> |
         *        <code>closed</code> | <code>cancelled</code> | <code>failed</code>). Spot bid status information can
         *        help you track your Amazon EC2 Spot instance requests. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html">Spot Bid Status</a> in
         *        the Amazon Elastic Compute Cloud User Guide.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status-code</code> - The short code describing the most recent evaluation of your Spot instance
         *        request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status-message</code> - The message explaining the status of the Spot instance request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the
         *        resource. Specify the key of the tag in the filter name and the value of the tag in the filter value.
         *        For example, for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and
         *        <code>X</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         *        <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the
         *        filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the
         *        tag's value is), and the tag value X (regardless of what the tag's key is). If you want to list only
         *        resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of
         *        the <code>tag-key</code> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>type</code> - The type of Spot instance request (<code>one-time</code> | <code>persistent</code>
         *        ).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>valid-from</code> - The start date of the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>valid-until</code> - The end date of the request.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more Spot instance request IDs.
         * </p>
         * 
         * @param spotInstanceRequestIds
         *        One or more Spot instance request IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotInstanceRequestIds(Collection<String> spotInstanceRequestIds);

        /**
         * <p>
         * One or more Spot instance request IDs.
         * </p>
         * 
         * @param spotInstanceRequestIds
         *        One or more Spot instance request IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotInstanceRequestIds(String... spotInstanceRequestIds);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private List<Filter> filters;

        private List<String> spotInstanceRequestIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpotInstanceRequestsRequest model) {
            filters(model.filters);
            spotInstanceRequestIds(model.spotInstanceRequestIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getSpotInstanceRequestIds() {
            return spotInstanceRequestIds;
        }

        @Override
        public final Builder spotInstanceRequestIds(Collection<String> spotInstanceRequestIds) {
            this.spotInstanceRequestIds = SpotInstanceRequestIdListCopier.copy(spotInstanceRequestIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotInstanceRequestIds(String... spotInstanceRequestIds) {
            spotInstanceRequestIds(Arrays.asList(spotInstanceRequestIds));
            return this;
        }

        public final void setSpotInstanceRequestIds(Collection<String> spotInstanceRequestIds) {
            this.spotInstanceRequestIds = SpotInstanceRequestIdListCopier.copy(spotInstanceRequestIds);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeSpotInstanceRequestsRequest build() {
            return new DescribeSpotInstanceRequestsRequest(this);
        }
    }
}
