/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeVolumeAttribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeVolumeAttributeRequest extends EC2Request implements
        ToCopyableBuilder<DescribeVolumeAttributeRequest.Builder, DescribeVolumeAttributeRequest> {
    private final String attribute;

    private final String volumeId;

    private DescribeVolumeAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.attribute = builder.attribute;
        this.volumeId = builder.volumeId;
    }

    /**
     * <p>
     * The attribute of the volume. This parameter is required.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link VolumeAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attributeString}.
     * </p>
     * 
     * @return The attribute of the volume. This parameter is required.
     * @see VolumeAttributeName
     */
    public VolumeAttributeName attribute() {
        return VolumeAttributeName.fromValue(attribute);
    }

    /**
     * <p>
     * The attribute of the volume. This parameter is required.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link VolumeAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attributeString}.
     * </p>
     * 
     * @return The attribute of the volume. This parameter is required.
     * @see VolumeAttributeName
     */
    public String attributeString() {
        return attribute;
    }

    /**
     * <p>
     * The ID of the volume.
     * </p>
     * 
     * @return The ID of the volume.
     */
    public String volumeId() {
        return volumeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeString());
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumeAttributeRequest)) {
            return false;
        }
        DescribeVolumeAttributeRequest other = (DescribeVolumeAttributeRequest) obj;
        return Objects.equals(attributeString(), other.attributeString()) && Objects.equals(volumeId(), other.volumeId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (attributeString() != null) {
            sb.append("Attribute: ").append(attributeString()).append(",");
        }
        if (volumeId() != null) {
            sb.append("VolumeId: ").append(volumeId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attribute":
            return Optional.of(clazz.cast(attributeString()));
        case "VolumeId":
            return Optional.of(clazz.cast(volumeId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, DescribeVolumeAttributeRequest> {
        /**
         * <p>
         * The attribute of the volume. This parameter is required.
         * </p>
         * 
         * @param attribute
         *        The attribute of the volume. This parameter is required.
         * @see VolumeAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeAttributeName
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The attribute of the volume. This parameter is required.
         * </p>
         * 
         * @param attribute
         *        The attribute of the volume. This parameter is required.
         * @see VolumeAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeAttributeName
         */
        Builder attribute(VolumeAttributeName attribute);

        /**
         * <p>
         * The ID of the volume.
         * </p>
         * 
         * @param volumeId
         *        The ID of the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String attribute;

        private String volumeId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVolumeAttributeRequest model) {
            attribute(model.attribute);
            volumeId(model.volumeId);
        }

        public final String getAttribute() {
            return attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(VolumeAttributeName attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final String getVolumeId() {
            return volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeVolumeAttributeRequest build() {
            return new DescribeVolumeAttributeRequest(this);
        }
    }
}
