/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeVolumesModificationsRequest extends EC2Request implements
        ToCopyableBuilder<DescribeVolumesModificationsRequest.Builder, DescribeVolumesModificationsRequest> {
    private final List<String> volumeIds;

    private final List<Filter> filters;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeVolumesModificationsRequest(BuilderImpl builder) {
        super(builder);
        this.volumeIds = builder.volumeIds;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * One or more volume IDs for which in-progress modifications will be described.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more volume IDs for which in-progress modifications will be described.
     */
    public List<String> volumeIds() {
        return volumeIds;
    }

    /**
     * <p>
     * One or more filters. Supported filters: <code>volume-id</code>, <code>modification-state</code>,
     * <code>target-size</code>, <code>target-iops</code>, <code>target-volume-type</code>, <code>original-size</code>,
     * <code>original-iops</code>, <code>original-volume-type</code>, <code>start-time</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters. Supported filters: <code>volume-id</code>, <code>modification-state</code>,
     *         <code>target-size</code>, <code>target-iops</code>, <code>target-volume-type</code>,
     *         <code>original-size</code>, <code>original-iops</code>, <code>original-volume-type</code>,
     *         <code>start-time</code>.
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned by a previous paginated request.
     * </p>
     * 
     * @return The <code>nextToken</code> value returned by a previous paginated request.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results (up to a limit of 500) to be returned in a paginated request.
     * </p>
     * 
     * @return The maximum number of results (up to a limit of 500) to be returned in a paginated request.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(volumeIds());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumesModificationsRequest)) {
            return false;
        }
        DescribeVolumesModificationsRequest other = (DescribeVolumesModificationsRequest) obj;
        return Objects.equals(volumeIds(), other.volumeIds()) && Objects.equals(filters(), other.filters())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (volumeIds() != null) {
            sb.append("VolumeIds: ").append(volumeIds()).append(",");
        }
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeIds":
            return Optional.of(clazz.cast(volumeIds()));
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.of(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, DescribeVolumesModificationsRequest> {
        /**
         * <p>
         * One or more volume IDs for which in-progress modifications will be described.
         * </p>
         * 
         * @param volumeIds
         *        One or more volume IDs for which in-progress modifications will be described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeIds(Collection<String> volumeIds);

        /**
         * <p>
         * One or more volume IDs for which in-progress modifications will be described.
         * </p>
         * 
         * @param volumeIds
         *        One or more volume IDs for which in-progress modifications will be described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeIds(String... volumeIds);

        /**
         * <p>
         * One or more filters. Supported filters: <code>volume-id</code>, <code>modification-state</code>,
         * <code>target-size</code>, <code>target-iops</code>, <code>target-volume-type</code>,
         * <code>original-size</code>, <code>original-iops</code>, <code>original-volume-type</code>,
         * <code>start-time</code>.
         * </p>
         * 
         * @param filters
         *        One or more filters. Supported filters: <code>volume-id</code>, <code>modification-state</code>,
         *        <code>target-size</code>, <code>target-iops</code>, <code>target-volume-type</code>,
         *        <code>original-size</code>, <code>original-iops</code>, <code>original-volume-type</code>,
         *        <code>start-time</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters. Supported filters: <code>volume-id</code>, <code>modification-state</code>,
         * <code>target-size</code>, <code>target-iops</code>, <code>target-volume-type</code>,
         * <code>original-size</code>, <code>original-iops</code>, <code>original-volume-type</code>,
         * <code>start-time</code>.
         * </p>
         * 
         * @param filters
         *        One or more filters. Supported filters: <code>volume-id</code>, <code>modification-state</code>,
         *        <code>target-size</code>, <code>target-iops</code>, <code>target-volume-type</code>,
         *        <code>original-size</code>, <code>original-iops</code>, <code>original-volume-type</code>,
         *        <code>start-time</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The <code>nextToken</code> value returned by a previous paginated request.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned by a previous paginated request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results (up to a limit of 500) to be returned in a paginated request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results (up to a limit of 500) to be returned in a paginated request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private List<String> volumeIds;

        private List<Filter> filters;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVolumesModificationsRequest model) {
            volumeIds(model.volumeIds);
            filters(model.filters);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<String> getVolumeIds() {
            return volumeIds;
        }

        @Override
        public final Builder volumeIds(Collection<String> volumeIds) {
            this.volumeIds = VolumeIdStringListCopier.copy(volumeIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeIds(String... volumeIds) {
            volumeIds(Arrays.asList(volumeIds));
            return this;
        }

        public final void setVolumeIds(Collection<String> volumeIds) {
            this.volumeIds = VolumeIdStringListCopier.copy(volumeIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeVolumesModificationsRequest build() {
            return new DescribeVolumesModificationsRequest(this);
        }
    }
}
