/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the status of an Elastic GPU.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ElasticGpuHealth implements ToCopyableBuilder<ElasticGpuHealth.Builder, ElasticGpuHealth> {
    private final String status;

    private ElasticGpuHealth(BuilderImpl builder) {
        this.status = builder.status;
    }

    /**
     * <p>
     * The health status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ElasticGpuStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return The health status.
     * @see ElasticGpuStatus
     */
    public ElasticGpuStatus status() {
        return ElasticGpuStatus.fromValue(status);
    }

    /**
     * <p>
     * The health status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ElasticGpuStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return The health status.
     * @see ElasticGpuStatus
     */
    public String statusString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticGpuHealth)) {
            return false;
        }
        ElasticGpuHealth other = (ElasticGpuHealth) obj;
        return Objects.equals(statusString(), other.statusString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (statusString() != null) {
            sb.append("Status: ").append(statusString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.of(clazz.cast(statusString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ElasticGpuHealth> {
        /**
         * <p>
         * The health status.
         * </p>
         * 
         * @param status
         *        The health status.
         * @see ElasticGpuStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ElasticGpuStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The health status.
         * </p>
         * 
         * @param status
         *        The health status.
         * @see ElasticGpuStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ElasticGpuStatus
         */
        Builder status(ElasticGpuStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticGpuHealth model) {
            status(model.status);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ElasticGpuStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public ElasticGpuHealth build() {
            return new ElasticGpuHealth(this);
        }
    }
}
