/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Spot fleet event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class EventInformation implements ToCopyableBuilder<EventInformation.Builder, EventInformation> {
    private final String eventDescription;

    private final String eventSubType;

    private final String instanceId;

    private EventInformation(BuilderImpl builder) {
        this.eventDescription = builder.eventDescription;
        this.eventSubType = builder.eventSubType;
        this.instanceId = builder.instanceId;
    }

    /**
     * <p>
     * The description of the event.
     * </p>
     * 
     * @return The description of the event.
     */
    public String eventDescription() {
        return eventDescription;
    }

    /**
     * <p>
     * The event.
     * </p>
     * <p>
     * The following are the <code>error</code> events:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>iamFleetRoleInvalid</code> - The Spot fleet did not have the required permissions either to launch or
     * terminate an instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launchSpecTemporarilyBlacklisted</code> - The configuration is not valid and several attempts to launch
     * instances have failed. For more information, see the description of the event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>spotFleetRequestConfigurationInvalid</code> - The configuration is not valid. For more information, see the
     * description of the event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>spotInstanceCountLimitExceeded</code> - You've reached the limit on the number of Spot instances that you
     * can launch.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following are the <code>fleetRequestChange</code> events:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>active</code> - The Spot fleet has been validated and Amazon EC2 is attempting to maintain the target
     * number of running Spot instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cancelled</code> - The Spot fleet is canceled and has no running Spot instances. The Spot fleet will be
     * deleted two days after its instances were terminated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cancelled_running</code> - The Spot fleet is canceled and will not launch additional Spot instances, but
     * its existing Spot instances continue to run until they are interrupted or terminated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cancelled_terminating</code> - The Spot fleet is canceled and its Spot instances are terminating.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>expired</code> - The Spot fleet request has expired. A subsequent event indicates that the instances were
     * terminated, if the request was created with <code>TerminateInstancesWithExpiration</code> set.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>modify_in_progress</code> - A request to modify the Spot fleet request was accepted and is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>modify_successful</code> - The Spot fleet request was modified.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>price_update</code> - The bid price for a launch configuration was adjusted because it was too high. This
     * change is permanent.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>submitted</code> - The Spot fleet request is being evaluated and Amazon EC2 is preparing to launch the
     * target number of Spot instances.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following are the <code>instanceChange</code> events:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>launched</code> - A bid was fulfilled and a new instance was launched.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>terminated</code> - An instance was terminated by the user.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following are the <code>Information</code> events:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>launchSpecUnusable</code> - The bid price of a launch specification is not valid because it is below the
     * market price or the market price is above the On-Demand price.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fleetProgressHalted</code> - The bid price of every launch specification is not valid. A launch
     * specification might become valid if the market price changes.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The event.</p>
     *         <p>
     *         The following are the <code>error</code> events:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>iamFleetRoleInvalid</code> - The Spot fleet did not have the required permissions either to launch
     *         or terminate an instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launchSpecTemporarilyBlacklisted</code> - The configuration is not valid and several attempts to
     *         launch instances have failed. For more information, see the description of the event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>spotFleetRequestConfigurationInvalid</code> - The configuration is not valid. For more information,
     *         see the description of the event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>spotInstanceCountLimitExceeded</code> - You've reached the limit on the number of Spot instances
     *         that you can launch.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following are the <code>fleetRequestChange</code> events:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>active</code> - The Spot fleet has been validated and Amazon EC2 is attempting to maintain the
     *         target number of running Spot instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cancelled</code> - The Spot fleet is canceled and has no running Spot instances. The Spot fleet
     *         will be deleted two days after its instances were terminated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cancelled_running</code> - The Spot fleet is canceled and will not launch additional Spot
     *         instances, but its existing Spot instances continue to run until they are interrupted or terminated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cancelled_terminating</code> - The Spot fleet is canceled and its Spot instances are terminating.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>expired</code> - The Spot fleet request has expired. A subsequent event indicates that the
     *         instances were terminated, if the request was created with <code>TerminateInstancesWithExpiration</code>
     *         set.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>modify_in_progress</code> - A request to modify the Spot fleet request was accepted and is in
     *         progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>modify_successful</code> - The Spot fleet request was modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>price_update</code> - The bid price for a launch configuration was adjusted because it was too
     *         high. This change is permanent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>submitted</code> - The Spot fleet request is being evaluated and Amazon EC2 is preparing to launch
     *         the target number of Spot instances.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following are the <code>instanceChange</code> events:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>launched</code> - A bid was fulfilled and a new instance was launched.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>terminated</code> - An instance was terminated by the user.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following are the <code>Information</code> events:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>launchSpecUnusable</code> - The bid price of a launch specification is not valid because it is
     *         below the market price or the market price is above the On-Demand price.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fleetProgressHalted</code> - The bid price of every launch specification is not valid. A launch
     *         specification might become valid if the market price changes.
     *         </p>
     *         </li>
     */
    public String eventSubType() {
        return eventSubType;
    }

    /**
     * <p>
     * The ID of the instance. This information is available only for <code>instanceChange</code> events.
     * </p>
     * 
     * @return The ID of the instance. This information is available only for <code>instanceChange</code> events.
     */
    public String instanceId() {
        return instanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventDescription());
        hashCode = 31 * hashCode + Objects.hashCode(eventSubType());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventInformation)) {
            return false;
        }
        EventInformation other = (EventInformation) obj;
        return Objects.equals(eventDescription(), other.eventDescription())
                && Objects.equals(eventSubType(), other.eventSubType()) && Objects.equals(instanceId(), other.instanceId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (eventDescription() != null) {
            sb.append("EventDescription: ").append(eventDescription()).append(",");
        }
        if (eventSubType() != null) {
            sb.append("EventSubType: ").append(eventSubType()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventDescription":
            return Optional.of(clazz.cast(eventDescription()));
        case "EventSubType":
            return Optional.of(clazz.cast(eventSubType()));
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, EventInformation> {
        /**
         * <p>
         * The description of the event.
         * </p>
         * 
         * @param eventDescription
         *        The description of the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDescription(String eventDescription);

        /**
         * <p>
         * The event.
         * </p>
         * <p>
         * The following are the <code>error</code> events:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>iamFleetRoleInvalid</code> - The Spot fleet did not have the required permissions either to launch or
         * terminate an instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launchSpecTemporarilyBlacklisted</code> - The configuration is not valid and several attempts to launch
         * instances have failed. For more information, see the description of the event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>spotFleetRequestConfigurationInvalid</code> - The configuration is not valid. For more information, see
         * the description of the event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>spotInstanceCountLimitExceeded</code> - You've reached the limit on the number of Spot instances that
         * you can launch.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following are the <code>fleetRequestChange</code> events:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>active</code> - The Spot fleet has been validated and Amazon EC2 is attempting to maintain the target
         * number of running Spot instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cancelled</code> - The Spot fleet is canceled and has no running Spot instances. The Spot fleet will be
         * deleted two days after its instances were terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cancelled_running</code> - The Spot fleet is canceled and will not launch additional Spot instances,
         * but its existing Spot instances continue to run until they are interrupted or terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cancelled_terminating</code> - The Spot fleet is canceled and its Spot instances are terminating.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>expired</code> - The Spot fleet request has expired. A subsequent event indicates that the instances
         * were terminated, if the request was created with <code>TerminateInstancesWithExpiration</code> set.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>modify_in_progress</code> - A request to modify the Spot fleet request was accepted and is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>modify_successful</code> - The Spot fleet request was modified.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>price_update</code> - The bid price for a launch configuration was adjusted because it was too high.
         * This change is permanent.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>submitted</code> - The Spot fleet request is being evaluated and Amazon EC2 is preparing to launch the
         * target number of Spot instances.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following are the <code>instanceChange</code> events:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>launched</code> - A bid was fulfilled and a new instance was launched.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>terminated</code> - An instance was terminated by the user.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following are the <code>Information</code> events:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>launchSpecUnusable</code> - The bid price of a launch specification is not valid because it is below
         * the market price or the market price is above the On-Demand price.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fleetProgressHalted</code> - The bid price of every launch specification is not valid. A launch
         * specification might become valid if the market price changes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param eventSubType
         *        The event.</p>
         *        <p>
         *        The following are the <code>error</code> events:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>iamFleetRoleInvalid</code> - The Spot fleet did not have the required permissions either to
         *        launch or terminate an instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launchSpecTemporarilyBlacklisted</code> - The configuration is not valid and several attempts to
         *        launch instances have failed. For more information, see the description of the event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>spotFleetRequestConfigurationInvalid</code> - The configuration is not valid. For more
         *        information, see the description of the event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>spotInstanceCountLimitExceeded</code> - You've reached the limit on the number of Spot instances
         *        that you can launch.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following are the <code>fleetRequestChange</code> events:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>active</code> - The Spot fleet has been validated and Amazon EC2 is attempting to maintain the
         *        target number of running Spot instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cancelled</code> - The Spot fleet is canceled and has no running Spot instances. The Spot fleet
         *        will be deleted two days after its instances were terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cancelled_running</code> - The Spot fleet is canceled and will not launch additional Spot
         *        instances, but its existing Spot instances continue to run until they are interrupted or terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cancelled_terminating</code> - The Spot fleet is canceled and its Spot instances are
         *        terminating.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>expired</code> - The Spot fleet request has expired. A subsequent event indicates that the
         *        instances were terminated, if the request was created with
         *        <code>TerminateInstancesWithExpiration</code> set.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>modify_in_progress</code> - A request to modify the Spot fleet request was accepted and is in
         *        progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>modify_successful</code> - The Spot fleet request was modified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>price_update</code> - The bid price for a launch configuration was adjusted because it was too
         *        high. This change is permanent.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>submitted</code> - The Spot fleet request is being evaluated and Amazon EC2 is preparing to
         *        launch the target number of Spot instances.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following are the <code>instanceChange</code> events:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>launched</code> - A bid was fulfilled and a new instance was launched.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>terminated</code> - An instance was terminated by the user.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following are the <code>Information</code> events:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>launchSpecUnusable</code> - The bid price of a launch specification is not valid because it is
         *        below the market price or the market price is above the On-Demand price.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fleetProgressHalted</code> - The bid price of every launch specification is not valid. A launch
         *        specification might become valid if the market price changes.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSubType(String eventSubType);

        /**
         * <p>
         * The ID of the instance. This information is available only for <code>instanceChange</code> events.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance. This information is available only for <code>instanceChange</code> events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);
    }

    static final class BuilderImpl implements Builder {
        private String eventDescription;

        private String eventSubType;

        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(EventInformation model) {
            eventDescription(model.eventDescription);
            eventSubType(model.eventSubType);
            instanceId(model.instanceId);
        }

        public final String getEventDescription() {
            return eventDescription;
        }

        @Override
        public final Builder eventDescription(String eventDescription) {
            this.eventDescription = eventDescription;
            return this;
        }

        public final void setEventDescription(String eventDescription) {
            this.eventDescription = eventDescription;
        }

        public final String getEventSubType() {
            return eventSubType;
        }

        @Override
        public final Builder eventSubType(String eventSubType) {
            this.eventSubType = eventSubType;
            return this;
        }

        public final void setEventSubType(String eventSubType) {
            this.eventSubType = eventSubType;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public EventInformation build() {
            return new EventInformation(this);
        }
    }
}
