/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Amazon FPGA image (AFI) attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class FpgaImageAttribute implements ToCopyableBuilder<FpgaImageAttribute.Builder, FpgaImageAttribute> {
    private final String fpgaImageId;

    private final String name;

    private final String description;

    private final List<LoadPermission> loadPermissions;

    private final List<ProductCode> productCodes;

    private FpgaImageAttribute(BuilderImpl builder) {
        this.fpgaImageId = builder.fpgaImageId;
        this.name = builder.name;
        this.description = builder.description;
        this.loadPermissions = builder.loadPermissions;
        this.productCodes = builder.productCodes;
    }

    /**
     * <p>
     * The ID of the AFI.
     * </p>
     * 
     * @return The ID of the AFI.
     */
    public String fpgaImageId() {
        return fpgaImageId;
    }

    /**
     * <p>
     * The name of the AFI.
     * </p>
     * 
     * @return The name of the AFI.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description of the AFI.
     * </p>
     * 
     * @return The description of the AFI.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * One or more load permissions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more load permissions.
     */
    public List<LoadPermission> loadPermissions() {
        return loadPermissions;
    }

    /**
     * <p>
     * One or more product codes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more product codes.
     */
    public List<ProductCode> productCodes() {
        return productCodes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fpgaImageId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(loadPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(productCodes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FpgaImageAttribute)) {
            return false;
        }
        FpgaImageAttribute other = (FpgaImageAttribute) obj;
        return Objects.equals(fpgaImageId(), other.fpgaImageId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(loadPermissions(), other.loadPermissions())
                && Objects.equals(productCodes(), other.productCodes());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (fpgaImageId() != null) {
            sb.append("FpgaImageId: ").append(fpgaImageId()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (loadPermissions() != null) {
            sb.append("LoadPermissions: ").append(loadPermissions()).append(",");
        }
        if (productCodes() != null) {
            sb.append("ProductCodes: ").append(productCodes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FpgaImageId":
            return Optional.of(clazz.cast(fpgaImageId()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "LoadPermissions":
            return Optional.of(clazz.cast(loadPermissions()));
        case "ProductCodes":
            return Optional.of(clazz.cast(productCodes()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, FpgaImageAttribute> {
        /**
         * <p>
         * The ID of the AFI.
         * </p>
         * 
         * @param fpgaImageId
         *        The ID of the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fpgaImageId(String fpgaImageId);

        /**
         * <p>
         * The name of the AFI.
         * </p>
         * 
         * @param name
         *        The name of the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the AFI.
         * </p>
         * 
         * @param description
         *        The description of the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * One or more load permissions.
         * </p>
         * 
         * @param loadPermissions
         *        One or more load permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadPermissions(Collection<LoadPermission> loadPermissions);

        /**
         * <p>
         * One or more load permissions.
         * </p>
         * 
         * @param loadPermissions
         *        One or more load permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadPermissions(LoadPermission... loadPermissions);

        /**
         * <p>
         * One or more product codes.
         * </p>
         * 
         * @param productCodes
         *        One or more product codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(Collection<ProductCode> productCodes);

        /**
         * <p>
         * One or more product codes.
         * </p>
         * 
         * @param productCodes
         *        One or more product codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(ProductCode... productCodes);
    }

    static final class BuilderImpl implements Builder {
        private String fpgaImageId;

        private String name;

        private String description;

        private List<LoadPermission> loadPermissions;

        private List<ProductCode> productCodes;

        private BuilderImpl() {
        }

        private BuilderImpl(FpgaImageAttribute model) {
            fpgaImageId(model.fpgaImageId);
            name(model.name);
            description(model.description);
            loadPermissions(model.loadPermissions);
            productCodes(model.productCodes);
        }

        public final String getFpgaImageId() {
            return fpgaImageId;
        }

        @Override
        public final Builder fpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
            return this;
        }

        public final void setFpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<LoadPermission.Builder> getLoadPermissions() {
            return loadPermissions != null ? loadPermissions.stream().map(LoadPermission::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder loadPermissions(Collection<LoadPermission> loadPermissions) {
            this.loadPermissions = LoadPermissionListCopier.copy(loadPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadPermissions(LoadPermission... loadPermissions) {
            loadPermissions(Arrays.asList(loadPermissions));
            return this;
        }

        public final void setLoadPermissions(Collection<LoadPermission.BuilderImpl> loadPermissions) {
            this.loadPermissions = LoadPermissionListCopier.copyFromBuilder(loadPermissions);
        }

        public final Collection<ProductCode.Builder> getProductCodes() {
            return productCodes != null ? productCodes.stream().map(ProductCode::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode... productCodes) {
            productCodes(Arrays.asList(productCodes));
            return this;
        }

        public final void setProductCodes(Collection<ProductCode.BuilderImpl> productCodes) {
            this.productCodes = ProductCodeListCopier.copyFromBuilder(productCodes);
        }

        @Override
        public FpgaImageAttribute build() {
            return new FpgaImageAttribute(this);
        }
    }
}
