/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the Dedicated Host Reservation and associated Dedicated Hosts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class HostReservation implements ToCopyableBuilder<HostReservation.Builder, HostReservation> {
    private final Integer count;

    private final String currencyCode;

    private final Integer duration;

    private final Instant end;

    private final List<String> hostIdSet;

    private final String hostReservationId;

    private final String hourlyPrice;

    private final String instanceFamily;

    private final String offeringId;

    private final String paymentOption;

    private final Instant start;

    private final String state;

    private final String upfrontPrice;

    private HostReservation(BuilderImpl builder) {
        this.count = builder.count;
        this.currencyCode = builder.currencyCode;
        this.duration = builder.duration;
        this.end = builder.end;
        this.hostIdSet = builder.hostIdSet;
        this.hostReservationId = builder.hostReservationId;
        this.hourlyPrice = builder.hourlyPrice;
        this.instanceFamily = builder.instanceFamily;
        this.offeringId = builder.offeringId;
        this.paymentOption = builder.paymentOption;
        this.start = builder.start;
        this.state = builder.state;
        this.upfrontPrice = builder.upfrontPrice;
    }

    /**
     * <p>
     * The number of Dedicated Hosts the reservation is associated with.
     * </p>
     * 
     * @return The number of Dedicated Hosts the reservation is associated with.
     */
    public Integer count() {
        return count;
    }

    /**
     * <p>
     * The currency in which the <code>upfrontPrice</code> and <code>hourlyPrice</code> amounts are specified. At this
     * time, the only supported currency is <code>USD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeString}.
     * </p>
     * 
     * @return The currency in which the <code>upfrontPrice</code> and <code>hourlyPrice</code> amounts are specified.
     *         At this time, the only supported currency is <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(currencyCode);
    }

    /**
     * <p>
     * The currency in which the <code>upfrontPrice</code> and <code>hourlyPrice</code> amounts are specified. At this
     * time, the only supported currency is <code>USD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeString}.
     * </p>
     * 
     * @return The currency in which the <code>upfrontPrice</code> and <code>hourlyPrice</code> amounts are specified.
     *         At this time, the only supported currency is <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public String currencyCodeString() {
        return currencyCode;
    }

    /**
     * <p>
     * The length of the reservation's term, specified in seconds. Can be <code>31536000 (1 year)</code> |
     * <code>94608000 (3 years)</code>.
     * </p>
     * 
     * @return The length of the reservation's term, specified in seconds. Can be <code>31536000 (1 year)</code> |
     *         <code>94608000 (3 years)</code>.
     */
    public Integer duration() {
        return duration;
    }

    /**
     * <p>
     * The date and time that the reservation ends.
     * </p>
     * 
     * @return The date and time that the reservation ends.
     */
    public Instant end() {
        return end;
    }

    /**
     * <p>
     * The IDs of the Dedicated Hosts associated with the reservation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of the Dedicated Hosts associated with the reservation.
     */
    public List<String> hostIdSet() {
        return hostIdSet;
    }

    /**
     * <p>
     * The ID of the reservation that specifies the associated Dedicated Hosts.
     * </p>
     * 
     * @return The ID of the reservation that specifies the associated Dedicated Hosts.
     */
    public String hostReservationId() {
        return hostReservationId;
    }

    /**
     * <p>
     * The hourly price of the reservation.
     * </p>
     * 
     * @return The hourly price of the reservation.
     */
    public String hourlyPrice() {
        return hourlyPrice;
    }

    /**
     * <p>
     * The instance family of the Dedicated Host Reservation. The instance family on the Dedicated Host must be the same
     * in order for it to benefit from the reservation.
     * </p>
     * 
     * @return The instance family of the Dedicated Host Reservation. The instance family on the Dedicated Host must be
     *         the same in order for it to benefit from the reservation.
     */
    public String instanceFamily() {
        return instanceFamily;
    }

    /**
     * <p>
     * The ID of the reservation. This remains the same regardless of which Dedicated Hosts are associated with it.
     * </p>
     * 
     * @return The ID of the reservation. This remains the same regardless of which Dedicated Hosts are associated with
     *         it.
     */
    public String offeringId() {
        return offeringId;
    }

    /**
     * <p>
     * The payment option selected for this reservation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link PaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #paymentOptionString}.
     * </p>
     * 
     * @return The payment option selected for this reservation.
     * @see PaymentOption
     */
    public PaymentOption paymentOption() {
        return PaymentOption.fromValue(paymentOption);
    }

    /**
     * <p>
     * The payment option selected for this reservation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link PaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #paymentOptionString}.
     * </p>
     * 
     * @return The payment option selected for this reservation.
     * @see PaymentOption
     */
    public String paymentOptionString() {
        return paymentOption;
    }

    /**
     * <p>
     * The date and time that the reservation started.
     * </p>
     * 
     * @return The date and time that the reservation started.
     */
    public Instant start() {
        return start;
    }

    /**
     * <p>
     * The state of the reservation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ReservationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The state of the reservation.
     * @see ReservationState
     */
    public ReservationState state() {
        return ReservationState.fromValue(state);
    }

    /**
     * <p>
     * The state of the reservation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ReservationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The state of the reservation.
     * @see ReservationState
     */
    public String stateString() {
        return state;
    }

    /**
     * <p>
     * The upfront price of the reservation.
     * </p>
     * 
     * @return The upfront price of the reservation.
     */
    public String upfrontPrice() {
        return upfrontPrice;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCodeString());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(end());
        hashCode = 31 * hashCode + Objects.hashCode(hostIdSet());
        hashCode = 31 * hashCode + Objects.hashCode(hostReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(hourlyPrice());
        hashCode = 31 * hashCode + Objects.hashCode(instanceFamily());
        hashCode = 31 * hashCode + Objects.hashCode(offeringId());
        hashCode = 31 * hashCode + Objects.hashCode(paymentOptionString());
        hashCode = 31 * hashCode + Objects.hashCode(start());
        hashCode = 31 * hashCode + Objects.hashCode(stateString());
        hashCode = 31 * hashCode + Objects.hashCode(upfrontPrice());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostReservation)) {
            return false;
        }
        HostReservation other = (HostReservation) obj;
        return Objects.equals(count(), other.count()) && Objects.equals(currencyCodeString(), other.currencyCodeString())
                && Objects.equals(duration(), other.duration()) && Objects.equals(end(), other.end())
                && Objects.equals(hostIdSet(), other.hostIdSet())
                && Objects.equals(hostReservationId(), other.hostReservationId())
                && Objects.equals(hourlyPrice(), other.hourlyPrice()) && Objects.equals(instanceFamily(), other.instanceFamily())
                && Objects.equals(offeringId(), other.offeringId())
                && Objects.equals(paymentOptionString(), other.paymentOptionString()) && Objects.equals(start(), other.start())
                && Objects.equals(stateString(), other.stateString()) && Objects.equals(upfrontPrice(), other.upfrontPrice());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (count() != null) {
            sb.append("Count: ").append(count()).append(",");
        }
        if (currencyCodeString() != null) {
            sb.append("CurrencyCode: ").append(currencyCodeString()).append(",");
        }
        if (duration() != null) {
            sb.append("Duration: ").append(duration()).append(",");
        }
        if (end() != null) {
            sb.append("End: ").append(end()).append(",");
        }
        if (hostIdSet() != null) {
            sb.append("HostIdSet: ").append(hostIdSet()).append(",");
        }
        if (hostReservationId() != null) {
            sb.append("HostReservationId: ").append(hostReservationId()).append(",");
        }
        if (hourlyPrice() != null) {
            sb.append("HourlyPrice: ").append(hourlyPrice()).append(",");
        }
        if (instanceFamily() != null) {
            sb.append("InstanceFamily: ").append(instanceFamily()).append(",");
        }
        if (offeringId() != null) {
            sb.append("OfferingId: ").append(offeringId()).append(",");
        }
        if (paymentOptionString() != null) {
            sb.append("PaymentOption: ").append(paymentOptionString()).append(",");
        }
        if (start() != null) {
            sb.append("Start: ").append(start()).append(",");
        }
        if (stateString() != null) {
            sb.append("State: ").append(stateString()).append(",");
        }
        if (upfrontPrice() != null) {
            sb.append("UpfrontPrice: ").append(upfrontPrice()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Count":
            return Optional.of(clazz.cast(count()));
        case "CurrencyCode":
            return Optional.of(clazz.cast(currencyCodeString()));
        case "Duration":
            return Optional.of(clazz.cast(duration()));
        case "End":
            return Optional.of(clazz.cast(end()));
        case "HostIdSet":
            return Optional.of(clazz.cast(hostIdSet()));
        case "HostReservationId":
            return Optional.of(clazz.cast(hostReservationId()));
        case "HourlyPrice":
            return Optional.of(clazz.cast(hourlyPrice()));
        case "InstanceFamily":
            return Optional.of(clazz.cast(instanceFamily()));
        case "OfferingId":
            return Optional.of(clazz.cast(offeringId()));
        case "PaymentOption":
            return Optional.of(clazz.cast(paymentOptionString()));
        case "Start":
            return Optional.of(clazz.cast(start()));
        case "State":
            return Optional.of(clazz.cast(stateString()));
        case "UpfrontPrice":
            return Optional.of(clazz.cast(upfrontPrice()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, HostReservation> {
        /**
         * <p>
         * The number of Dedicated Hosts the reservation is associated with.
         * </p>
         * 
         * @param count
         *        The number of Dedicated Hosts the reservation is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * The currency in which the <code>upfrontPrice</code> and <code>hourlyPrice</code> amounts are specified. At
         * this time, the only supported currency is <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency in which the <code>upfrontPrice</code> and <code>hourlyPrice</code> amounts are
         *        specified. At this time, the only supported currency is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The currency in which the <code>upfrontPrice</code> and <code>hourlyPrice</code> amounts are specified. At
         * this time, the only supported currency is <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency in which the <code>upfrontPrice</code> and <code>hourlyPrice</code> amounts are
         *        specified. At this time, the only supported currency is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(CurrencyCodeValues currencyCode);

        /**
         * <p>
         * The length of the reservation's term, specified in seconds. Can be <code>31536000 (1 year)</code> |
         * <code>94608000 (3 years)</code>.
         * </p>
         * 
         * @param duration
         *        The length of the reservation's term, specified in seconds. Can be <code>31536000 (1 year)</code> |
         *        <code>94608000 (3 years)</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * <p>
         * The date and time that the reservation ends.
         * </p>
         * 
         * @param end
         *        The date and time that the reservation ends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(Instant end);

        /**
         * <p>
         * The IDs of the Dedicated Hosts associated with the reservation.
         * </p>
         * 
         * @param hostIdSet
         *        The IDs of the Dedicated Hosts associated with the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostIdSet(Collection<String> hostIdSet);

        /**
         * <p>
         * The IDs of the Dedicated Hosts associated with the reservation.
         * </p>
         * 
         * @param hostIdSet
         *        The IDs of the Dedicated Hosts associated with the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostIdSet(String... hostIdSet);

        /**
         * <p>
         * The ID of the reservation that specifies the associated Dedicated Hosts.
         * </p>
         * 
         * @param hostReservationId
         *        The ID of the reservation that specifies the associated Dedicated Hosts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostReservationId(String hostReservationId);

        /**
         * <p>
         * The hourly price of the reservation.
         * </p>
         * 
         * @param hourlyPrice
         *        The hourly price of the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hourlyPrice(String hourlyPrice);

        /**
         * <p>
         * The instance family of the Dedicated Host Reservation. The instance family on the Dedicated Host must be the
         * same in order for it to benefit from the reservation.
         * </p>
         * 
         * @param instanceFamily
         *        The instance family of the Dedicated Host Reservation. The instance family on the Dedicated Host must
         *        be the same in order for it to benefit from the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceFamily(String instanceFamily);

        /**
         * <p>
         * The ID of the reservation. This remains the same regardless of which Dedicated Hosts are associated with it.
         * </p>
         * 
         * @param offeringId
         *        The ID of the reservation. This remains the same regardless of which Dedicated Hosts are associated
         *        with it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringId(String offeringId);

        /**
         * <p>
         * The payment option selected for this reservation.
         * </p>
         * 
         * @param paymentOption
         *        The payment option selected for this reservation.
         * @see PaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaymentOption
         */
        Builder paymentOption(String paymentOption);

        /**
         * <p>
         * The payment option selected for this reservation.
         * </p>
         * 
         * @param paymentOption
         *        The payment option selected for this reservation.
         * @see PaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaymentOption
         */
        Builder paymentOption(PaymentOption paymentOption);

        /**
         * <p>
         * The date and time that the reservation started.
         * </p>
         * 
         * @param start
         *        The date and time that the reservation started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(Instant start);

        /**
         * <p>
         * The state of the reservation.
         * </p>
         * 
         * @param state
         *        The state of the reservation.
         * @see ReservationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservationState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the reservation.
         * </p>
         * 
         * @param state
         *        The state of the reservation.
         * @see ReservationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservationState
         */
        Builder state(ReservationState state);

        /**
         * <p>
         * The upfront price of the reservation.
         * </p>
         * 
         * @param upfrontPrice
         *        The upfront price of the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upfrontPrice(String upfrontPrice);
    }

    static final class BuilderImpl implements Builder {
        private Integer count;

        private String currencyCode;

        private Integer duration;

        private Instant end;

        private List<String> hostIdSet;

        private String hostReservationId;

        private String hourlyPrice;

        private String instanceFamily;

        private String offeringId;

        private String paymentOption;

        private Instant start;

        private String state;

        private String upfrontPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(HostReservation model) {
            count(model.count);
            currencyCode(model.currencyCode);
            duration(model.duration);
            end(model.end);
            hostIdSet(model.hostIdSet);
            hostReservationId(model.hostReservationId);
            hourlyPrice(model.hourlyPrice);
            instanceFamily(model.instanceFamily);
            offeringId(model.offeringId);
            paymentOption(model.paymentOption);
            start(model.start);
            state(model.state);
            upfrontPrice(model.upfrontPrice);
        }

        public final Integer getCount() {
            return count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Integer getDuration() {
            return duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final Instant getEnd() {
            return end;
        }

        @Override
        public final Builder end(Instant end) {
            this.end = end;
            return this;
        }

        public final void setEnd(Instant end) {
            this.end = end;
        }

        public final Collection<String> getHostIdSet() {
            return hostIdSet;
        }

        @Override
        public final Builder hostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = ResponseHostIdSetCopier.copy(hostIdSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostIdSet(String... hostIdSet) {
            hostIdSet(Arrays.asList(hostIdSet));
            return this;
        }

        public final void setHostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = ResponseHostIdSetCopier.copy(hostIdSet);
        }

        public final String getHostReservationId() {
            return hostReservationId;
        }

        @Override
        public final Builder hostReservationId(String hostReservationId) {
            this.hostReservationId = hostReservationId;
            return this;
        }

        public final void setHostReservationId(String hostReservationId) {
            this.hostReservationId = hostReservationId;
        }

        public final String getHourlyPrice() {
            return hourlyPrice;
        }

        @Override
        public final Builder hourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
            return this;
        }

        public final void setHourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
        }

        public final String getInstanceFamily() {
            return instanceFamily;
        }

        @Override
        public final Builder instanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
            return this;
        }

        public final void setInstanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
        }

        public final String getOfferingId() {
            return offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        public final String getPaymentOption() {
            return paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(PaymentOption paymentOption) {
            this.paymentOption(paymentOption.toString());
            return this;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        public final Instant getStart() {
            return start;
        }

        @Override
        public final Builder start(Instant start) {
            this.start = start;
            return this;
        }

        public final void setStart(Instant start) {
            this.start = start;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ReservationState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getUpfrontPrice() {
            return upfrontPrice;
        }

        @Override
        public final Builder upfrontPrice(String upfrontPrice) {
            this.upfrontPrice = upfrontPrice;
            return this;
        }

        public final void setUpfrontPrice(String upfrontPrice) {
            this.upfrontPrice = upfrontPrice;
        }

        @Override
        public HostReservation build() {
            return new HostReservation(this);
        }
    }
}
