/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ImportKeyPair.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ImportKeyPairRequest extends EC2Request implements
        ToCopyableBuilder<ImportKeyPairRequest.Builder, ImportKeyPairRequest> {
    private final String keyName;

    private final String publicKeyMaterial;

    private ImportKeyPairRequest(BuilderImpl builder) {
        super(builder);
        this.keyName = builder.keyName;
        this.publicKeyMaterial = builder.publicKeyMaterial;
    }

    /**
     * <p>
     * A unique name for the key pair.
     * </p>
     * 
     * @return A unique name for the key pair.
     */
    public String keyName() {
        return keyName;
    }

    /**
     * <p>
     * The public key. For API calls, the text must be base64-encoded. For command line tools, base64 encoding is
     * performed for you.
     * </p>
     * 
     * @return The public key. For API calls, the text must be base64-encoded. For command line tools, base64 encoding
     *         is performed for you.
     */
    public String publicKeyMaterial() {
        return publicKeyMaterial;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        hashCode = 31 * hashCode + Objects.hashCode(publicKeyMaterial());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportKeyPairRequest)) {
            return false;
        }
        ImportKeyPairRequest other = (ImportKeyPairRequest) obj;
        return Objects.equals(keyName(), other.keyName()) && Objects.equals(publicKeyMaterial(), other.publicKeyMaterial());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (keyName() != null) {
            sb.append("KeyName: ").append(keyName()).append(",");
        }
        if (publicKeyMaterial() != null) {
            sb.append("PublicKeyMaterial: ").append(publicKeyMaterial()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyName":
            return Optional.of(clazz.cast(keyName()));
        case "PublicKeyMaterial":
            return Optional.of(clazz.cast(publicKeyMaterial()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, ImportKeyPairRequest> {
        /**
         * <p>
         * A unique name for the key pair.
         * </p>
         * 
         * @param keyName
         *        A unique name for the key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * The public key. For API calls, the text must be base64-encoded. For command line tools, base64 encoding is
         * performed for you.
         * </p>
         * 
         * @param publicKeyMaterial
         *        The public key. For API calls, the text must be base64-encoded. For command line tools, base64
         *        encoding is performed for you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKeyMaterial(String publicKeyMaterial);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String keyName;

        private String publicKeyMaterial;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportKeyPairRequest model) {
            keyName(model.keyName);
            publicKeyMaterial(model.publicKeyMaterial);
        }

        public final String getKeyName() {
            return keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final String getPublicKeyMaterial() {
            return publicKeyMaterial;
        }

        @Override
        public final Builder publicKeyMaterial(String publicKeyMaterial) {
            this.publicKeyMaterial = publicKeyMaterial;
            return this;
        }

        public final void setPublicKeyMaterial(String publicKeyMaterial) {
            this.publicKeyMaterial = publicKeyMaterial;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ImportKeyPairRequest build() {
            return new ImportKeyPairRequest(this);
        }
    }
}
