/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an import snapshot task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ImportSnapshotTask implements ToCopyableBuilder<ImportSnapshotTask.Builder, ImportSnapshotTask> {
    private final String description;

    private final String importTaskId;

    private final SnapshotTaskDetail snapshotTaskDetail;

    private ImportSnapshotTask(BuilderImpl builder) {
        this.description = builder.description;
        this.importTaskId = builder.importTaskId;
        this.snapshotTaskDetail = builder.snapshotTaskDetail;
    }

    /**
     * <p>
     * A description of the import snapshot task.
     * </p>
     * 
     * @return A description of the import snapshot task.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the import snapshot task.
     * </p>
     * 
     * @return The ID of the import snapshot task.
     */
    public String importTaskId() {
        return importTaskId;
    }

    /**
     * <p>
     * Describes an import snapshot task.
     * </p>
     * 
     * @return Describes an import snapshot task.
     */
    public SnapshotTaskDetail snapshotTaskDetail() {
        return snapshotTaskDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(importTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotTaskDetail());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportSnapshotTask)) {
            return false;
        }
        ImportSnapshotTask other = (ImportSnapshotTask) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(importTaskId(), other.importTaskId())
                && Objects.equals(snapshotTaskDetail(), other.snapshotTaskDetail());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (importTaskId() != null) {
            sb.append("ImportTaskId: ").append(importTaskId()).append(",");
        }
        if (snapshotTaskDetail() != null) {
            sb.append("SnapshotTaskDetail: ").append(snapshotTaskDetail()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "ImportTaskId":
            return Optional.of(clazz.cast(importTaskId()));
        case "SnapshotTaskDetail":
            return Optional.of(clazz.cast(snapshotTaskDetail()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ImportSnapshotTask> {
        /**
         * <p>
         * A description of the import snapshot task.
         * </p>
         * 
         * @param description
         *        A description of the import snapshot task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the import snapshot task.
         * </p>
         * 
         * @param importTaskId
         *        The ID of the import snapshot task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importTaskId(String importTaskId);

        /**
         * <p>
         * Describes an import snapshot task.
         * </p>
         * 
         * @param snapshotTaskDetail
         *        Describes an import snapshot task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotTaskDetail(SnapshotTaskDetail snapshotTaskDetail);

        /**
         * <p>
         * Describes an import snapshot task.
         * </p>
         * This is a convenience that creates an instance of the {@link SnapshotTaskDetail.Builder} avoiding the need to
         * create one manually via {@link SnapshotTaskDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link SnapshotTaskDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #snapshotTaskDetail(SnapshotTaskDetail)}.
         * 
         * @param snapshotTaskDetail
         *        a consumer that will call methods on {@link SnapshotTaskDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snapshotTaskDetail(SnapshotTaskDetail)
         */
        default Builder snapshotTaskDetail(Consumer<SnapshotTaskDetail.Builder> snapshotTaskDetail) {
            return snapshotTaskDetail(SnapshotTaskDetail.builder().apply(snapshotTaskDetail).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String importTaskId;

        private SnapshotTaskDetail snapshotTaskDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportSnapshotTask model) {
            description(model.description);
            importTaskId(model.importTaskId);
            snapshotTaskDetail(model.snapshotTaskDetail);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getImportTaskId() {
            return importTaskId;
        }

        @Override
        public final Builder importTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
            return this;
        }

        public final void setImportTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
        }

        public final SnapshotTaskDetail.Builder getSnapshotTaskDetail() {
            return snapshotTaskDetail != null ? snapshotTaskDetail.toBuilder() : null;
        }

        @Override
        public final Builder snapshotTaskDetail(SnapshotTaskDetail snapshotTaskDetail) {
            this.snapshotTaskDetail = snapshotTaskDetail;
            return this;
        }

        public final void setSnapshotTaskDetail(SnapshotTaskDetail.BuilderImpl snapshotTaskDetail) {
            this.snapshotTaskDetail = snapshotTaskDetail != null ? snapshotTaskDetail.build() : null;
        }

        @Override
        public ImportSnapshotTask build() {
            return new ImportSnapshotTask(this);
        }
    }
}
