/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Reserved Instance listing state.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceCount implements ToCopyableBuilder<InstanceCount.Builder, InstanceCount> {
    private final Integer instanceCount;

    private final String state;

    private InstanceCount(BuilderImpl builder) {
        this.instanceCount = builder.instanceCount;
        this.state = builder.state;
    }

    /**
     * <p>
     * The number of listed Reserved Instances in the state specified by the <code>state</code>.
     * </p>
     * 
     * @return The number of listed Reserved Instances in the state specified by the <code>state</code>.
     */
    public Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The states of the listed Reserved Instances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ListingState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The states of the listed Reserved Instances.
     * @see ListingState
     */
    public ListingState state() {
        return ListingState.fromValue(state);
    }

    /**
     * <p>
     * The states of the listed Reserved Instances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ListingState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The states of the listed Reserved Instances.
     * @see ListingState
     */
    public String stateString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(stateString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceCount)) {
            return false;
        }
        InstanceCount other = (InstanceCount) obj;
        return Objects.equals(instanceCount(), other.instanceCount()) && Objects.equals(stateString(), other.stateString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (instanceCount() != null) {
            sb.append("InstanceCount: ").append(instanceCount()).append(",");
        }
        if (stateString() != null) {
            sb.append("State: ").append(stateString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceCount":
            return Optional.of(clazz.cast(instanceCount()));
        case "State":
            return Optional.of(clazz.cast(stateString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceCount> {
        /**
         * <p>
         * The number of listed Reserved Instances in the state specified by the <code>state</code>.
         * </p>
         * 
         * @param instanceCount
         *        The number of listed Reserved Instances in the state specified by the <code>state</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The states of the listed Reserved Instances.
         * </p>
         * 
         * @param state
         *        The states of the listed Reserved Instances.
         * @see ListingState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListingState
         */
        Builder state(String state);

        /**
         * <p>
         * The states of the listed Reserved Instances.
         * </p>
         * 
         * @param state
         *        The states of the listed Reserved Instances.
         * @see ListingState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListingState
         */
        Builder state(ListingState state);
    }

    static final class BuilderImpl implements Builder {
        private Integer instanceCount;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceCount model) {
            instanceCount(model.instanceCount);
            state(model.state);
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ListingState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public InstanceCount build() {
            return new InstanceCount(this);
        }
    }
}
