/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the attachment of a VPC to an Internet gateway or an egress-only Internet gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InternetGatewayAttachment implements ToCopyableBuilder<InternetGatewayAttachment.Builder, InternetGatewayAttachment> {
    private final String state;

    private final String vpcId;

    private InternetGatewayAttachment(BuilderImpl builder) {
        this.state = builder.state;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * The current state of the attachment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AttachmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The current state of the attachment.
     * @see AttachmentStatus
     */
    public AttachmentStatus state() {
        return AttachmentStatus.fromValue(state);
    }

    /**
     * <p>
     * The current state of the attachment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AttachmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The current state of the attachment.
     * @see AttachmentStatus
     */
    public String stateString() {
        return state;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateString());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InternetGatewayAttachment)) {
            return false;
        }
        InternetGatewayAttachment other = (InternetGatewayAttachment) obj;
        return Objects.equals(stateString(), other.stateString()) && Objects.equals(vpcId(), other.vpcId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (stateString() != null) {
            sb.append("State: ").append(stateString()).append(",");
        }
        if (vpcId() != null) {
            sb.append("VpcId: ").append(vpcId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "State":
            return Optional.of(clazz.cast(stateString()));
        case "VpcId":
            return Optional.of(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, InternetGatewayAttachment> {
        /**
         * <p>
         * The current state of the attachment.
         * </p>
         * 
         * @param state
         *        The current state of the attachment.
         * @see AttachmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentStatus
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the attachment.
         * </p>
         * 
         * @param state
         *        The current state of the attachment.
         * @see AttachmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentStatus
         */
        Builder state(AttachmentStatus state);

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private String state;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(InternetGatewayAttachment model) {
            state(model.state);
            vpcId(model.vpcId);
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AttachmentStatus state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public InternetGatewayAttachment build() {
            return new InternetGatewayAttachment(this);
        }
    }
}
