/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an IPv4 range.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class IpRange implements ToCopyableBuilder<IpRange.Builder, IpRange> {
    private final String cidrIp;

    private final String description;

    private IpRange(BuilderImpl builder) {
        this.cidrIp = builder.cidrIp;
        this.description = builder.description;
    }

    /**
     * <p>
     * The IPv4 CIDR range. You can either specify a CIDR range or a source security group, not both. To specify a
     * single IPv4 address, use the /32 prefix length.
     * </p>
     * 
     * @return The IPv4 CIDR range. You can either specify a CIDR range or a source security group, not both. To specify
     *         a single IPv4 address, use the /32 prefix length.
     */
    public String cidrIp() {
        return cidrIp;
    }

    /**
     * <p>
     * A description for the security group rule that references this IPv4 address range.
     * </p>
     * <p>
     * Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and
     * ._-:/()#,@[]+=;{}!$*
     * </p>
     * 
     * @return A description for the security group rule that references this IPv4 address range.</p>
     *         <p>
     *         Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and
     *         ._-:/()#,@[]+=;{}!$*
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cidrIp());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpRange)) {
            return false;
        }
        IpRange other = (IpRange) obj;
        return Objects.equals(cidrIp(), other.cidrIp()) && Objects.equals(description(), other.description());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (cidrIp() != null) {
            sb.append("CidrIp: ").append(cidrIp()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CidrIp":
            return Optional.of(clazz.cast(cidrIp()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, IpRange> {
        /**
         * <p>
         * The IPv4 CIDR range. You can either specify a CIDR range or a source security group, not both. To specify a
         * single IPv4 address, use the /32 prefix length.
         * </p>
         * 
         * @param cidrIp
         *        The IPv4 CIDR range. You can either specify a CIDR range or a source security group, not both. To
         *        specify a single IPv4 address, use the /32 prefix length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrIp(String cidrIp);

        /**
         * <p>
         * A description for the security group rule that references this IPv4 address range.
         * </p>
         * <p>
         * Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and
         * ._-:/()#,@[]+=;{}!$*
         * </p>
         * 
         * @param description
         *        A description for the security group rule that references this IPv4 address range.</p>
         *        <p>
         *        Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and
         *        ._-:/()#,@[]+=;{}!$*
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String cidrIp;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(IpRange model) {
            cidrIp(model.cidrIp);
            description(model.description);
        }

        public final String getCidrIp() {
            return cidrIp;
        }

        @Override
        public final Builder cidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
            return this;
        }

        public final void setCidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public IpRange build() {
            return new IpRange(this);
        }
    }
}
