/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a network ACL.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class NetworkAcl implements ToCopyableBuilder<NetworkAcl.Builder, NetworkAcl> {
    private final List<NetworkAclAssociation> associations;

    private final List<NetworkAclEntry> entries;

    private final Boolean isDefault;

    private final String networkAclId;

    private final List<Tag> tags;

    private final String vpcId;

    private NetworkAcl(BuilderImpl builder) {
        this.associations = builder.associations;
        this.entries = builder.entries;
        this.isDefault = builder.isDefault;
        this.networkAclId = builder.networkAclId;
        this.tags = builder.tags;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * Any associations between the network ACL and one or more subnets
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any associations between the network ACL and one or more subnets
     */
    public List<NetworkAclAssociation> associations() {
        return associations;
    }

    /**
     * <p>
     * One or more entries (rules) in the network ACL.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more entries (rules) in the network ACL.
     */
    public List<NetworkAclEntry> entries() {
        return entries;
    }

    /**
     * <p>
     * Indicates whether this is the default network ACL for the VPC.
     * </p>
     * 
     * @return Indicates whether this is the default network ACL for the VPC.
     */
    public Boolean isDefault() {
        return isDefault;
    }

    /**
     * <p>
     * The ID of the network ACL.
     * </p>
     * 
     * @return The ID of the network ACL.
     */
    public String networkAclId() {
        return networkAclId;
    }

    /**
     * <p>
     * Any tags assigned to the network ACL.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the network ACL.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The ID of the VPC for the network ACL.
     * </p>
     * 
     * @return The ID of the VPC for the network ACL.
     */
    public String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associations());
        hashCode = 31 * hashCode + Objects.hashCode(entries());
        hashCode = 31 * hashCode + Objects.hashCode(isDefault());
        hashCode = 31 * hashCode + Objects.hashCode(networkAclId());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkAcl)) {
            return false;
        }
        NetworkAcl other = (NetworkAcl) obj;
        return Objects.equals(associations(), other.associations()) && Objects.equals(entries(), other.entries())
                && Objects.equals(isDefault(), other.isDefault()) && Objects.equals(networkAclId(), other.networkAclId())
                && Objects.equals(tags(), other.tags()) && Objects.equals(vpcId(), other.vpcId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (associations() != null) {
            sb.append("Associations: ").append(associations()).append(",");
        }
        if (entries() != null) {
            sb.append("Entries: ").append(entries()).append(",");
        }
        if (isDefault() != null) {
            sb.append("IsDefault: ").append(isDefault()).append(",");
        }
        if (networkAclId() != null) {
            sb.append("NetworkAclId: ").append(networkAclId()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        if (vpcId() != null) {
            sb.append("VpcId: ").append(vpcId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Associations":
            return Optional.of(clazz.cast(associations()));
        case "Entries":
            return Optional.of(clazz.cast(entries()));
        case "IsDefault":
            return Optional.of(clazz.cast(isDefault()));
        case "NetworkAclId":
            return Optional.of(clazz.cast(networkAclId()));
        case "Tags":
            return Optional.of(clazz.cast(tags()));
        case "VpcId":
            return Optional.of(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, NetworkAcl> {
        /**
         * <p>
         * Any associations between the network ACL and one or more subnets
         * </p>
         * 
         * @param associations
         *        Any associations between the network ACL and one or more subnets
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(Collection<NetworkAclAssociation> associations);

        /**
         * <p>
         * Any associations between the network ACL and one or more subnets
         * </p>
         * 
         * @param associations
         *        Any associations between the network ACL and one or more subnets
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(NetworkAclAssociation... associations);

        /**
         * <p>
         * One or more entries (rules) in the network ACL.
         * </p>
         * 
         * @param entries
         *        One or more entries (rules) in the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(Collection<NetworkAclEntry> entries);

        /**
         * <p>
         * One or more entries (rules) in the network ACL.
         * </p>
         * 
         * @param entries
         *        One or more entries (rules) in the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(NetworkAclEntry... entries);

        /**
         * <p>
         * Indicates whether this is the default network ACL for the VPC.
         * </p>
         * 
         * @param isDefault
         *        Indicates whether this is the default network ACL for the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefault(Boolean isDefault);

        /**
         * <p>
         * The ID of the network ACL.
         * </p>
         * 
         * @param networkAclId
         *        The ID of the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAclId(String networkAclId);

        /**
         * <p>
         * Any tags assigned to the network ACL.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the network ACL.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The ID of the VPC for the network ACL.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC for the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private List<NetworkAclAssociation> associations;

        private List<NetworkAclEntry> entries;

        private Boolean isDefault;

        private String networkAclId;

        private List<Tag> tags;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkAcl model) {
            associations(model.associations);
            entries(model.entries);
            isDefault(model.isDefault);
            networkAclId(model.networkAclId);
            tags(model.tags);
            vpcId(model.vpcId);
        }

        public final Collection<NetworkAclAssociation.Builder> getAssociations() {
            return associations != null ? associations.stream().map(NetworkAclAssociation::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder associations(Collection<NetworkAclAssociation> associations) {
            this.associations = NetworkAclAssociationListCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(NetworkAclAssociation... associations) {
            associations(Arrays.asList(associations));
            return this;
        }

        public final void setAssociations(Collection<NetworkAclAssociation.BuilderImpl> associations) {
            this.associations = NetworkAclAssociationListCopier.copyFromBuilder(associations);
        }

        public final Collection<NetworkAclEntry.Builder> getEntries() {
            return entries != null ? entries.stream().map(NetworkAclEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entries(Collection<NetworkAclEntry> entries) {
            this.entries = NetworkAclEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(NetworkAclEntry... entries) {
            entries(Arrays.asList(entries));
            return this;
        }

        public final void setEntries(Collection<NetworkAclEntry.BuilderImpl> entries) {
            this.entries = NetworkAclEntryListCopier.copyFromBuilder(entries);
        }

        public final Boolean getIsDefault() {
            return isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        public final String getNetworkAclId() {
            return networkAclId;
        }

        @Override
        public final Builder networkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
            return this;
        }

        public final void setNetworkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public NetworkAcl build() {
            return new NetworkAcl(this);
        }
    }
}
