/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for RegisterImage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RegisterImageRequest extends EC2Request implements
        ToCopyableBuilder<RegisterImageRequest.Builder, RegisterImageRequest> {
    private final String imageLocation;

    private final String architecture;

    private final List<BlockDeviceMapping> blockDeviceMappings;

    private final String description;

    private final Boolean enaSupport;

    private final String kernelId;

    private final String name;

    private final List<String> billingProducts;

    private final String ramdiskId;

    private final String rootDeviceName;

    private final String sriovNetSupport;

    private final String virtualizationType;

    private RegisterImageRequest(BuilderImpl builder) {
        super(builder);
        this.imageLocation = builder.imageLocation;
        this.architecture = builder.architecture;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.description = builder.description;
        this.enaSupport = builder.enaSupport;
        this.kernelId = builder.kernelId;
        this.name = builder.name;
        this.billingProducts = builder.billingProducts;
        this.ramdiskId = builder.ramdiskId;
        this.rootDeviceName = builder.rootDeviceName;
        this.sriovNetSupport = builder.sriovNetSupport;
        this.virtualizationType = builder.virtualizationType;
    }

    /**
     * <p>
     * The full path to your AMI manifest in Amazon S3 storage.
     * </p>
     * 
     * @return The full path to your AMI manifest in Amazon S3 storage.
     */
    public String imageLocation() {
        return imageLocation;
    }

    /**
     * <p>
     * The architecture of the AMI.
     * </p>
     * <p>
     * Default: For Amazon EBS-backed AMIs, <code>i386</code>. For instance store-backed AMIs, the architecture
     * specified in the manifest file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link ArchitectureValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureString}.
     * </p>
     * 
     * @return The architecture of the AMI.</p>
     *         <p>
     *         Default: For Amazon EBS-backed AMIs, <code>i386</code>. For instance store-backed AMIs, the architecture
     *         specified in the manifest file.
     * @see ArchitectureValues
     */
    public ArchitectureValues architecture() {
        return ArchitectureValues.fromValue(architecture);
    }

    /**
     * <p>
     * The architecture of the AMI.
     * </p>
     * <p>
     * Default: For Amazon EBS-backed AMIs, <code>i386</code>. For instance store-backed AMIs, the architecture
     * specified in the manifest file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link ArchitectureValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureString}.
     * </p>
     * 
     * @return The architecture of the AMI.</p>
     *         <p>
     *         Default: For Amazon EBS-backed AMIs, <code>i386</code>. For instance store-backed AMIs, the architecture
     *         specified in the manifest file.
     * @see ArchitectureValues
     */
    public String architectureString() {
        return architecture;
    }

    /**
     * <p>
     * One or more block device mapping entries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more block device mapping entries.
     */
    public List<BlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * A description for your AMI.
     * </p>
     * 
     * @return A description for your AMI.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Set to <code>true</code> to enable enhanced networking with ENA for the AMI and any instances that you launch
     * from the AMI.
     * </p>
     * <p>
     * This option is supported only for HVM AMIs. Specifying this option with a PV AMI can make instances launched from
     * the AMI unreachable.
     * </p>
     * 
     * @return Set to <code>true</code> to enable enhanced networking with ENA for the AMI and any instances that you
     *         launch from the AMI.</p>
     *         <p>
     *         This option is supported only for HVM AMIs. Specifying this option with a PV AMI can make instances
     *         launched from the AMI unreachable.
     */
    public Boolean enaSupport() {
        return enaSupport;
    }

    /**
     * <p>
     * The ID of the kernel.
     * </p>
     * 
     * @return The ID of the kernel.
     */
    public String kernelId() {
        return kernelId;
    }

    /**
     * <p>
     * A name for your AMI.
     * </p>
     * <p>
     * Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets ([]), spaces ( ), periods (.),
     * slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_)
     * </p>
     * 
     * @return A name for your AMI.</p>
     *         <p>
     *         Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets ([]), spaces ( ), periods
     *         (.), slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_)
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The billing product codes. Your account must be authorized to specify billing product codes. Otherwise, you can
     * use the AWS Marketplace to bill for the use of an AMI.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The billing product codes. Your account must be authorized to specify billing product codes. Otherwise,
     *         you can use the AWS Marketplace to bill for the use of an AMI.
     */
    public List<String> billingProducts() {
        return billingProducts;
    }

    /**
     * <p>
     * The ID of the RAM disk.
     * </p>
     * 
     * @return The ID of the RAM disk.
     */
    public String ramdiskId() {
        return ramdiskId;
    }

    /**
     * <p>
     * The device name of the root device volume (for example, <code>/dev/sda1</code>).
     * </p>
     * 
     * @return The device name of the root device volume (for example, <code>/dev/sda1</code>).
     */
    public String rootDeviceName() {
        return rootDeviceName;
    }

    /**
     * <p>
     * Set to <code>simple</code> to enable enhanced networking with the Intel 82599 Virtual Function interface for the
     * AMI and any instances that you launch from the AMI.
     * </p>
     * <p>
     * There is no way to disable <code>sriovNetSupport</code> at this time.
     * </p>
     * <p>
     * This option is supported only for HVM AMIs. Specifying this option with a PV AMI can make instances launched from
     * the AMI unreachable.
     * </p>
     * 
     * @return Set to <code>simple</code> to enable enhanced networking with the Intel 82599 Virtual Function interface
     *         for the AMI and any instances that you launch from the AMI.</p>
     *         <p>
     *         There is no way to disable <code>sriovNetSupport</code> at this time.
     *         </p>
     *         <p>
     *         This option is supported only for HVM AMIs. Specifying this option with a PV AMI can make instances
     *         launched from the AMI unreachable.
     */
    public String sriovNetSupport() {
        return sriovNetSupport;
    }

    /**
     * <p>
     * The type of virtualization.
     * </p>
     * <p>
     * Default: <code>paravirtual</code>
     * </p>
     * 
     * @return The type of virtualization.</p>
     *         <p>
     *         Default: <code>paravirtual</code>
     */
    public String virtualizationType() {
        return virtualizationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageLocation());
        hashCode = 31 * hashCode + Objects.hashCode(architectureString());
        hashCode = 31 * hashCode + Objects.hashCode(blockDeviceMappings());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(enaSupport());
        hashCode = 31 * hashCode + Objects.hashCode(kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(billingProducts());
        hashCode = 31 * hashCode + Objects.hashCode(ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(rootDeviceName());
        hashCode = 31 * hashCode + Objects.hashCode(sriovNetSupport());
        hashCode = 31 * hashCode + Objects.hashCode(virtualizationType());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterImageRequest)) {
            return false;
        }
        RegisterImageRequest other = (RegisterImageRequest) obj;
        return Objects.equals(imageLocation(), other.imageLocation())
                && Objects.equals(architectureString(), other.architectureString())
                && Objects.equals(blockDeviceMappings(), other.blockDeviceMappings())
                && Objects.equals(description(), other.description()) && Objects.equals(enaSupport(), other.enaSupport())
                && Objects.equals(kernelId(), other.kernelId()) && Objects.equals(name(), other.name())
                && Objects.equals(billingProducts(), other.billingProducts()) && Objects.equals(ramdiskId(), other.ramdiskId())
                && Objects.equals(rootDeviceName(), other.rootDeviceName())
                && Objects.equals(sriovNetSupport(), other.sriovNetSupport())
                && Objects.equals(virtualizationType(), other.virtualizationType());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (imageLocation() != null) {
            sb.append("ImageLocation: ").append(imageLocation()).append(",");
        }
        if (architectureString() != null) {
            sb.append("Architecture: ").append(architectureString()).append(",");
        }
        if (blockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(blockDeviceMappings()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (enaSupport() != null) {
            sb.append("EnaSupport: ").append(enaSupport()).append(",");
        }
        if (kernelId() != null) {
            sb.append("KernelId: ").append(kernelId()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (billingProducts() != null) {
            sb.append("BillingProducts: ").append(billingProducts()).append(",");
        }
        if (ramdiskId() != null) {
            sb.append("RamdiskId: ").append(ramdiskId()).append(",");
        }
        if (rootDeviceName() != null) {
            sb.append("RootDeviceName: ").append(rootDeviceName()).append(",");
        }
        if (sriovNetSupport() != null) {
            sb.append("SriovNetSupport: ").append(sriovNetSupport()).append(",");
        }
        if (virtualizationType() != null) {
            sb.append("VirtualizationType: ").append(virtualizationType()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageLocation":
            return Optional.of(clazz.cast(imageLocation()));
        case "Architecture":
            return Optional.of(clazz.cast(architectureString()));
        case "BlockDeviceMappings":
            return Optional.of(clazz.cast(blockDeviceMappings()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "EnaSupport":
            return Optional.of(clazz.cast(enaSupport()));
        case "KernelId":
            return Optional.of(clazz.cast(kernelId()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "BillingProducts":
            return Optional.of(clazz.cast(billingProducts()));
        case "RamdiskId":
            return Optional.of(clazz.cast(ramdiskId()));
        case "RootDeviceName":
            return Optional.of(clazz.cast(rootDeviceName()));
        case "SriovNetSupport":
            return Optional.of(clazz.cast(sriovNetSupport()));
        case "VirtualizationType":
            return Optional.of(clazz.cast(virtualizationType()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, RegisterImageRequest> {
        /**
         * <p>
         * The full path to your AMI manifest in Amazon S3 storage.
         * </p>
         * 
         * @param imageLocation
         *        The full path to your AMI manifest in Amazon S3 storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageLocation(String imageLocation);

        /**
         * <p>
         * The architecture of the AMI.
         * </p>
         * <p>
         * Default: For Amazon EBS-backed AMIs, <code>i386</code>. For instance store-backed AMIs, the architecture
         * specified in the manifest file.
         * </p>
         * 
         * @param architecture
         *        The architecture of the AMI.</p>
         *        <p>
         *        Default: For Amazon EBS-backed AMIs, <code>i386</code>. For instance store-backed AMIs, the
         *        architecture specified in the manifest file.
         * @see ArchitectureValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArchitectureValues
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The architecture of the AMI.
         * </p>
         * <p>
         * Default: For Amazon EBS-backed AMIs, <code>i386</code>. For instance store-backed AMIs, the architecture
         * specified in the manifest file.
         * </p>
         * 
         * @param architecture
         *        The architecture of the AMI.</p>
         *        <p>
         *        Default: For Amazon EBS-backed AMIs, <code>i386</code>. For instance store-backed AMIs, the
         *        architecture specified in the manifest file.
         * @see ArchitectureValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArchitectureValues
         */
        Builder architecture(ArchitectureValues architecture);

        /**
         * <p>
         * One or more block device mapping entries.
         * </p>
         * 
         * @param blockDeviceMappings
         *        One or more block device mapping entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * One or more block device mapping entries.
         * </p>
         * 
         * @param blockDeviceMappings
         *        One or more block device mapping entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * A description for your AMI.
         * </p>
         * 
         * @param description
         *        A description for your AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Set to <code>true</code> to enable enhanced networking with ENA for the AMI and any instances that you launch
         * from the AMI.
         * </p>
         * <p>
         * This option is supported only for HVM AMIs. Specifying this option with a PV AMI can make instances launched
         * from the AMI unreachable.
         * </p>
         * 
         * @param enaSupport
         *        Set to <code>true</code> to enable enhanced networking with ENA for the AMI and any instances that you
         *        launch from the AMI.</p>
         *        <p>
         *        This option is supported only for HVM AMIs. Specifying this option with a PV AMI can make instances
         *        launched from the AMI unreachable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enaSupport(Boolean enaSupport);

        /**
         * <p>
         * The ID of the kernel.
         * </p>
         * 
         * @param kernelId
         *        The ID of the kernel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(String kernelId);

        /**
         * <p>
         * A name for your AMI.
         * </p>
         * <p>
         * Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets ([]), spaces ( ), periods (.),
         * slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_)
         * </p>
         * 
         * @param name
         *        A name for your AMI.</p>
         *        <p>
         *        Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets ([]), spaces ( ),
         *        periods (.), slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The billing product codes. Your account must be authorized to specify billing product codes. Otherwise, you
         * can use the AWS Marketplace to bill for the use of an AMI.
         * </p>
         * 
         * @param billingProducts
         *        The billing product codes. Your account must be authorized to specify billing product codes.
         *        Otherwise, you can use the AWS Marketplace to bill for the use of an AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingProducts(Collection<String> billingProducts);

        /**
         * <p>
         * The billing product codes. Your account must be authorized to specify billing product codes. Otherwise, you
         * can use the AWS Marketplace to bill for the use of an AMI.
         * </p>
         * 
         * @param billingProducts
         *        The billing product codes. Your account must be authorized to specify billing product codes.
         *        Otherwise, you can use the AWS Marketplace to bill for the use of an AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingProducts(String... billingProducts);

        /**
         * <p>
         * The ID of the RAM disk.
         * </p>
         * 
         * @param ramdiskId
         *        The ID of the RAM disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramdiskId(String ramdiskId);

        /**
         * <p>
         * The device name of the root device volume (for example, <code>/dev/sda1</code>).
         * </p>
         * 
         * @param rootDeviceName
         *        The device name of the root device volume (for example, <code>/dev/sda1</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootDeviceName(String rootDeviceName);

        /**
         * <p>
         * Set to <code>simple</code> to enable enhanced networking with the Intel 82599 Virtual Function interface for
         * the AMI and any instances that you launch from the AMI.
         * </p>
         * <p>
         * There is no way to disable <code>sriovNetSupport</code> at this time.
         * </p>
         * <p>
         * This option is supported only for HVM AMIs. Specifying this option with a PV AMI can make instances launched
         * from the AMI unreachable.
         * </p>
         * 
         * @param sriovNetSupport
         *        Set to <code>simple</code> to enable enhanced networking with the Intel 82599 Virtual Function
         *        interface for the AMI and any instances that you launch from the AMI.</p>
         *        <p>
         *        There is no way to disable <code>sriovNetSupport</code> at this time.
         *        </p>
         *        <p>
         *        This option is supported only for HVM AMIs. Specifying this option with a PV AMI can make instances
         *        launched from the AMI unreachable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sriovNetSupport(String sriovNetSupport);

        /**
         * <p>
         * The type of virtualization.
         * </p>
         * <p>
         * Default: <code>paravirtual</code>
         * </p>
         * 
         * @param virtualizationType
         *        The type of virtualization.</p>
         *        <p>
         *        Default: <code>paravirtual</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualizationType(String virtualizationType);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String imageLocation;

        private String architecture;

        private List<BlockDeviceMapping> blockDeviceMappings;

        private String description;

        private Boolean enaSupport;

        private String kernelId;

        private String name;

        private List<String> billingProducts;

        private String ramdiskId;

        private String rootDeviceName;

        private String sriovNetSupport;

        private String virtualizationType;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterImageRequest model) {
            imageLocation(model.imageLocation);
            architecture(model.architecture);
            blockDeviceMappings(model.blockDeviceMappings);
            description(model.description);
            enaSupport(model.enaSupport);
            kernelId(model.kernelId);
            name(model.name);
            billingProducts(model.billingProducts);
            ramdiskId(model.ramdiskId);
            rootDeviceName(model.rootDeviceName);
            sriovNetSupport(model.sriovNetSupport);
            virtualizationType(model.virtualizationType);
        }

        public final String getImageLocation() {
            return imageLocation;
        }

        @Override
        public final Builder imageLocation(String imageLocation) {
            this.imageLocation = imageLocation;
            return this;
        }

        public final void setImageLocation(String imageLocation) {
            this.imageLocation = imageLocation;
        }

        public final String getArchitecture() {
            return architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(ArchitectureValues architecture) {
            this.architecture(architecture.toString());
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final Collection<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            return blockDeviceMappings != null ? blockDeviceMappings.stream().map(BlockDeviceMapping::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingRequestListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingRequestListCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getEnaSupport() {
            return enaSupport;
        }

        @Override
        public final Builder enaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
            return this;
        }

        public final void setEnaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
        }

        public final String getKernelId() {
            return kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getBillingProducts() {
            return billingProducts;
        }

        @Override
        public final Builder billingProducts(Collection<String> billingProducts) {
            this.billingProducts = BillingProductListCopier.copy(billingProducts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder billingProducts(String... billingProducts) {
            billingProducts(Arrays.asList(billingProducts));
            return this;
        }

        public final void setBillingProducts(Collection<String> billingProducts) {
            this.billingProducts = BillingProductListCopier.copy(billingProducts);
        }

        public final String getRamdiskId() {
            return ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final String getRootDeviceName() {
            return rootDeviceName;
        }

        @Override
        public final Builder rootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
            return this;
        }

        public final void setRootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
        }

        public final String getSriovNetSupport() {
            return sriovNetSupport;
        }

        @Override
        public final Builder sriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
            return this;
        }

        public final void setSriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
        }

        public final String getVirtualizationType() {
            return virtualizationType;
        }

        @Override
        public final Builder virtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
            return this;
        }

        public final void setVirtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RegisterImageRequest build() {
            return new RegisterImageRequest(this);
        }
    }
}
