/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ReplaceIamInstanceProfileAssociationRequest extends EC2Request implements
        ToCopyableBuilder<ReplaceIamInstanceProfileAssociationRequest.Builder, ReplaceIamInstanceProfileAssociationRequest> {
    private final IamInstanceProfileSpecification iamInstanceProfile;

    private final String associationId;

    private ReplaceIamInstanceProfileAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.associationId = builder.associationId;
    }

    /**
     * <p>
     * The IAM instance profile.
     * </p>
     * 
     * @return The IAM instance profile.
     */
    public IamInstanceProfileSpecification iamInstanceProfile() {
        return iamInstanceProfile;
    }

    /**
     * <p>
     * The ID of the existing IAM instance profile association.
     * </p>
     * 
     * @return The ID of the existing IAM instance profile association.
     */
    public String associationId() {
        return associationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplaceIamInstanceProfileAssociationRequest)) {
            return false;
        }
        ReplaceIamInstanceProfileAssociationRequest other = (ReplaceIamInstanceProfileAssociationRequest) obj;
        return Objects.equals(iamInstanceProfile(), other.iamInstanceProfile())
                && Objects.equals(associationId(), other.associationId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (iamInstanceProfile() != null) {
            sb.append("IamInstanceProfile: ").append(iamInstanceProfile()).append(",");
        }
        if (associationId() != null) {
            sb.append("AssociationId: ").append(associationId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IamInstanceProfile":
            return Optional.of(clazz.cast(iamInstanceProfile()));
        case "AssociationId":
            return Optional.of(clazz.cast(associationId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, ReplaceIamInstanceProfileAssociationRequest> {
        /**
         * <p>
         * The IAM instance profile.
         * </p>
         * 
         * @param iamInstanceProfile
         *        The IAM instance profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile);

        /**
         * <p>
         * The IAM instance profile.
         * </p>
         * This is a convenience that creates an instance of the {@link IamInstanceProfileSpecification.Builder}
         * avoiding the need to create one manually via {@link IamInstanceProfileSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link IamInstanceProfileSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #iamInstanceProfile(IamInstanceProfileSpecification)}.
         * 
         * @param iamInstanceProfile
         *        a consumer that will call methods on {@link IamInstanceProfileSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamInstanceProfile(IamInstanceProfileSpecification)
         */
        default Builder iamInstanceProfile(Consumer<IamInstanceProfileSpecification.Builder> iamInstanceProfile) {
            return iamInstanceProfile(IamInstanceProfileSpecification.builder().apply(iamInstanceProfile).build());
        }

        /**
         * <p>
         * The ID of the existing IAM instance profile association.
         * </p>
         * 
         * @param associationId
         *        The ID of the existing IAM instance profile association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private IamInstanceProfileSpecification iamInstanceProfile;

        private String associationId;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplaceIamInstanceProfileAssociationRequest model) {
            iamInstanceProfile(model.iamInstanceProfile);
            associationId(model.associationId);
        }

        public final IamInstanceProfileSpecification.Builder getIamInstanceProfile() {
            return iamInstanceProfile != null ? iamInstanceProfile.toBuilder() : null;
        }

        @Override
        public final Builder iamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(IamInstanceProfileSpecification.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        public final String getAssociationId() {
            return associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ReplaceIamInstanceProfileAssociationRequest build() {
            return new ReplaceIamInstanceProfileAssociationRequest(this);
        }
    }
}
