/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for RequestSpotFleet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RequestSpotFleetRequest extends EC2Request implements
        ToCopyableBuilder<RequestSpotFleetRequest.Builder, RequestSpotFleetRequest> {
    private final SpotFleetRequestConfigData spotFleetRequestConfig;

    private RequestSpotFleetRequest(BuilderImpl builder) {
        super(builder);
        this.spotFleetRequestConfig = builder.spotFleetRequestConfig;
    }

    /**
     * <p>
     * The configuration for the Spot fleet request.
     * </p>
     * 
     * @return The configuration for the Spot fleet request.
     */
    public SpotFleetRequestConfigData spotFleetRequestConfig() {
        return spotFleetRequestConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(spotFleetRequestConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestSpotFleetRequest)) {
            return false;
        }
        RequestSpotFleetRequest other = (RequestSpotFleetRequest) obj;
        return Objects.equals(spotFleetRequestConfig(), other.spotFleetRequestConfig());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (spotFleetRequestConfig() != null) {
            sb.append("SpotFleetRequestConfig: ").append(spotFleetRequestConfig()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SpotFleetRequestConfig":
            return Optional.of(clazz.cast(spotFleetRequestConfig()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, RequestSpotFleetRequest> {
        /**
         * <p>
         * The configuration for the Spot fleet request.
         * </p>
         * 
         * @param spotFleetRequestConfig
         *        The configuration for the Spot fleet request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotFleetRequestConfig(SpotFleetRequestConfigData spotFleetRequestConfig);

        /**
         * <p>
         * The configuration for the Spot fleet request.
         * </p>
         * This is a convenience that creates an instance of the {@link SpotFleetRequestConfigData.Builder} avoiding the
         * need to create one manually via {@link SpotFleetRequestConfigData#builder()}.
         *
         * When the {@link Consumer} completes, {@link SpotFleetRequestConfigData.Builder#build()} is called immediately
         * and its result is passed to {@link #spotFleetRequestConfig(SpotFleetRequestConfigData)}.
         * 
         * @param spotFleetRequestConfig
         *        a consumer that will call methods on {@link SpotFleetRequestConfigData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spotFleetRequestConfig(SpotFleetRequestConfigData)
         */
        default Builder spotFleetRequestConfig(Consumer<SpotFleetRequestConfigData.Builder> spotFleetRequestConfig) {
            return spotFleetRequestConfig(SpotFleetRequestConfigData.builder().apply(spotFleetRequestConfig).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private SpotFleetRequestConfigData spotFleetRequestConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestSpotFleetRequest model) {
            spotFleetRequestConfig(model.spotFleetRequestConfig);
        }

        public final SpotFleetRequestConfigData.Builder getSpotFleetRequestConfig() {
            return spotFleetRequestConfig != null ? spotFleetRequestConfig.toBuilder() : null;
        }

        @Override
        public final Builder spotFleetRequestConfig(SpotFleetRequestConfigData spotFleetRequestConfig) {
            this.spotFleetRequestConfig = spotFleetRequestConfig;
            return this;
        }

        public final void setSpotFleetRequestConfig(SpotFleetRequestConfigData.BuilderImpl spotFleetRequestConfig) {
            this.spotFleetRequestConfig = spotFleetRequestConfig != null ? spotFleetRequestConfig.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RequestSpotFleetRequest build() {
            return new RequestSpotFleetRequest(this);
        }
    }
}
