/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a reservation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Reservation implements ToCopyableBuilder<Reservation.Builder, Reservation> {
    private final List<GroupIdentifier> groups;

    private final List<Instance> instances;

    private final String ownerId;

    private final String requesterId;

    private final String reservationId;

    private final List<String> groupNames;

    private Reservation(BuilderImpl builder) {
        this.groups = builder.groups;
        this.instances = builder.instances;
        this.ownerId = builder.ownerId;
        this.requesterId = builder.requesterId;
        this.reservationId = builder.reservationId;
        this.groupNames = builder.groupNames;
    }

    /**
     * <p>
     * [EC2-Classic only] One or more security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return [EC2-Classic only] One or more security groups.
     */
    public List<GroupIdentifier> groups() {
        return groups;
    }

    /**
     * <p>
     * One or more instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more instances.
     */
    public List<Instance> instances() {
        return instances;
    }

    /**
     * <p>
     * The ID of the AWS account that owns the reservation.
     * </p>
     * 
     * @return The ID of the AWS account that owns the reservation.
     */
    public String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The ID of the requester that launched the instances on your behalf (for example, AWS Management Console or Auto
     * Scaling).
     * </p>
     * 
     * @return The ID of the requester that launched the instances on your behalf (for example, AWS Management Console
     *         or Auto Scaling).
     */
    public String requesterId() {
        return requesterId;
    }

    /**
     * <p>
     * The ID of the reservation.
     * </p>
     * 
     * @return The ID of the reservation.
     */
    public String reservationId() {
        return reservationId;
    }

    /**
     * <p>
     * One or more security group names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more security group names.
     */
    public List<String> groupNames() {
        return groupNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groups());
        hashCode = 31 * hashCode + Objects.hashCode(instances());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(requesterId());
        hashCode = 31 * hashCode + Objects.hashCode(reservationId());
        hashCode = 31 * hashCode + Objects.hashCode(groupNames());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Reservation)) {
            return false;
        }
        Reservation other = (Reservation) obj;
        return Objects.equals(groups(), other.groups()) && Objects.equals(instances(), other.instances())
                && Objects.equals(ownerId(), other.ownerId()) && Objects.equals(requesterId(), other.requesterId())
                && Objects.equals(reservationId(), other.reservationId()) && Objects.equals(groupNames(), other.groupNames());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (groups() != null) {
            sb.append("Groups: ").append(groups()).append(",");
        }
        if (instances() != null) {
            sb.append("Instances: ").append(instances()).append(",");
        }
        if (ownerId() != null) {
            sb.append("OwnerId: ").append(ownerId()).append(",");
        }
        if (requesterId() != null) {
            sb.append("RequesterId: ").append(requesterId()).append(",");
        }
        if (reservationId() != null) {
            sb.append("ReservationId: ").append(reservationId()).append(",");
        }
        if (groupNames() != null) {
            sb.append("GroupNames: ").append(groupNames()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Groups":
            return Optional.of(clazz.cast(groups()));
        case "Instances":
            return Optional.of(clazz.cast(instances()));
        case "OwnerId":
            return Optional.of(clazz.cast(ownerId()));
        case "RequesterId":
            return Optional.of(clazz.cast(requesterId()));
        case "ReservationId":
            return Optional.of(clazz.cast(reservationId()));
        case "GroupNames":
            return Optional.of(clazz.cast(groupNames()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Reservation> {
        /**
         * <p>
         * [EC2-Classic only] One or more security groups.
         * </p>
         * 
         * @param groups
         *        [EC2-Classic only] One or more security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<GroupIdentifier> groups);

        /**
         * <p>
         * [EC2-Classic only] One or more security groups.
         * </p>
         * 
         * @param groups
         *        [EC2-Classic only] One or more security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(GroupIdentifier... groups);

        /**
         * <p>
         * One or more instances.
         * </p>
         * 
         * @param instances
         *        One or more instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Collection<Instance> instances);

        /**
         * <p>
         * One or more instances.
         * </p>
         * 
         * @param instances
         *        One or more instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Instance... instances);

        /**
         * <p>
         * The ID of the AWS account that owns the reservation.
         * </p>
         * 
         * @param ownerId
         *        The ID of the AWS account that owns the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The ID of the requester that launched the instances on your behalf (for example, AWS Management Console or
         * Auto Scaling).
         * </p>
         * 
         * @param requesterId
         *        The ID of the requester that launched the instances on your behalf (for example, AWS Management
         *        Console or Auto Scaling).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterId(String requesterId);

        /**
         * <p>
         * The ID of the reservation.
         * </p>
         * 
         * @param reservationId
         *        The ID of the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservationId(String reservationId);

        /**
         * <p>
         * One or more security group names.
         * </p>
         * 
         * @param groupNames
         *        One or more security group names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupNames(Collection<String> groupNames);

        /**
         * <p>
         * One or more security group names.
         * </p>
         * 
         * @param groupNames
         *        One or more security group names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupNames(String... groupNames);
    }

    static final class BuilderImpl implements Builder {
        private List<GroupIdentifier> groups;

        private List<Instance> instances;

        private String ownerId;

        private String requesterId;

        private String reservationId;

        private List<String> groupNames;

        private BuilderImpl() {
        }

        private BuilderImpl(Reservation model) {
            groups(model.groups);
            instances(model.instances);
            ownerId(model.ownerId);
            requesterId(model.requesterId);
            reservationId(model.reservationId);
            groupNames(model.groupNames);
        }

        public final Collection<GroupIdentifier.Builder> getGroups() {
            return groups != null ? groups.stream().map(GroupIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groups(Collection<GroupIdentifier> groups) {
            this.groups = GroupIdentifierListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupIdentifier... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<GroupIdentifier.BuilderImpl> groups) {
            this.groups = GroupIdentifierListCopier.copyFromBuilder(groups);
        }

        public final Collection<Instance.Builder> getInstances() {
            return instances != null ? instances.stream().map(Instance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instances(Collection<Instance> instances) {
            this.instances = InstanceListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Instance... instances) {
            instances(Arrays.asList(instances));
            return this;
        }

        public final void setInstances(Collection<Instance.BuilderImpl> instances) {
            this.instances = InstanceListCopier.copyFromBuilder(instances);
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getRequesterId() {
            return requesterId;
        }

        @Override
        public final Builder requesterId(String requesterId) {
            this.requesterId = requesterId;
            return this;
        }

        public final void setRequesterId(String requesterId) {
            this.requesterId = requesterId;
        }

        public final String getReservationId() {
            return reservationId;
        }

        @Override
        public final Builder reservationId(String reservationId) {
            this.reservationId = reservationId;
            return this;
        }

        public final void setReservationId(String reservationId) {
            this.reservationId = reservationId;
        }

        public final Collection<String> getGroupNames() {
            return groupNames;
        }

        @Override
        public final Builder groupNames(Collection<String> groupNames) {
            this.groupNames = GroupNameStringListCopier.copy(groupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupNames(String... groupNames) {
            groupNames(Arrays.asList(groupNames));
            return this;
        }

        public final void setGroupNames(Collection<String> groupNames) {
            this.groupNames = GroupNameStringListCopier.copy(groupNames);
        }

        @Override
        public Reservation build() {
            return new Reservation(this);
        }
    }
}
