/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the S3 bucket for the disk image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UserBucket implements ToCopyableBuilder<UserBucket.Builder, UserBucket> {
    private final String s3Bucket;

    private final String s3Key;

    private UserBucket(BuilderImpl builder) {
        this.s3Bucket = builder.s3Bucket;
        this.s3Key = builder.s3Key;
    }

    /**
     * <p>
     * The name of the S3 bucket where the disk image is located.
     * </p>
     * 
     * @return The name of the S3 bucket where the disk image is located.
     */
    public String s3Bucket() {
        return s3Bucket;
    }

    /**
     * <p>
     * The file name of the disk image.
     * </p>
     * 
     * @return The file name of the disk image.
     */
    public String s3Key() {
        return s3Key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(s3Key());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserBucket)) {
            return false;
        }
        UserBucket other = (UserBucket) obj;
        return Objects.equals(s3Bucket(), other.s3Bucket()) && Objects.equals(s3Key(), other.s3Key());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (s3Bucket() != null) {
            sb.append("S3Bucket: ").append(s3Bucket()).append(",");
        }
        if (s3Key() != null) {
            sb.append("S3Key: ").append(s3Key()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Bucket":
            return Optional.of(clazz.cast(s3Bucket()));
        case "S3Key":
            return Optional.of(clazz.cast(s3Key()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, UserBucket> {
        /**
         * <p>
         * The name of the S3 bucket where the disk image is located.
         * </p>
         * 
         * @param s3Bucket
         *        The name of the S3 bucket where the disk image is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(String s3Bucket);

        /**
         * <p>
         * The file name of the disk image.
         * </p>
         * 
         * @param s3Key
         *        The file name of the disk image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Key(String s3Key);
    }

    static final class BuilderImpl implements Builder {
        private String s3Bucket;

        private String s3Key;

        private BuilderImpl() {
        }

        private BuilderImpl(UserBucket model) {
            s3Bucket(model.s3Bucket);
            s3Key(model.s3Key);
        }

        public final String getS3Bucket() {
            return s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        public final String getS3Key() {
            return s3Key;
        }

        @Override
        public final Builder s3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        public final void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        @Override
        public UserBucket build() {
            return new UserBucket(this);
        }
    }
}
