/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Volume implements ToCopyableBuilder<Volume.Builder, Volume> {
    private final List<VolumeAttachment> attachments;

    private final String availabilityZone;

    private final Instant createTime;

    private final Boolean encrypted;

    private final String kmsKeyId;

    private final Integer size;

    private final String snapshotId;

    private final String state;

    private final String volumeId;

    private final Integer iops;

    private final List<Tag> tags;

    private final String volumeType;

    private Volume(BuilderImpl builder) {
        this.attachments = builder.attachments;
        this.availabilityZone = builder.availabilityZone;
        this.createTime = builder.createTime;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.size = builder.size;
        this.snapshotId = builder.snapshotId;
        this.state = builder.state;
        this.volumeId = builder.volumeId;
        this.iops = builder.iops;
        this.tags = builder.tags;
        this.volumeType = builder.volumeType;
    }

    /**
     * <p>
     * Information about the volume attachments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the volume attachments.
     */
    public List<VolumeAttachment> attachments() {
        return attachments;
    }

    /**
     * <p>
     * The Availability Zone for the volume.
     * </p>
     * 
     * @return The Availability Zone for the volume.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The time stamp when volume creation was initiated.
     * </p>
     * 
     * @return The time stamp when volume creation was initiated.
     */
    public Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * Indicates whether the volume will be encrypted.
     * </p>
     * 
     * @return Indicates whether the volume will be encrypted.
     */
    public Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The full ARN of the AWS Key Management Service (AWS KMS) customer master key (CMK) that was used to protect the
     * volume encryption key for the volume.
     * </p>
     * 
     * @return The full ARN of the AWS Key Management Service (AWS KMS) customer master key (CMK) that was used to
     *         protect the volume encryption key for the volume.
     */
    public String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The size of the volume, in GiBs.
     * </p>
     * 
     * @return The size of the volume, in GiBs.
     */
    public Integer size() {
        return size;
    }

    /**
     * <p>
     * The snapshot from which the volume was created, if applicable.
     * </p>
     * 
     * @return The snapshot from which the volume was created, if applicable.
     */
    public String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The volume state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VolumeState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The volume state.
     * @see VolumeState
     */
    public VolumeState state() {
        return VolumeState.fromValue(state);
    }

    /**
     * <p>
     * The volume state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VolumeState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The volume state.
     * @see VolumeState
     */
    public String stateString() {
        return state;
    }

    /**
     * <p>
     * The ID of the volume.
     * </p>
     * 
     * @return The ID of the volume.
     */
    public String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * The number of I/O operations per second (IOPS) that the volume supports. For Provisioned IOPS SSD volumes, this
     * represents the number of IOPS that are provisioned for the volume. For General Purpose SSD volumes, this
     * represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for
     * bursting. For more information on General Purpose SSD baseline performance, I/O credits, and bursting, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS Volume Types</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * Constraint: Range is 100-20000 IOPS for io1 volumes and 100-10000 IOPS for <code>gp2</code> volumes.
     * </p>
     * <p>
     * Condition: This parameter is required for requests to create <code>io1</code> volumes; it is not used in requests
     * to create <code>gp2</code>, <code>st1</code>, <code>sc1</code>, or <code>standard</code> volumes.
     * </p>
     * 
     * @return The number of I/O operations per second (IOPS) that the volume supports. For Provisioned IOPS SSD
     *         volumes, this represents the number of IOPS that are provisioned for the volume. For General Purpose SSD
     *         volumes, this represents the baseline performance of the volume and the rate at which the volume
     *         accumulates I/O credits for bursting. For more information on General Purpose SSD baseline performance,
     *         I/O credits, and bursting, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS Volume Types</a>
     *         in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
     *         <p>
     *         Constraint: Range is 100-20000 IOPS for io1 volumes and 100-10000 IOPS for <code>gp2</code> volumes.
     *         </p>
     *         <p>
     *         Condition: This parameter is required for requests to create <code>io1</code> volumes; it is not used in
     *         requests to create <code>gp2</code>, <code>st1</code>, <code>sc1</code>, or <code>standard</code>
     *         volumes.
     */
    public Integer iops() {
        return iops;
    }

    /**
     * <p>
     * Any tags assigned to the volume.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the volume.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The volume type. This can be <code>gp2</code> for General Purpose SSD, <code>io1</code> for Provisioned IOPS SSD,
     * <code>st1</code> for Throughput Optimized HDD, <code>sc1</code> for Cold HDD, or <code>standard</code> for
     * Magnetic volumes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeType} will
     * return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeTypeString}.
     * </p>
     * 
     * @return The volume type. This can be <code>gp2</code> for General Purpose SSD, <code>io1</code> for Provisioned
     *         IOPS SSD, <code>st1</code> for Throughput Optimized HDD, <code>sc1</code> for Cold HDD, or
     *         <code>standard</code> for Magnetic volumes.
     * @see VolumeType
     */
    public VolumeType volumeType() {
        return VolumeType.fromValue(volumeType);
    }

    /**
     * <p>
     * The volume type. This can be <code>gp2</code> for General Purpose SSD, <code>io1</code> for Provisioned IOPS SSD,
     * <code>st1</code> for Throughput Optimized HDD, <code>sc1</code> for Cold HDD, or <code>standard</code> for
     * Magnetic volumes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeType} will
     * return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeTypeString}.
     * </p>
     * 
     * @return The volume type. This can be <code>gp2</code> for General Purpose SSD, <code>io1</code> for Provisioned
     *         IOPS SSD, <code>st1</code> for Throughput Optimized HDD, <code>sc1</code> for Cold HDD, or
     *         <code>standard</code> for Magnetic volumes.
     * @see VolumeType
     */
    public String volumeTypeString() {
        return volumeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachments());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(stateString());
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(volumeTypeString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Volume)) {
            return false;
        }
        Volume other = (Volume) obj;
        return Objects.equals(attachments(), other.attachments()) && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(encrypted(), other.encrypted())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(size(), other.size())
                && Objects.equals(snapshotId(), other.snapshotId()) && Objects.equals(stateString(), other.stateString())
                && Objects.equals(volumeId(), other.volumeId()) && Objects.equals(iops(), other.iops())
                && Objects.equals(tags(), other.tags()) && Objects.equals(volumeTypeString(), other.volumeTypeString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (attachments() != null) {
            sb.append("Attachments: ").append(attachments()).append(",");
        }
        if (availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(availabilityZone()).append(",");
        }
        if (createTime() != null) {
            sb.append("CreateTime: ").append(createTime()).append(",");
        }
        if (encrypted() != null) {
            sb.append("Encrypted: ").append(encrypted()).append(",");
        }
        if (kmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(kmsKeyId()).append(",");
        }
        if (size() != null) {
            sb.append("Size: ").append(size()).append(",");
        }
        if (snapshotId() != null) {
            sb.append("SnapshotId: ").append(snapshotId()).append(",");
        }
        if (stateString() != null) {
            sb.append("State: ").append(stateString()).append(",");
        }
        if (volumeId() != null) {
            sb.append("VolumeId: ").append(volumeId()).append(",");
        }
        if (iops() != null) {
            sb.append("Iops: ").append(iops()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        if (volumeTypeString() != null) {
            sb.append("VolumeType: ").append(volumeTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attachments":
            return Optional.of(clazz.cast(attachments()));
        case "AvailabilityZone":
            return Optional.of(clazz.cast(availabilityZone()));
        case "CreateTime":
            return Optional.of(clazz.cast(createTime()));
        case "Encrypted":
            return Optional.of(clazz.cast(encrypted()));
        case "KmsKeyId":
            return Optional.of(clazz.cast(kmsKeyId()));
        case "Size":
            return Optional.of(clazz.cast(size()));
        case "SnapshotId":
            return Optional.of(clazz.cast(snapshotId()));
        case "State":
            return Optional.of(clazz.cast(stateString()));
        case "VolumeId":
            return Optional.of(clazz.cast(volumeId()));
        case "Iops":
            return Optional.of(clazz.cast(iops()));
        case "Tags":
            return Optional.of(clazz.cast(tags()));
        case "VolumeType":
            return Optional.of(clazz.cast(volumeTypeString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Volume> {
        /**
         * <p>
         * Information about the volume attachments.
         * </p>
         * 
         * @param attachments
         *        Information about the volume attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(Collection<VolumeAttachment> attachments);

        /**
         * <p>
         * Information about the volume attachments.
         * </p>
         * 
         * @param attachments
         *        Information about the volume attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(VolumeAttachment... attachments);

        /**
         * <p>
         * The Availability Zone for the volume.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone for the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The time stamp when volume creation was initiated.
         * </p>
         * 
         * @param createTime
         *        The time stamp when volume creation was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * Indicates whether the volume will be encrypted.
         * </p>
         * 
         * @param encrypted
         *        Indicates whether the volume will be encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The full ARN of the AWS Key Management Service (AWS KMS) customer master key (CMK) that was used to protect
         * the volume encryption key for the volume.
         * </p>
         * 
         * @param kmsKeyId
         *        The full ARN of the AWS Key Management Service (AWS KMS) customer master key (CMK) that was used to
         *        protect the volume encryption key for the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The size of the volume, in GiBs.
         * </p>
         * 
         * @param size
         *        The size of the volume, in GiBs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Integer size);

        /**
         * <p>
         * The snapshot from which the volume was created, if applicable.
         * </p>
         * 
         * @param snapshotId
         *        The snapshot from which the volume was created, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The volume state.
         * </p>
         * 
         * @param state
         *        The volume state.
         * @see VolumeState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeState
         */
        Builder state(String state);

        /**
         * <p>
         * The volume state.
         * </p>
         * 
         * @param state
         *        The volume state.
         * @see VolumeState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeState
         */
        Builder state(VolumeState state);

        /**
         * <p>
         * The ID of the volume.
         * </p>
         * 
         * @param volumeId
         *        The ID of the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * The number of I/O operations per second (IOPS) that the volume supports. For Provisioned IOPS SSD volumes,
         * this represents the number of IOPS that are provisioned for the volume. For General Purpose SSD volumes, this
         * represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits
         * for bursting. For more information on General Purpose SSD baseline performance, I/O credits, and bursting,
         * see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS Volume
         * Types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * <p>
         * Constraint: Range is 100-20000 IOPS for io1 volumes and 100-10000 IOPS for <code>gp2</code> volumes.
         * </p>
         * <p>
         * Condition: This parameter is required for requests to create <code>io1</code> volumes; it is not used in
         * requests to create <code>gp2</code>, <code>st1</code>, <code>sc1</code>, or <code>standard</code> volumes.
         * </p>
         * 
         * @param iops
         *        The number of I/O operations per second (IOPS) that the volume supports. For Provisioned IOPS SSD
         *        volumes, this represents the number of IOPS that are provisioned for the volume. For General Purpose
         *        SSD volumes, this represents the baseline performance of the volume and the rate at which the volume
         *        accumulates I/O credits for bursting. For more information on General Purpose SSD baseline
         *        performance, I/O credits, and bursting, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS Volume
         *        Types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
         *        <p>
         *        Constraint: Range is 100-20000 IOPS for io1 volumes and 100-10000 IOPS for <code>gp2</code> volumes.
         *        </p>
         *        <p>
         *        Condition: This parameter is required for requests to create <code>io1</code> volumes; it is not used
         *        in requests to create <code>gp2</code>, <code>st1</code>, <code>sc1</code>, or <code>standard</code>
         *        volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * Any tags assigned to the volume.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the volume.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The volume type. This can be <code>gp2</code> for General Purpose SSD, <code>io1</code> for Provisioned IOPS
         * SSD, <code>st1</code> for Throughput Optimized HDD, <code>sc1</code> for Cold HDD, or <code>standard</code>
         * for Magnetic volumes.
         * </p>
         * 
         * @param volumeType
         *        The volume type. This can be <code>gp2</code> for General Purpose SSD, <code>io1</code> for
         *        Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized HDD, <code>sc1</code> for Cold HDD, or
         *        <code>standard</code> for Magnetic volumes.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder volumeType(String volumeType);

        /**
         * <p>
         * The volume type. This can be <code>gp2</code> for General Purpose SSD, <code>io1</code> for Provisioned IOPS
         * SSD, <code>st1</code> for Throughput Optimized HDD, <code>sc1</code> for Cold HDD, or <code>standard</code>
         * for Magnetic volumes.
         * </p>
         * 
         * @param volumeType
         *        The volume type. This can be <code>gp2</code> for General Purpose SSD, <code>io1</code> for
         *        Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized HDD, <code>sc1</code> for Cold HDD, or
         *        <code>standard</code> for Magnetic volumes.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder volumeType(VolumeType volumeType);
    }

    static final class BuilderImpl implements Builder {
        private List<VolumeAttachment> attachments;

        private String availabilityZone;

        private Instant createTime;

        private Boolean encrypted;

        private String kmsKeyId;

        private Integer size;

        private String snapshotId;

        private String state;

        private String volumeId;

        private Integer iops;

        private List<Tag> tags;

        private String volumeType;

        private BuilderImpl() {
        }

        private BuilderImpl(Volume model) {
            attachments(model.attachments);
            availabilityZone(model.availabilityZone);
            createTime(model.createTime);
            encrypted(model.encrypted);
            kmsKeyId(model.kmsKeyId);
            size(model.size);
            snapshotId(model.snapshotId);
            state(model.state);
            volumeId(model.volumeId);
            iops(model.iops);
            tags(model.tags);
            volumeType(model.volumeType);
        }

        public final Collection<VolumeAttachment.Builder> getAttachments() {
            return attachments != null ? attachments.stream().map(VolumeAttachment::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder attachments(Collection<VolumeAttachment> attachments) {
            this.attachments = VolumeAttachmentListCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(VolumeAttachment... attachments) {
            attachments(Arrays.asList(attachments));
            return this;
        }

        public final void setAttachments(Collection<VolumeAttachment.BuilderImpl> attachments) {
            this.attachments = VolumeAttachmentListCopier.copyFromBuilder(attachments);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Integer getSize() {
            return size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VolumeState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getVolumeId() {
            return volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        public final Integer getIops() {
            return iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getVolumeType() {
            return volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(VolumeType volumeType) {
            this.volumeType(volumeType.toString());
            return this;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public Volume build() {
            return new Volume(this);
        }
    }
}
