/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an IPv4 CIDR block associated with a VPC.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VpcCidrBlockAssociation implements ToCopyableBuilder<VpcCidrBlockAssociation.Builder, VpcCidrBlockAssociation> {
    private final String associationId;

    private final String cidrBlock;

    private final VpcCidrBlockState cidrBlockState;

    private VpcCidrBlockAssociation(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.cidrBlock = builder.cidrBlock;
        this.cidrBlockState = builder.cidrBlockState;
    }

    /**
     * <p>
     * The association ID for the IPv4 CIDR block.
     * </p>
     * 
     * @return The association ID for the IPv4 CIDR block.
     */
    public String associationId() {
        return associationId;
    }

    /**
     * <p>
     * The IPv4 CIDR block.
     * </p>
     * 
     * @return The IPv4 CIDR block.
     */
    public String cidrBlock() {
        return cidrBlock;
    }

    /**
     * <p>
     * Information about the state of the CIDR block.
     * </p>
     * 
     * @return Information about the state of the CIDR block.
     */
    public VpcCidrBlockState cidrBlockState() {
        return cidrBlockState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(cidrBlockState());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcCidrBlockAssociation)) {
            return false;
        }
        VpcCidrBlockAssociation other = (VpcCidrBlockAssociation) obj;
        return Objects.equals(associationId(), other.associationId()) && Objects.equals(cidrBlock(), other.cidrBlock())
                && Objects.equals(cidrBlockState(), other.cidrBlockState());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (associationId() != null) {
            sb.append("AssociationId: ").append(associationId()).append(",");
        }
        if (cidrBlock() != null) {
            sb.append("CidrBlock: ").append(cidrBlock()).append(",");
        }
        if (cidrBlockState() != null) {
            sb.append("CidrBlockState: ").append(cidrBlockState()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociationId":
            return Optional.of(clazz.cast(associationId()));
        case "CidrBlock":
            return Optional.of(clazz.cast(cidrBlock()));
        case "CidrBlockState":
            return Optional.of(clazz.cast(cidrBlockState()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, VpcCidrBlockAssociation> {
        /**
         * <p>
         * The association ID for the IPv4 CIDR block.
         * </p>
         * 
         * @param associationId
         *        The association ID for the IPv4 CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * The IPv4 CIDR block.
         * </p>
         * 
         * @param cidrBlock
         *        The IPv4 CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlock(String cidrBlock);

        /**
         * <p>
         * Information about the state of the CIDR block.
         * </p>
         * 
         * @param cidrBlockState
         *        Information about the state of the CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlockState(VpcCidrBlockState cidrBlockState);

        /**
         * <p>
         * Information about the state of the CIDR block.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcCidrBlockState.Builder} avoiding the need to
         * create one manually via {@link VpcCidrBlockState#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcCidrBlockState.Builder#build()} is called immediately and its
         * result is passed to {@link #cidrBlockState(VpcCidrBlockState)}.
         * 
         * @param cidrBlockState
         *        a consumer that will call methods on {@link VpcCidrBlockState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cidrBlockState(VpcCidrBlockState)
         */
        default Builder cidrBlockState(Consumer<VpcCidrBlockState.Builder> cidrBlockState) {
            return cidrBlockState(VpcCidrBlockState.builder().apply(cidrBlockState).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String associationId;

        private String cidrBlock;

        private VpcCidrBlockState cidrBlockState;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcCidrBlockAssociation model) {
            associationId(model.associationId);
            cidrBlock(model.cidrBlock);
            cidrBlockState(model.cidrBlockState);
        }

        public final String getAssociationId() {
            return associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final String getCidrBlock() {
            return cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        public final VpcCidrBlockState.Builder getCidrBlockState() {
            return cidrBlockState != null ? cidrBlockState.toBuilder() : null;
        }

        @Override
        public final Builder cidrBlockState(VpcCidrBlockState cidrBlockState) {
            this.cidrBlockState = cidrBlockState;
            return this;
        }

        public final void setCidrBlockState(VpcCidrBlockState.BuilderImpl cidrBlockState) {
            this.cidrBlockState = cidrBlockState != null ? cidrBlockState.build() : null;
        }

        @Override
        public VpcCidrBlockAssociation build() {
            return new VpcCidrBlockAssociation(this);
        }
    }
}
