/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes VPN connection options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VpnConnectionOptionsSpecification implements
        ToCopyableBuilder<VpnConnectionOptionsSpecification.Builder, VpnConnectionOptionsSpecification> {
    private final Boolean staticRoutesOnly;

    private final List<VpnTunnelOptionsSpecification> tunnelOptions;

    private VpnConnectionOptionsSpecification(BuilderImpl builder) {
        this.staticRoutesOnly = builder.staticRoutesOnly;
        this.tunnelOptions = builder.tunnelOptions;
    }

    /**
     * <p>
     * Indicate whether the VPN connection uses static routes only. If you are creating a VPN connection for a device
     * that does not support BGP, you must specify <code>true</code>.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return Indicate whether the VPN connection uses static routes only. If you are creating a VPN connection for a
     *         device that does not support BGP, you must specify <code>true</code>.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public Boolean staticRoutesOnly() {
        return staticRoutesOnly;
    }

    /**
     * <p>
     * The tunnel options for the VPN connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The tunnel options for the VPN connection.
     */
    public List<VpnTunnelOptionsSpecification> tunnelOptions() {
        return tunnelOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(staticRoutesOnly());
        hashCode = 31 * hashCode + Objects.hashCode(tunnelOptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpnConnectionOptionsSpecification)) {
            return false;
        }
        VpnConnectionOptionsSpecification other = (VpnConnectionOptionsSpecification) obj;
        return Objects.equals(staticRoutesOnly(), other.staticRoutesOnly())
                && Objects.equals(tunnelOptions(), other.tunnelOptions());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (staticRoutesOnly() != null) {
            sb.append("StaticRoutesOnly: ").append(staticRoutesOnly()).append(",");
        }
        if (tunnelOptions() != null) {
            sb.append("TunnelOptions: ").append(tunnelOptions()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StaticRoutesOnly":
            return Optional.of(clazz.cast(staticRoutesOnly()));
        case "TunnelOptions":
            return Optional.of(clazz.cast(tunnelOptions()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, VpnConnectionOptionsSpecification> {
        /**
         * <p>
         * Indicate whether the VPN connection uses static routes only. If you are creating a VPN connection for a
         * device that does not support BGP, you must specify <code>true</code>.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param staticRoutesOnly
         *        Indicate whether the VPN connection uses static routes only. If you are creating a VPN connection for
         *        a device that does not support BGP, you must specify <code>true</code>.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticRoutesOnly(Boolean staticRoutesOnly);

        /**
         * <p>
         * The tunnel options for the VPN connection.
         * </p>
         * 
         * @param tunnelOptions
         *        The tunnel options for the VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunnelOptions(Collection<VpnTunnelOptionsSpecification> tunnelOptions);

        /**
         * <p>
         * The tunnel options for the VPN connection.
         * </p>
         * 
         * @param tunnelOptions
         *        The tunnel options for the VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunnelOptions(VpnTunnelOptionsSpecification... tunnelOptions);
    }

    static final class BuilderImpl implements Builder {
        private Boolean staticRoutesOnly;

        private List<VpnTunnelOptionsSpecification> tunnelOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(VpnConnectionOptionsSpecification model) {
            staticRoutesOnly(model.staticRoutesOnly);
            tunnelOptions(model.tunnelOptions);
        }

        public final Boolean getStaticRoutesOnly() {
            return staticRoutesOnly;
        }

        @Override
        public final Builder staticRoutesOnly(Boolean staticRoutesOnly) {
            this.staticRoutesOnly = staticRoutesOnly;
            return this;
        }

        public final void setStaticRoutesOnly(Boolean staticRoutesOnly) {
            this.staticRoutesOnly = staticRoutesOnly;
        }

        public final Collection<VpnTunnelOptionsSpecification.Builder> getTunnelOptions() {
            return tunnelOptions != null ? tunnelOptions.stream().map(VpnTunnelOptionsSpecification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tunnelOptions(Collection<VpnTunnelOptionsSpecification> tunnelOptions) {
            this.tunnelOptions = TunnelOptionsListCopier.copy(tunnelOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tunnelOptions(VpnTunnelOptionsSpecification... tunnelOptions) {
            tunnelOptions(Arrays.asList(tunnelOptions));
            return this;
        }

        public final void setTunnelOptions(Collection<VpnTunnelOptionsSpecification.BuilderImpl> tunnelOptions) {
            this.tunnelOptions = TunnelOptionsListCopier.copyFromBuilder(tunnelOptions);
        }

        @Override
        public VpnConnectionOptionsSpecification build() {
            return new VpnConnectionOptionsSpecification(this);
        }
    }
}
