/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * CreateVpnConnectionRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateVpnConnectionRequestMarshaller implements
        Marshaller<Request<CreateVpnConnectionRequest>, CreateVpnConnectionRequest> {

    public Request<CreateVpnConnectionRequest> marshall(CreateVpnConnectionRequest createVpnConnectionRequest) {

        if (createVpnConnectionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<CreateVpnConnectionRequest> request = new DefaultRequest<CreateVpnConnectionRequest>(createVpnConnectionRequest,
                "EC2Client");
        request.addParameter("Action", "CreateVpnConnection");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (createVpnConnectionRequest.customerGatewayId() != null) {
            request.addParameter("CustomerGatewayId", StringUtils.fromString(createVpnConnectionRequest.customerGatewayId()));
        }

        if (createVpnConnectionRequest.type() != null) {
            request.addParameter("Type", StringUtils.fromString(createVpnConnectionRequest.type()));
        }

        if (createVpnConnectionRequest.vpnGatewayId() != null) {
            request.addParameter("VpnGatewayId", StringUtils.fromString(createVpnConnectionRequest.vpnGatewayId()));
        }

        VpnConnectionOptionsSpecification options = createVpnConnectionRequest.options();
        if (options != null) {

            if (options.staticRoutesOnly() != null) {
                request.addParameter("Options.StaticRoutesOnly", StringUtils.fromBoolean(options.staticRoutesOnly()));
            }

            java.util.List<VpnTunnelOptionsSpecification> vpnConnectionOptionsSpecificationTunnelOptionsList = options
                    .tunnelOptions();
            if (vpnConnectionOptionsSpecificationTunnelOptionsList != null) {
                int tunnelOptionsListIndex = 1;

                for (VpnTunnelOptionsSpecification vpnConnectionOptionsSpecificationTunnelOptionsListValue : vpnConnectionOptionsSpecificationTunnelOptionsList) {

                    if (vpnConnectionOptionsSpecificationTunnelOptionsListValue.tunnelInsideCidr() != null) {
                        request.addParameter("Options.TunnelOptions." + tunnelOptionsListIndex + ".TunnelInsideCidr", StringUtils
                                .fromString(vpnConnectionOptionsSpecificationTunnelOptionsListValue.tunnelInsideCidr()));
                    }

                    if (vpnConnectionOptionsSpecificationTunnelOptionsListValue.preSharedKey() != null) {
                        request.addParameter("Options.TunnelOptions." + tunnelOptionsListIndex + ".PreSharedKey",
                                StringUtils.fromString(vpnConnectionOptionsSpecificationTunnelOptionsListValue.preSharedKey()));
                    }
                    tunnelOptionsListIndex++;
                }
            }
        }

        return request;
    }

}
