/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * DescribeNatGatewaysRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeNatGatewaysRequestMarshaller implements
        Marshaller<Request<DescribeNatGatewaysRequest>, DescribeNatGatewaysRequest> {

    public Request<DescribeNatGatewaysRequest> marshall(DescribeNatGatewaysRequest describeNatGatewaysRequest) {

        if (describeNatGatewaysRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeNatGatewaysRequest> request = new DefaultRequest<DescribeNatGatewaysRequest>(describeNatGatewaysRequest,
                "EC2Client");
        request.addParameter("Action", "DescribeNatGateways");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<Filter> describeNatGatewaysRequestFilterList = describeNatGatewaysRequest.filter();
        if (describeNatGatewaysRequestFilterList != null) {
            int filterListIndex = 1;

            for (Filter describeNatGatewaysRequestFilterListValue : describeNatGatewaysRequestFilterList) {

                if (describeNatGatewaysRequestFilterListValue.name() != null) {
                    request.addParameter("Filter." + filterListIndex + ".Name",
                            StringUtils.fromString(describeNatGatewaysRequestFilterListValue.name()));
                }

                java.util.List<String> filterValuesList = describeNatGatewaysRequestFilterListValue.values();
                if (filterValuesList != null) {
                    int valuesListIndex = 1;

                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filterListIndex + ".Value." + valuesListIndex,
                                    StringUtils.fromString(filterValuesListValue));
                        }
                        valuesListIndex++;
                    }
                }
                filterListIndex++;
            }
        }

        if (describeNatGatewaysRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeNatGatewaysRequest.maxResults()));
        }

        java.util.List<String> describeNatGatewaysRequestNatGatewayIdsList = describeNatGatewaysRequest.natGatewayIds();
        if (describeNatGatewaysRequestNatGatewayIdsList != null) {
            int natGatewayIdsListIndex = 1;

            for (String describeNatGatewaysRequestNatGatewayIdsListValue : describeNatGatewaysRequestNatGatewayIdsList) {
                if (describeNatGatewaysRequestNatGatewayIdsListValue != null) {
                    request.addParameter("NatGatewayId." + natGatewayIdsListIndex,
                            StringUtils.fromString(describeNatGatewaysRequestNatGatewayIdsListValue));
                }
                natGatewayIdsListIndex++;
            }
        }

        if (describeNatGatewaysRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeNatGatewaysRequest.nextToken()));
        }

        return request;
    }

}
