/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * DescribePrefixListsResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribePrefixListsResponseUnmarshaller implements
        Unmarshaller<DescribePrefixListsResponse, StaxUnmarshallerContext> {

    public DescribePrefixListsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DescribePrefixListsResponse.Builder describePrefixListsResponse = DescribePrefixListsResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<PrefixList> prefixLists = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                describePrefixListsResponse.prefixLists(prefixLists);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("nextToken", targetDepth)) {
                    describePrefixListsResponse.nextToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("prefixListSet", targetDepth)) {
                    prefixLists = new ArrayList<PrefixList>();
                    continue;
                }

                if (context.testExpression("prefixListSet/item", targetDepth)) {
                    prefixLists.add(PrefixListUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    describePrefixListsResponse.prefixLists(prefixLists);
                    break;
                }
            }
        }
        return describePrefixListsResponse.build();
    }

    private static final DescribePrefixListsResponseUnmarshaller INSTANCE = new DescribePrefixListsResponseUnmarshaller();

    public static DescribePrefixListsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
