/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * DescribeVolumesModificationsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeVolumesModificationsRequestMarshaller implements
        Marshaller<Request<DescribeVolumesModificationsRequest>, DescribeVolumesModificationsRequest> {

    public Request<DescribeVolumesModificationsRequest> marshall(
            DescribeVolumesModificationsRequest describeVolumesModificationsRequest) {

        if (describeVolumesModificationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeVolumesModificationsRequest> request = new DefaultRequest<DescribeVolumesModificationsRequest>(
                describeVolumesModificationsRequest, "EC2Client");
        request.addParameter("Action", "DescribeVolumesModifications");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<String> describeVolumesModificationsRequestVolumeIdsList = describeVolumesModificationsRequest.volumeIds();
        if (describeVolumesModificationsRequestVolumeIdsList != null) {
            int volumeIdsListIndex = 1;

            for (String describeVolumesModificationsRequestVolumeIdsListValue : describeVolumesModificationsRequestVolumeIdsList) {
                if (describeVolumesModificationsRequestVolumeIdsListValue != null) {
                    request.addParameter("VolumeId." + volumeIdsListIndex,
                            StringUtils.fromString(describeVolumesModificationsRequestVolumeIdsListValue));
                }
                volumeIdsListIndex++;
            }
        }

        java.util.List<Filter> describeVolumesModificationsRequestFiltersList = describeVolumesModificationsRequest.filters();
        if (describeVolumesModificationsRequestFiltersList != null) {
            int filtersListIndex = 1;

            for (Filter describeVolumesModificationsRequestFiltersListValue : describeVolumesModificationsRequestFiltersList) {

                if (describeVolumesModificationsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name",
                            StringUtils.fromString(describeVolumesModificationsRequestFiltersListValue.name()));
                }

                java.util.List<String> filterValuesList = describeVolumesModificationsRequestFiltersListValue.values();
                if (filterValuesList != null) {
                    int valuesListIndex = 1;

                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex,
                                    StringUtils.fromString(filterValuesListValue));
                        }
                        valuesListIndex++;
                    }
                }
                filtersListIndex++;
            }
        }

        if (describeVolumesModificationsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeVolumesModificationsRequest.nextToken()));
        }

        if (describeVolumesModificationsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeVolumesModificationsRequest.maxResults()));
        }

        return request;
    }

}
