/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * HostReservation StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class HostReservationUnmarshaller implements Unmarshaller<HostReservation, StaxUnmarshallerContext> {

    public HostReservation unmarshall(StaxUnmarshallerContext context) throws Exception {
        HostReservation.Builder hostReservation = HostReservation.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<String> hostIdSet = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                hostReservation.hostIdSet(hostIdSet);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("count", targetDepth)) {
                    hostReservation.count(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("currencyCode", targetDepth)) {
                    hostReservation.currencyCode(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("duration", targetDepth)) {
                    hostReservation.duration(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("end", targetDepth)) {
                    hostReservation.end(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("hostIdSet", targetDepth)) {
                    hostIdSet = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("hostIdSet/item", targetDepth)) {
                    hostIdSet.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("hostReservationId", targetDepth)) {
                    hostReservation.hostReservationId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("hourlyPrice", targetDepth)) {
                    hostReservation.hourlyPrice(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("instanceFamily", targetDepth)) {
                    hostReservation.instanceFamily(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("offeringId", targetDepth)) {
                    hostReservation.offeringId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("paymentOption", targetDepth)) {
                    hostReservation.paymentOption(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("start", targetDepth)) {
                    hostReservation.start(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("state", targetDepth)) {
                    hostReservation.state(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("upfrontPrice", targetDepth)) {
                    hostReservation.upfrontPrice(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    hostReservation.hostIdSet(hostIdSet);
                    break;
                }
            }
        }
        return hostReservation.build();
    }

    private static final HostReservationUnmarshaller INSTANCE = new HostReservationUnmarshaller();

    public static HostReservationUnmarshaller getInstance() {
        return INSTANCE;
    }
}
