/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * ModifyVpcEndpointRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ModifyVpcEndpointRequestMarshaller implements
        Marshaller<Request<ModifyVpcEndpointRequest>, ModifyVpcEndpointRequest> {

    public Request<ModifyVpcEndpointRequest> marshall(ModifyVpcEndpointRequest modifyVpcEndpointRequest) {

        if (modifyVpcEndpointRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ModifyVpcEndpointRequest> request = new DefaultRequest<ModifyVpcEndpointRequest>(modifyVpcEndpointRequest,
                "EC2Client");
        request.addParameter("Action", "ModifyVpcEndpoint");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (modifyVpcEndpointRequest.vpcEndpointId() != null) {
            request.addParameter("VpcEndpointId", StringUtils.fromString(modifyVpcEndpointRequest.vpcEndpointId()));
        }

        if (modifyVpcEndpointRequest.resetPolicy() != null) {
            request.addParameter("ResetPolicy", StringUtils.fromBoolean(modifyVpcEndpointRequest.resetPolicy()));
        }

        if (modifyVpcEndpointRequest.policyDocument() != null) {
            request.addParameter("PolicyDocument", StringUtils.fromString(modifyVpcEndpointRequest.policyDocument()));
        }

        java.util.List<String> modifyVpcEndpointRequestAddRouteTableIdsList = modifyVpcEndpointRequest.addRouteTableIds();
        if (modifyVpcEndpointRequestAddRouteTableIdsList != null) {
            int addRouteTableIdsListIndex = 1;

            for (String modifyVpcEndpointRequestAddRouteTableIdsListValue : modifyVpcEndpointRequestAddRouteTableIdsList) {
                if (modifyVpcEndpointRequestAddRouteTableIdsListValue != null) {
                    request.addParameter("AddRouteTableId." + addRouteTableIdsListIndex,
                            StringUtils.fromString(modifyVpcEndpointRequestAddRouteTableIdsListValue));
                }
                addRouteTableIdsListIndex++;
            }
        }

        java.util.List<String> modifyVpcEndpointRequestRemoveRouteTableIdsList = modifyVpcEndpointRequest.removeRouteTableIds();
        if (modifyVpcEndpointRequestRemoveRouteTableIdsList != null) {
            int removeRouteTableIdsListIndex = 1;

            for (String modifyVpcEndpointRequestRemoveRouteTableIdsListValue : modifyVpcEndpointRequestRemoveRouteTableIdsList) {
                if (modifyVpcEndpointRequestRemoveRouteTableIdsListValue != null) {
                    request.addParameter("RemoveRouteTableId." + removeRouteTableIdsListIndex,
                            StringUtils.fromString(modifyVpcEndpointRequestRemoveRouteTableIdsListValue));
                }
                removeRouteTableIdsListIndex++;
            }
        }

        java.util.List<String> modifyVpcEndpointRequestAddSubnetIdsList = modifyVpcEndpointRequest.addSubnetIds();
        if (modifyVpcEndpointRequestAddSubnetIdsList != null) {
            int addSubnetIdsListIndex = 1;

            for (String modifyVpcEndpointRequestAddSubnetIdsListValue : modifyVpcEndpointRequestAddSubnetIdsList) {
                if (modifyVpcEndpointRequestAddSubnetIdsListValue != null) {
                    request.addParameter("AddSubnetId." + addSubnetIdsListIndex,
                            StringUtils.fromString(modifyVpcEndpointRequestAddSubnetIdsListValue));
                }
                addSubnetIdsListIndex++;
            }
        }

        java.util.List<String> modifyVpcEndpointRequestRemoveSubnetIdsList = modifyVpcEndpointRequest.removeSubnetIds();
        if (modifyVpcEndpointRequestRemoveSubnetIdsList != null) {
            int removeSubnetIdsListIndex = 1;

            for (String modifyVpcEndpointRequestRemoveSubnetIdsListValue : modifyVpcEndpointRequestRemoveSubnetIdsList) {
                if (modifyVpcEndpointRequestRemoveSubnetIdsListValue != null) {
                    request.addParameter("RemoveSubnetId." + removeSubnetIdsListIndex,
                            StringUtils.fromString(modifyVpcEndpointRequestRemoveSubnetIdsListValue));
                }
                removeSubnetIdsListIndex++;
            }
        }

        java.util.List<String> modifyVpcEndpointRequestAddSecurityGroupIdsList = modifyVpcEndpointRequest.addSecurityGroupIds();
        if (modifyVpcEndpointRequestAddSecurityGroupIdsList != null) {
            int addSecurityGroupIdsListIndex = 1;

            for (String modifyVpcEndpointRequestAddSecurityGroupIdsListValue : modifyVpcEndpointRequestAddSecurityGroupIdsList) {
                if (modifyVpcEndpointRequestAddSecurityGroupIdsListValue != null) {
                    request.addParameter("AddSecurityGroupId." + addSecurityGroupIdsListIndex,
                            StringUtils.fromString(modifyVpcEndpointRequestAddSecurityGroupIdsListValue));
                }
                addSecurityGroupIdsListIndex++;
            }
        }

        java.util.List<String> modifyVpcEndpointRequestRemoveSecurityGroupIdsList = modifyVpcEndpointRequest
                .removeSecurityGroupIds();
        if (modifyVpcEndpointRequestRemoveSecurityGroupIdsList != null) {
            int removeSecurityGroupIdsListIndex = 1;

            for (String modifyVpcEndpointRequestRemoveSecurityGroupIdsListValue : modifyVpcEndpointRequestRemoveSecurityGroupIdsList) {
                if (modifyVpcEndpointRequestRemoveSecurityGroupIdsListValue != null) {
                    request.addParameter("RemoveSecurityGroupId." + removeSecurityGroupIdsListIndex,
                            StringUtils.fromString(modifyVpcEndpointRequestRemoveSecurityGroupIdsListValue));
                }
                removeSecurityGroupIdsListIndex++;
            }
        }

        if (modifyVpcEndpointRequest.privateDnsEnabled() != null) {
            request.addParameter("PrivateDnsEnabled", StringUtils.fromBoolean(modifyVpcEndpointRequest.privateDnsEnabled()));
        }

        return request;
    }

}
