/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * RequestSpotInstancesRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class RequestSpotInstancesRequestMarshaller implements
        Marshaller<Request<RequestSpotInstancesRequest>, RequestSpotInstancesRequest> {

    public Request<RequestSpotInstancesRequest> marshall(RequestSpotInstancesRequest requestSpotInstancesRequest) {

        if (requestSpotInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<RequestSpotInstancesRequest> request = new DefaultRequest<RequestSpotInstancesRequest>(
                requestSpotInstancesRequest, "EC2Client");
        request.addParameter("Action", "RequestSpotInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (requestSpotInstancesRequest.availabilityZoneGroup() != null) {
            request.addParameter("AvailabilityZoneGroup",
                    StringUtils.fromString(requestSpotInstancesRequest.availabilityZoneGroup()));
        }

        if (requestSpotInstancesRequest.blockDurationMinutes() != null) {
            request.addParameter("BlockDurationMinutes",
                    StringUtils.fromInteger(requestSpotInstancesRequest.blockDurationMinutes()));
        }

        if (requestSpotInstancesRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString(requestSpotInstancesRequest.clientToken()));
        }

        if (requestSpotInstancesRequest.instanceCount() != null) {
            request.addParameter("InstanceCount", StringUtils.fromInteger(requestSpotInstancesRequest.instanceCount()));
        }

        if (requestSpotInstancesRequest.launchGroup() != null) {
            request.addParameter("LaunchGroup", StringUtils.fromString(requestSpotInstancesRequest.launchGroup()));
        }

        LaunchSpecification launchSpecification = requestSpotInstancesRequest.launchSpecification();
        if (launchSpecification != null) {

            if (launchSpecification.userData() != null) {
                request.addParameter("LaunchSpecification.UserData", StringUtils.fromString(launchSpecification.userData()));
            }

            if (launchSpecification.addressingType() != null) {
                request.addParameter("LaunchSpecification.AddressingType",
                        StringUtils.fromString(launchSpecification.addressingType()));
            }

            java.util.List<BlockDeviceMapping> launchSpecificationBlockDeviceMappingsList = launchSpecification
                    .blockDeviceMappings();
            if (launchSpecificationBlockDeviceMappingsList != null) {
                int blockDeviceMappingsListIndex = 1;

                for (BlockDeviceMapping launchSpecificationBlockDeviceMappingsListValue : launchSpecificationBlockDeviceMappingsList) {

                    if (launchSpecificationBlockDeviceMappingsListValue.deviceName() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex
                                + ".DeviceName",
                                StringUtils.fromString(launchSpecificationBlockDeviceMappingsListValue.deviceName()));
                    }

                    if (launchSpecificationBlockDeviceMappingsListValue.virtualName() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex
                                + ".VirtualName",
                                StringUtils.fromString(launchSpecificationBlockDeviceMappingsListValue.virtualName()));
                    }

                    EbsBlockDevice ebs = launchSpecificationBlockDeviceMappingsListValue.ebs();
                    if (ebs != null) {

                        if (ebs.encrypted() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex
                                    + ".Ebs.Encrypted", StringUtils.fromBoolean(ebs.encrypted()));
                        }

                        if (ebs.deleteOnTermination() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex
                                    + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean(ebs.deleteOnTermination()));
                        }

                        if (ebs.iops() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex
                                    + ".Ebs.Iops", StringUtils.fromInteger(ebs.iops()));
                        }

                        if (ebs.snapshotId() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex
                                    + ".Ebs.SnapshotId", StringUtils.fromString(ebs.snapshotId()));
                        }

                        if (ebs.volumeSize() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex
                                    + ".Ebs.VolumeSize", StringUtils.fromInteger(ebs.volumeSize()));
                        }

                        if (ebs.volumeTypeString() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex
                                    + ".Ebs.VolumeType", StringUtils.fromString(ebs.volumeTypeString()));
                        }
                    }

                    if (launchSpecificationBlockDeviceMappingsListValue.noDevice() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex
                                + ".NoDevice", StringUtils.fromString(launchSpecificationBlockDeviceMappingsListValue.noDevice()));
                    }
                    blockDeviceMappingsListIndex++;
                }
            }

            if (launchSpecification.ebsOptimized() != null) {
                request.addParameter("LaunchSpecification.EbsOptimized",
                        StringUtils.fromBoolean(launchSpecification.ebsOptimized()));
            }

            IamInstanceProfileSpecification iamInstanceProfile = launchSpecification.iamInstanceProfile();
            if (iamInstanceProfile != null) {

                if (iamInstanceProfile.arn() != null) {
                    request.addParameter("LaunchSpecification.IamInstanceProfile.Arn",
                            StringUtils.fromString(iamInstanceProfile.arn()));
                }

                if (iamInstanceProfile.name() != null) {
                    request.addParameter("LaunchSpecification.IamInstanceProfile.Name",
                            StringUtils.fromString(iamInstanceProfile.name()));
                }
            }

            if (launchSpecification.imageId() != null) {
                request.addParameter("LaunchSpecification.ImageId", StringUtils.fromString(launchSpecification.imageId()));
            }

            if (launchSpecification.instanceTypeString() != null) {
                request.addParameter("LaunchSpecification.InstanceType",
                        StringUtils.fromString(launchSpecification.instanceTypeString()));
            }

            if (launchSpecification.kernelId() != null) {
                request.addParameter("LaunchSpecification.KernelId", StringUtils.fromString(launchSpecification.kernelId()));
            }

            if (launchSpecification.keyName() != null) {
                request.addParameter("LaunchSpecification.KeyName", StringUtils.fromString(launchSpecification.keyName()));
            }

            java.util.List<InstanceNetworkInterfaceSpecification> launchSpecificationNetworkInterfacesList = launchSpecification
                    .networkInterfaces();
            if (launchSpecificationNetworkInterfacesList != null) {
                int networkInterfacesListIndex = 1;

                for (InstanceNetworkInterfaceSpecification launchSpecificationNetworkInterfacesListValue : launchSpecificationNetworkInterfacesList) {

                    if (launchSpecificationNetworkInterfacesListValue.associatePublicIpAddress() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex
                                + ".AssociatePublicIpAddress",
                                StringUtils.fromBoolean(launchSpecificationNetworkInterfacesListValue.associatePublicIpAddress()));
                    }

                    if (launchSpecificationNetworkInterfacesListValue.deleteOnTermination() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex
                                + ".DeleteOnTermination",
                                StringUtils.fromBoolean(launchSpecificationNetworkInterfacesListValue.deleteOnTermination()));
                    }

                    if (launchSpecificationNetworkInterfacesListValue.description() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex
                                + ".Description",
                                StringUtils.fromString(launchSpecificationNetworkInterfacesListValue.description()));
                    }

                    if (launchSpecificationNetworkInterfacesListValue.deviceIndex() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex
                                + ".DeviceIndex",
                                StringUtils.fromInteger(launchSpecificationNetworkInterfacesListValue.deviceIndex()));
                    }

                    java.util.List<String> instanceNetworkInterfaceSpecificationGroupsList = launchSpecificationNetworkInterfacesListValue
                            .groups();
                    if (instanceNetworkInterfaceSpecificationGroupsList != null) {
                        int groupsListIndex = 1;

                        for (String instanceNetworkInterfaceSpecificationGroupsListValue : instanceNetworkInterfaceSpecificationGroupsList) {
                            if (instanceNetworkInterfaceSpecificationGroupsListValue != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex
                                        + ".SecurityGroupId." + groupsListIndex,
                                        StringUtils.fromString(instanceNetworkInterfaceSpecificationGroupsListValue));
                            }
                            groupsListIndex++;
                        }
                    }

                    if (launchSpecificationNetworkInterfacesListValue.ipv6AddressCount() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex
                                + ".Ipv6AddressCount",
                                StringUtils.fromInteger(launchSpecificationNetworkInterfacesListValue.ipv6AddressCount()));
                    }

                    java.util.List<InstanceIpv6Address> instanceNetworkInterfaceSpecificationIpv6AddressesList = launchSpecificationNetworkInterfacesListValue
                            .ipv6Addresses();
                    if (instanceNetworkInterfaceSpecificationIpv6AddressesList != null) {
                        int ipv6AddressesListIndex = 1;

                        for (InstanceIpv6Address instanceNetworkInterfaceSpecificationIpv6AddressesListValue : instanceNetworkInterfaceSpecificationIpv6AddressesList) {

                            if (instanceNetworkInterfaceSpecificationIpv6AddressesListValue.ipv6Address() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex
                                        + ".Ipv6Addresses." + ipv6AddressesListIndex + ".Ipv6Address", StringUtils
                                        .fromString(instanceNetworkInterfaceSpecificationIpv6AddressesListValue.ipv6Address()));
                            }
                            ipv6AddressesListIndex++;
                        }
                    }

                    if (launchSpecificationNetworkInterfacesListValue.networkInterfaceId() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex
                                + ".NetworkInterfaceId",
                                StringUtils.fromString(launchSpecificationNetworkInterfacesListValue.networkInterfaceId()));
                    }

                    if (launchSpecificationNetworkInterfacesListValue.privateIpAddress() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex
                                + ".PrivateIpAddress",
                                StringUtils.fromString(launchSpecificationNetworkInterfacesListValue.privateIpAddress()));
                    }

                    java.util.List<PrivateIpAddressSpecification> instanceNetworkInterfaceSpecificationPrivateIpAddressesList = launchSpecificationNetworkInterfacesListValue
                            .privateIpAddresses();
                    if (instanceNetworkInterfaceSpecificationPrivateIpAddressesList != null) {
                        int privateIpAddressesListIndex = 1;

                        for (PrivateIpAddressSpecification instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue : instanceNetworkInterfaceSpecificationPrivateIpAddressesList) {

                            if (instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.primary() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex
                                        + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".Primary", StringUtils
                                        .fromBoolean(instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.primary()));
                            }

                            if (instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.privateIpAddress() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex
                                        + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".PrivateIpAddress", StringUtils
                                        .fromString(instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue
                                                .privateIpAddress()));
                            }
                            privateIpAddressesListIndex++;
                        }
                    }

                    if (launchSpecificationNetworkInterfacesListValue.secondaryPrivateIpAddressCount() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex
                                + ".SecondaryPrivateIpAddressCount", StringUtils
                                .fromInteger(launchSpecificationNetworkInterfacesListValue.secondaryPrivateIpAddressCount()));
                    }

                    if (launchSpecificationNetworkInterfacesListValue.subnetId() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".SubnetId",
                                StringUtils.fromString(launchSpecificationNetworkInterfacesListValue.subnetId()));
                    }
                    networkInterfacesListIndex++;
                }
            }

            SpotPlacement placement = launchSpecification.placement();
            if (placement != null) {

                if (placement.availabilityZone() != null) {
                    request.addParameter("LaunchSpecification.Placement.AvailabilityZone",
                            StringUtils.fromString(placement.availabilityZone()));
                }

                if (placement.groupName() != null) {
                    request.addParameter("LaunchSpecification.Placement.GroupName", StringUtils.fromString(placement.groupName()));
                }

                if (placement.tenancyString() != null) {
                    request.addParameter("LaunchSpecification.Placement.Tenancy",
                            StringUtils.fromString(placement.tenancyString()));
                }
            }

            if (launchSpecification.ramdiskId() != null) {
                request.addParameter("LaunchSpecification.RamdiskId", StringUtils.fromString(launchSpecification.ramdiskId()));
            }

            if (launchSpecification.subnetId() != null) {
                request.addParameter("LaunchSpecification.SubnetId", StringUtils.fromString(launchSpecification.subnetId()));
            }

            java.util.List<GroupIdentifier> launchSpecificationAllSecurityGroupsList = launchSpecification.allSecurityGroups();
            if (launchSpecificationAllSecurityGroupsList != null) {
                int allSecurityGroupsListIndex = 1;

                for (GroupIdentifier launchSpecificationAllSecurityGroupsListValue : launchSpecificationAllSecurityGroupsList) {

                    if (launchSpecificationAllSecurityGroupsListValue.groupName() != null) {
                        request.addParameter("LaunchSpecification.GroupSet." + allSecurityGroupsListIndex + ".GroupName",
                                StringUtils.fromString(launchSpecificationAllSecurityGroupsListValue.groupName()));
                    }

                    if (launchSpecificationAllSecurityGroupsListValue.groupId() != null) {
                        request.addParameter("LaunchSpecification.GroupSet." + allSecurityGroupsListIndex + ".GroupId",
                                StringUtils.fromString(launchSpecificationAllSecurityGroupsListValue.groupId()));
                    }
                    allSecurityGroupsListIndex++;
                }
            }

            if (launchSpecification.monitoringEnabled() != null) {
                request.addParameter("LaunchSpecification.Monitoring.Enabled",
                        StringUtils.fromBoolean(launchSpecification.monitoringEnabled()));
            }

            java.util.List<String> launchSpecificationSecurityGroupsList = launchSpecification.securityGroups();
            if (launchSpecificationSecurityGroupsList != null) {
                int securityGroupsListIndex = 1;

                for (String launchSpecificationSecurityGroupsListValue : launchSpecificationSecurityGroupsList) {
                    if (launchSpecificationSecurityGroupsListValue != null) {
                        request.addParameter("LaunchSpecification.SecurityGroup." + securityGroupsListIndex,
                                StringUtils.fromString(launchSpecificationSecurityGroupsListValue));
                    }
                    securityGroupsListIndex++;
                }
            }
        }

        if (requestSpotInstancesRequest.spotPrice() != null) {
            request.addParameter("SpotPrice", StringUtils.fromString(requestSpotInstancesRequest.spotPrice()));
        }

        if (requestSpotInstancesRequest.typeString() != null) {
            request.addParameter("Type", StringUtils.fromString(requestSpotInstancesRequest.typeString()));
        }

        if (requestSpotInstancesRequest.validFrom() != null) {
            request.addParameter("ValidFrom", StringUtils.fromInstant(requestSpotInstancesRequest.validFrom()));
        }

        if (requestSpotInstancesRequest.validUntil() != null) {
            request.addParameter("ValidUntil", StringUtils.fromInstant(requestSpotInstancesRequest.validUntil()));
        }

        if (requestSpotInstancesRequest.instanceInterruptionBehaviorString() != null) {
            request.addParameter("InstanceInterruptionBehavior",
                    StringUtils.fromString(requestSpotInstancesRequest.instanceInterruptionBehaviorString()));
        }

        return request;
    }

}
