/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ScheduledInstanceAvailability StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ScheduledInstanceAvailabilityUnmarshaller implements
        Unmarshaller<ScheduledInstanceAvailability, StaxUnmarshallerContext> {

    public ScheduledInstanceAvailability unmarshall(StaxUnmarshallerContext context) throws Exception {
        ScheduledInstanceAvailability.Builder scheduledInstanceAvailability = ScheduledInstanceAvailability.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("availabilityZone", targetDepth)) {
                    scheduledInstanceAvailability.availabilityZone(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("availableInstanceCount", targetDepth)) {
                    scheduledInstanceAvailability.availableInstanceCount(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("firstSlotStartTime", targetDepth)) {
                    scheduledInstanceAvailability.firstSlotStartTime(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("hourlyPrice", targetDepth)) {
                    scheduledInstanceAvailability.hourlyPrice(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("instanceType", targetDepth)) {
                    scheduledInstanceAvailability.instanceType(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("maxTermDurationInDays", targetDepth)) {
                    scheduledInstanceAvailability.maxTermDurationInDays(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("minTermDurationInDays", targetDepth)) {
                    scheduledInstanceAvailability.minTermDurationInDays(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("networkPlatform", targetDepth)) {
                    scheduledInstanceAvailability.networkPlatform(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("platform", targetDepth)) {
                    scheduledInstanceAvailability.platform(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("purchaseToken", targetDepth)) {
                    scheduledInstanceAvailability.purchaseToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("recurrence", targetDepth)) {
                    scheduledInstanceAvailability.recurrence(ScheduledInstanceRecurrenceUnmarshaller.getInstance().unmarshall(
                            context));
                    continue;
                }

                if (context.testExpression("slotDurationInHours", targetDepth)) {
                    scheduledInstanceAvailability.slotDurationInHours(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("totalScheduledInstanceHours", targetDepth)) {
                    scheduledInstanceAvailability.totalScheduledInstanceHours(IntegerUnmarshaller.getInstance().unmarshall(
                            context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    break;
                }
            }
        }
        return scheduledInstanceAvailability.build();
    }

    private static final ScheduledInstanceAvailabilityUnmarshaller INSTANCE = new ScheduledInstanceAvailabilityUnmarshaller();

    public static ScheduledInstanceAvailabilityUnmarshaller getInstance() {
        return INSTANCE;
    }
}
