/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.PlacementStrategy;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreatePlacementGroupRequest
extends EC2Request
implements ToCopyableBuilder<Builder, CreatePlacementGroupRequest> {
    private final String groupName;
    private final String strategy;

    private CreatePlacementGroupRequest(BuilderImpl builder) {
        super(builder);
        this.groupName = builder.groupName;
        this.strategy = builder.strategy;
    }

    public String groupName() {
        return this.groupName;
    }

    public PlacementStrategy strategy() {
        return PlacementStrategy.fromValue(this.strategy);
    }

    public String strategyString() {
        return this.strategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.strategyString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlacementGroupRequest)) {
            return false;
        }
        CreatePlacementGroupRequest other = (CreatePlacementGroupRequest)((Object)obj);
        return Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.strategyString(), other.strategyString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.groupName() != null) {
            sb.append("GroupName: ").append(this.groupName()).append(",");
        }
        if (this.strategyString() != null) {
            sb.append("Strategy: ").append(this.strategyString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupName": {
                return Optional.of(clazz.cast(this.groupName()));
            }
            case "Strategy": {
                return Optional.of(clazz.cast(this.strategyString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String groupName;
        private String strategy;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlacementGroupRequest model) {
            this.groupName(model.groupName);
            this.strategy(model.strategy);
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getStrategy() {
            return this.strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public final Builder strategy(PlacementStrategy strategy) {
            this.strategy(strategy.toString());
            return this;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreatePlacementGroupRequest build() {
            return new CreatePlacementGroupRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, CreatePlacementGroupRequest> {
        public Builder groupName(String var1);

        public Builder strategy(String var1);

        public Builder strategy(PlacementStrategy var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

