/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.FpgaImageAttributeName;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeFpgaImageAttributeRequest
extends EC2Request
implements ToCopyableBuilder<Builder, DescribeFpgaImageAttributeRequest> {
    private final String fpgaImageId;
    private final String attribute;

    private DescribeFpgaImageAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.fpgaImageId = builder.fpgaImageId;
        this.attribute = builder.attribute;
    }

    public String fpgaImageId() {
        return this.fpgaImageId;
    }

    public FpgaImageAttributeName attribute() {
        return FpgaImageAttributeName.fromValue(this.attribute);
    }

    public String attributeString() {
        return this.attribute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fpgaImageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFpgaImageAttributeRequest)) {
            return false;
        }
        DescribeFpgaImageAttributeRequest other = (DescribeFpgaImageAttributeRequest)((Object)obj);
        return Objects.equals(this.fpgaImageId(), other.fpgaImageId()) && Objects.equals(this.attributeString(), other.attributeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.fpgaImageId() != null) {
            sb.append("FpgaImageId: ").append(this.fpgaImageId()).append(",");
        }
        if (this.attributeString() != null) {
            sb.append("Attribute: ").append(this.attributeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FpgaImageId": {
                return Optional.of(clazz.cast(this.fpgaImageId()));
            }
            case "Attribute": {
                return Optional.of(clazz.cast(this.attributeString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String fpgaImageId;
        private String attribute;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFpgaImageAttributeRequest model) {
            this.fpgaImageId(model.fpgaImageId);
            this.attribute(model.attribute);
        }

        public final String getFpgaImageId() {
            return this.fpgaImageId;
        }

        @Override
        public final Builder fpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
            return this;
        }

        public final void setFpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
        }

        public final String getAttribute() {
            return this.attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(FpgaImageAttributeName attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeFpgaImageAttributeRequest build() {
            return new DescribeFpgaImageAttributeRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, DescribeFpgaImageAttributeRequest> {
        public Builder fpgaImageId(String var1);

        public Builder attribute(String var1);

        public Builder attribute(FpgaImageAttributeName var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

