/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.SubnetIpv6CidrBlockAssociation;
import software.amazon.awssdk.services.ec2.model.SubnetIpv6CidrBlockAssociationSetCopier;
import software.amazon.awssdk.services.ec2.model.SubnetState;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Subnet
implements ToCopyableBuilder<Builder, Subnet> {
    private final String availabilityZone;
    private final Integer availableIpAddressCount;
    private final String cidrBlock;
    private final Boolean defaultForAz;
    private final Boolean mapPublicIpOnLaunch;
    private final String state;
    private final String subnetId;
    private final String vpcId;
    private final Boolean assignIpv6AddressOnCreation;
    private final List<SubnetIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet;
    private final List<Tag> tags;

    private Subnet(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.availableIpAddressCount = builder.availableIpAddressCount;
        this.cidrBlock = builder.cidrBlock;
        this.defaultForAz = builder.defaultForAz;
        this.mapPublicIpOnLaunch = builder.mapPublicIpOnLaunch;
        this.state = builder.state;
        this.subnetId = builder.subnetId;
        this.vpcId = builder.vpcId;
        this.assignIpv6AddressOnCreation = builder.assignIpv6AddressOnCreation;
        this.ipv6CidrBlockAssociationSet = builder.ipv6CidrBlockAssociationSet;
        this.tags = builder.tags;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Integer availableIpAddressCount() {
        return this.availableIpAddressCount;
    }

    public String cidrBlock() {
        return this.cidrBlock;
    }

    public Boolean defaultForAz() {
        return this.defaultForAz;
    }

    public Boolean mapPublicIpOnLaunch() {
        return this.mapPublicIpOnLaunch;
    }

    public SubnetState state() {
        return SubnetState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Boolean assignIpv6AddressOnCreation() {
        return this.assignIpv6AddressOnCreation;
    }

    public List<SubnetIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet() {
        return this.ipv6CidrBlockAssociationSet;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableIpAddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultForAz());
        hashCode = 31 * hashCode + Objects.hashCode(this.mapPublicIpOnLaunch());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assignIpv6AddressOnCreation());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6CidrBlockAssociationSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subnet)) {
            return false;
        }
        Subnet other = (Subnet)obj;
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.availableIpAddressCount(), other.availableIpAddressCount()) && Objects.equals(this.cidrBlock(), other.cidrBlock()) && Objects.equals(this.defaultForAz(), other.defaultForAz()) && Objects.equals(this.mapPublicIpOnLaunch(), other.mapPublicIpOnLaunch()) && Objects.equals(this.stateString(), other.stateString()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.assignIpv6AddressOnCreation(), other.assignIpv6AddressOnCreation()) && Objects.equals(this.ipv6CidrBlockAssociationSet(), other.ipv6CidrBlockAssociationSet()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.availableIpAddressCount() != null) {
            sb.append("AvailableIpAddressCount: ").append(this.availableIpAddressCount()).append(",");
        }
        if (this.cidrBlock() != null) {
            sb.append("CidrBlock: ").append(this.cidrBlock()).append(",");
        }
        if (this.defaultForAz() != null) {
            sb.append("DefaultForAz: ").append(this.defaultForAz()).append(",");
        }
        if (this.mapPublicIpOnLaunch() != null) {
            sb.append("MapPublicIpOnLaunch: ").append(this.mapPublicIpOnLaunch()).append(",");
        }
        if (this.stateString() != null) {
            sb.append("State: ").append(this.stateString()).append(",");
        }
        if (this.subnetId() != null) {
            sb.append("SubnetId: ").append(this.subnetId()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        if (this.assignIpv6AddressOnCreation() != null) {
            sb.append("AssignIpv6AddressOnCreation: ").append(this.assignIpv6AddressOnCreation()).append(",");
        }
        if (this.ipv6CidrBlockAssociationSet() != null) {
            sb.append("Ipv6CidrBlockAssociationSet: ").append(this.ipv6CidrBlockAssociationSet()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "AvailableIpAddressCount": {
                return Optional.of(clazz.cast(this.availableIpAddressCount()));
            }
            case "CidrBlock": {
                return Optional.of(clazz.cast(this.cidrBlock()));
            }
            case "DefaultForAz": {
                return Optional.of(clazz.cast(this.defaultForAz()));
            }
            case "MapPublicIpOnLaunch": {
                return Optional.of(clazz.cast(this.mapPublicIpOnLaunch()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "SubnetId": {
                return Optional.of(clazz.cast(this.subnetId()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
            case "AssignIpv6AddressOnCreation": {
                return Optional.of(clazz.cast(this.assignIpv6AddressOnCreation()));
            }
            case "Ipv6CidrBlockAssociationSet": {
                return Optional.of(clazz.cast(this.ipv6CidrBlockAssociationSet()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private Integer availableIpAddressCount;
        private String cidrBlock;
        private Boolean defaultForAz;
        private Boolean mapPublicIpOnLaunch;
        private String state;
        private String subnetId;
        private String vpcId;
        private Boolean assignIpv6AddressOnCreation;
        private List<SubnetIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(Subnet model) {
            this.availabilityZone(model.availabilityZone);
            this.availableIpAddressCount(model.availableIpAddressCount);
            this.cidrBlock(model.cidrBlock);
            this.defaultForAz(model.defaultForAz);
            this.mapPublicIpOnLaunch(model.mapPublicIpOnLaunch);
            this.state(model.state);
            this.subnetId(model.subnetId);
            this.vpcId(model.vpcId);
            this.assignIpv6AddressOnCreation(model.assignIpv6AddressOnCreation);
            this.ipv6CidrBlockAssociationSet(model.ipv6CidrBlockAssociationSet);
            this.tags(model.tags);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Integer getAvailableIpAddressCount() {
            return this.availableIpAddressCount;
        }

        @Override
        public final Builder availableIpAddressCount(Integer availableIpAddressCount) {
            this.availableIpAddressCount = availableIpAddressCount;
            return this;
        }

        public final void setAvailableIpAddressCount(Integer availableIpAddressCount) {
            this.availableIpAddressCount = availableIpAddressCount;
        }

        public final String getCidrBlock() {
            return this.cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        public final Boolean getDefaultForAz() {
            return this.defaultForAz;
        }

        @Override
        public final Builder defaultForAz(Boolean defaultForAz) {
            this.defaultForAz = defaultForAz;
            return this;
        }

        public final void setDefaultForAz(Boolean defaultForAz) {
            this.defaultForAz = defaultForAz;
        }

        public final Boolean getMapPublicIpOnLaunch() {
            return this.mapPublicIpOnLaunch;
        }

        @Override
        public final Builder mapPublicIpOnLaunch(Boolean mapPublicIpOnLaunch) {
            this.mapPublicIpOnLaunch = mapPublicIpOnLaunch;
            return this;
        }

        public final void setMapPublicIpOnLaunch(Boolean mapPublicIpOnLaunch) {
            this.mapPublicIpOnLaunch = mapPublicIpOnLaunch;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SubnetState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Boolean getAssignIpv6AddressOnCreation() {
            return this.assignIpv6AddressOnCreation;
        }

        @Override
        public final Builder assignIpv6AddressOnCreation(Boolean assignIpv6AddressOnCreation) {
            this.assignIpv6AddressOnCreation = assignIpv6AddressOnCreation;
            return this;
        }

        public final void setAssignIpv6AddressOnCreation(Boolean assignIpv6AddressOnCreation) {
            this.assignIpv6AddressOnCreation = assignIpv6AddressOnCreation;
        }

        public final Collection<SubnetIpv6CidrBlockAssociation.Builder> getIpv6CidrBlockAssociationSet() {
            return this.ipv6CidrBlockAssociationSet != null ? (Collection)this.ipv6CidrBlockAssociationSet.stream().map(SubnetIpv6CidrBlockAssociation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipv6CidrBlockAssociationSet(Collection<SubnetIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet = SubnetIpv6CidrBlockAssociationSetCopier.copy(ipv6CidrBlockAssociationSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockAssociationSet(SubnetIpv6CidrBlockAssociation ... ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet(Arrays.asList(ipv6CidrBlockAssociationSet));
            return this;
        }

        public final void setIpv6CidrBlockAssociationSet(Collection<SubnetIpv6CidrBlockAssociation.BuilderImpl> ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet = SubnetIpv6CidrBlockAssociationSetCopier.copyFromBuilder(ipv6CidrBlockAssociationSet);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public Subnet build() {
            return new Subnet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Subnet> {
        public Builder availabilityZone(String var1);

        public Builder availableIpAddressCount(Integer var1);

        public Builder cidrBlock(String var1);

        public Builder defaultForAz(Boolean var1);

        public Builder mapPublicIpOnLaunch(Boolean var1);

        public Builder state(String var1);

        public Builder state(SubnetState var1);

        public Builder subnetId(String var1);

        public Builder vpcId(String var1);

        public Builder assignIpv6AddressOnCreation(Boolean var1);

        public Builder ipv6CidrBlockAssociationSet(Collection<SubnetIpv6CidrBlockAssociation> var1);

        public Builder ipv6CidrBlockAssociationSet(SubnetIpv6CidrBlockAssociation ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

