/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.ec2.EC2Client;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsResponse;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesOffering;

public final class DescribeReservedInstancesOfferingsPaginator
implements SdkIterable<DescribeReservedInstancesOfferingsResponse> {
    private final EC2Client client;
    private final DescribeReservedInstancesOfferingsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeReservedInstancesOfferingsPaginator(EC2Client client, DescribeReservedInstancesOfferingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeReservedInstancesOfferingsResponseFetcher();
    }

    public Iterator<DescribeReservedInstancesOfferingsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<ReservedInstancesOffering> reservedInstancesOfferings() {
        Function<DescribeReservedInstancesOfferingsResponse, Iterator> getIterator = response -> response != null ? response.reservedInstancesOfferings().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeReservedInstancesOfferingsResponseFetcher
    implements NextPageFetcher<DescribeReservedInstancesOfferingsResponse> {
        private DescribeReservedInstancesOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedInstancesOfferingsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeReservedInstancesOfferingsResponse nextPage(DescribeReservedInstancesOfferingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedInstancesOfferingsPaginator.this.client.describeReservedInstancesOfferings(DescribeReservedInstancesOfferingsPaginator.this.firstRequest);
            }
            return DescribeReservedInstancesOfferingsPaginator.this.client.describeReservedInstancesOfferings((DescribeReservedInstancesOfferingsRequest)((Object)DescribeReservedInstancesOfferingsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

