/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.ResetInstanceAttributeRequest;

public class ResetInstanceAttributeRequestMarshaller
implements Marshaller<Request<ResetInstanceAttributeRequest>, ResetInstanceAttributeRequest> {
    public Request<ResetInstanceAttributeRequest> marshall(ResetInstanceAttributeRequest resetInstanceAttributeRequest) {
        if (resetInstanceAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)resetInstanceAttributeRequest, "EC2Client");
        request.addParameter("Action", "ResetInstanceAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (resetInstanceAttributeRequest.attributeString() != null) {
            request.addParameter("Attribute", StringUtils.fromString((String)resetInstanceAttributeRequest.attributeString()));
        }
        if (resetInstanceAttributeRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)resetInstanceAttributeRequest.instanceId()));
        }
        return request;
    }
}

