/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class AssociateVpcCidrBlockResponse extends EC2Response implements
        ToCopyableBuilder<AssociateVpcCidrBlockResponse.Builder, AssociateVpcCidrBlockResponse> {
    private final VpcIpv6CidrBlockAssociation ipv6CidrBlockAssociation;

    private final VpcCidrBlockAssociation cidrBlockAssociation;

    private final String vpcId;

    private AssociateVpcCidrBlockResponse(BuilderImpl builder) {
        super(builder);
        this.ipv6CidrBlockAssociation = builder.ipv6CidrBlockAssociation;
        this.cidrBlockAssociation = builder.cidrBlockAssociation;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * Information about the IPv6 CIDR block association.
     * </p>
     * 
     * @return Information about the IPv6 CIDR block association.
     */
    public VpcIpv6CidrBlockAssociation ipv6CidrBlockAssociation() {
        return ipv6CidrBlockAssociation;
    }

    /**
     * <p>
     * Information about the IPv4 CIDR block association.
     * </p>
     * 
     * @return Information about the IPv4 CIDR block association.
     */
    public VpcCidrBlockAssociation cidrBlockAssociation() {
        return cidrBlockAssociation;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipv6CidrBlockAssociation());
        hashCode = 31 * hashCode + Objects.hashCode(cidrBlockAssociation());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateVpcCidrBlockResponse)) {
            return false;
        }
        AssociateVpcCidrBlockResponse other = (AssociateVpcCidrBlockResponse) obj;
        return Objects.equals(ipv6CidrBlockAssociation(), other.ipv6CidrBlockAssociation())
                && Objects.equals(cidrBlockAssociation(), other.cidrBlockAssociation()) && Objects.equals(vpcId(), other.vpcId());
    }

    @Override
    public String toString() {
        return ToString.builder("AssociateVpcCidrBlockResponse").add("Ipv6CidrBlockAssociation", ipv6CidrBlockAssociation())
                .add("CidrBlockAssociation", cidrBlockAssociation()).add("VpcId", vpcId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ipv6CidrBlockAssociation":
            return Optional.of(clazz.cast(ipv6CidrBlockAssociation()));
        case "CidrBlockAssociation":
            return Optional.of(clazz.cast(cidrBlockAssociation()));
        case "VpcId":
            return Optional.of(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, AssociateVpcCidrBlockResponse> {
        /**
         * <p>
         * Information about the IPv6 CIDR block association.
         * </p>
         * 
         * @param ipv6CidrBlockAssociation
         *        Information about the IPv6 CIDR block association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlockAssociation(VpcIpv6CidrBlockAssociation ipv6CidrBlockAssociation);

        /**
         * <p>
         * Information about the IPv6 CIDR block association.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcIpv6CidrBlockAssociation.Builder} avoiding
         * the need to create one manually via {@link VpcIpv6CidrBlockAssociation#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcIpv6CidrBlockAssociation.Builder#build()} is called
         * immediately and its result is passed to {@link #ipv6CidrBlockAssociation(VpcIpv6CidrBlockAssociation)}.
         * 
         * @param ipv6CidrBlockAssociation
         *        a consumer that will call methods on {@link VpcIpv6CidrBlockAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv6CidrBlockAssociation(VpcIpv6CidrBlockAssociation)
         */
        default Builder ipv6CidrBlockAssociation(Consumer<VpcIpv6CidrBlockAssociation.Builder> ipv6CidrBlockAssociation) {
            return ipv6CidrBlockAssociation(VpcIpv6CidrBlockAssociation.builder().apply(ipv6CidrBlockAssociation).build());
        }

        /**
         * <p>
         * Information about the IPv4 CIDR block association.
         * </p>
         * 
         * @param cidrBlockAssociation
         *        Information about the IPv4 CIDR block association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlockAssociation(VpcCidrBlockAssociation cidrBlockAssociation);

        /**
         * <p>
         * Information about the IPv4 CIDR block association.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcCidrBlockAssociation.Builder} avoiding the
         * need to create one manually via {@link VpcCidrBlockAssociation#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcCidrBlockAssociation.Builder#build()} is called immediately
         * and its result is passed to {@link #cidrBlockAssociation(VpcCidrBlockAssociation)}.
         * 
         * @param cidrBlockAssociation
         *        a consumer that will call methods on {@link VpcCidrBlockAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cidrBlockAssociation(VpcCidrBlockAssociation)
         */
        default Builder cidrBlockAssociation(Consumer<VpcCidrBlockAssociation.Builder> cidrBlockAssociation) {
            return cidrBlockAssociation(VpcCidrBlockAssociation.builder().apply(cidrBlockAssociation).build());
        }

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private VpcIpv6CidrBlockAssociation ipv6CidrBlockAssociation;

        private VpcCidrBlockAssociation cidrBlockAssociation;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateVpcCidrBlockResponse model) {
            ipv6CidrBlockAssociation(model.ipv6CidrBlockAssociation);
            cidrBlockAssociation(model.cidrBlockAssociation);
            vpcId(model.vpcId);
        }

        public final VpcIpv6CidrBlockAssociation.Builder getIpv6CidrBlockAssociation() {
            return ipv6CidrBlockAssociation != null ? ipv6CidrBlockAssociation.toBuilder() : null;
        }

        @Override
        public final Builder ipv6CidrBlockAssociation(VpcIpv6CidrBlockAssociation ipv6CidrBlockAssociation) {
            this.ipv6CidrBlockAssociation = ipv6CidrBlockAssociation;
            return this;
        }

        public final void setIpv6CidrBlockAssociation(VpcIpv6CidrBlockAssociation.BuilderImpl ipv6CidrBlockAssociation) {
            this.ipv6CidrBlockAssociation = ipv6CidrBlockAssociation != null ? ipv6CidrBlockAssociation.build() : null;
        }

        public final VpcCidrBlockAssociation.Builder getCidrBlockAssociation() {
            return cidrBlockAssociation != null ? cidrBlockAssociation.toBuilder() : null;
        }

        @Override
        public final Builder cidrBlockAssociation(VpcCidrBlockAssociation cidrBlockAssociation) {
            this.cidrBlockAssociation = cidrBlockAssociation;
            return this;
        }

        public final void setCidrBlockAssociation(VpcCidrBlockAssociation.BuilderImpl cidrBlockAssociation) {
            this.cidrBlockAssociation = cidrBlockAssociation != null ? cidrBlockAssociation.build() : null;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public AssociateVpcCidrBlockResponse build() {
            return new AssociateVpcCidrBlockResponse(this);
        }
    }
}
