/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A simple result wrapper around the VolumeAttachment object that was sent over the wire.
 */
@Generated("software.amazon.awssdk:codegen")
public class AttachVolumeResponse extends EC2Response implements
        ToCopyableBuilder<AttachVolumeResponse.Builder, AttachVolumeResponse> {
    private final VolumeAttachment attachment;

    private AttachVolumeResponse(BuilderImpl builder) {
        super(builder);
        this.attachment = builder.attachment;
    }

    /**
     * <p>
     * Describes volume attachment details.
     * </p>
     * 
     * @return Describes volume attachment details.
     */
    public VolumeAttachment attachment() {
        return attachment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachment());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachVolumeResponse)) {
            return false;
        }
        AttachVolumeResponse other = (AttachVolumeResponse) obj;
        return Objects.equals(attachment(), other.attachment());
    }

    @Override
    public String toString() {
        return ToString.builder("AttachVolumeResponse").add("Attachment", attachment()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attachment":
            return Optional.of(clazz.cast(attachment()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, AttachVolumeResponse> {
        /**
         * <p>
         * Describes volume attachment details.
         * </p>
         * 
         * @param attachment
         *        Describes volume attachment details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachment(VolumeAttachment attachment);

        /**
         * <p>
         * Describes volume attachment details.
         * </p>
         * This is a convenience that creates an instance of the {@link VolumeAttachment.Builder} avoiding the need to
         * create one manually via {@link VolumeAttachment#builder()}.
         *
         * When the {@link Consumer} completes, {@link VolumeAttachment.Builder#build()} is called immediately and its
         * result is passed to {@link #attachment(VolumeAttachment)}.
         * 
         * @param attachment
         *        a consumer that will call methods on {@link VolumeAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachment(VolumeAttachment)
         */
        default Builder attachment(Consumer<VolumeAttachment.Builder> attachment) {
            return attachment(VolumeAttachment.builder().apply(attachment).build());
        }
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private VolumeAttachment attachment;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachVolumeResponse model) {
            attachment(model.attachment);
        }

        public final VolumeAttachment.Builder getAttachment() {
            return attachment != null ? attachment.toBuilder() : null;
        }

        @Override
        public final Builder attachment(VolumeAttachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public final void setAttachment(VolumeAttachment.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        @Override
        public AttachVolumeResponse build() {
            return new AttachVolumeResponse(this);
        }
    }
}
