/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for AuthorizeSecurityGroupEgress.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AuthorizeSecurityGroupEgressRequest extends EC2Request implements
        ToCopyableBuilder<AuthorizeSecurityGroupEgressRequest.Builder, AuthorizeSecurityGroupEgressRequest> {
    private final String groupId;

    private final List<IpPermission> ipPermissions;

    private final String cidrIp;

    private final Integer fromPort;

    private final String ipProtocol;

    private final Integer toPort;

    private final String sourceSecurityGroupName;

    private final String sourceSecurityGroupOwnerId;

    private AuthorizeSecurityGroupEgressRequest(BuilderImpl builder) {
        super(builder);
        this.groupId = builder.groupId;
        this.ipPermissions = builder.ipPermissions;
        this.cidrIp = builder.cidrIp;
        this.fromPort = builder.fromPort;
        this.ipProtocol = builder.ipProtocol;
        this.toPort = builder.toPort;
        this.sourceSecurityGroupName = builder.sourceSecurityGroupName;
        this.sourceSecurityGroupOwnerId = builder.sourceSecurityGroupOwnerId;
    }

    /**
     * <p>
     * The ID of the security group.
     * </p>
     * 
     * @return The ID of the security group.
     */
    public String groupId() {
        return groupId;
    }

    /**
     * <p>
     * One or more sets of IP permissions. You can't specify a destination security group and a CIDR IP address range in
     * the same set of permissions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more sets of IP permissions. You can't specify a destination security group and a CIDR IP address
     *         range in the same set of permissions.
     */
    public List<IpPermission> ipPermissions() {
        return ipPermissions;
    }

    /**
     * <p>
     * Not supported. Use a set of IP permissions to specify the CIDR.
     * </p>
     * 
     * @return Not supported. Use a set of IP permissions to specify the CIDR.
     */
    public String cidrIp() {
        return cidrIp;
    }

    /**
     * <p>
     * Not supported. Use a set of IP permissions to specify the port.
     * </p>
     * 
     * @return Not supported. Use a set of IP permissions to specify the port.
     */
    public Integer fromPort() {
        return fromPort;
    }

    /**
     * <p>
     * Not supported. Use a set of IP permissions to specify the protocol name or number.
     * </p>
     * 
     * @return Not supported. Use a set of IP permissions to specify the protocol name or number.
     */
    public String ipProtocol() {
        return ipProtocol;
    }

    /**
     * <p>
     * Not supported. Use a set of IP permissions to specify the port.
     * </p>
     * 
     * @return Not supported. Use a set of IP permissions to specify the port.
     */
    public Integer toPort() {
        return toPort;
    }

    /**
     * <p>
     * Not supported. Use a set of IP permissions to specify a destination security group.
     * </p>
     * 
     * @return Not supported. Use a set of IP permissions to specify a destination security group.
     */
    public String sourceSecurityGroupName() {
        return sourceSecurityGroupName;
    }

    /**
     * <p>
     * Not supported. Use a set of IP permissions to specify a destination security group.
     * </p>
     * 
     * @return Not supported. Use a set of IP permissions to specify a destination security group.
     */
    public String sourceSecurityGroupOwnerId() {
        return sourceSecurityGroupOwnerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(ipPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(cidrIp());
        hashCode = 31 * hashCode + Objects.hashCode(fromPort());
        hashCode = 31 * hashCode + Objects.hashCode(ipProtocol());
        hashCode = 31 * hashCode + Objects.hashCode(toPort());
        hashCode = 31 * hashCode + Objects.hashCode(sourceSecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceSecurityGroupOwnerId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizeSecurityGroupEgressRequest)) {
            return false;
        }
        AuthorizeSecurityGroupEgressRequest other = (AuthorizeSecurityGroupEgressRequest) obj;
        return Objects.equals(groupId(), other.groupId()) && Objects.equals(ipPermissions(), other.ipPermissions())
                && Objects.equals(cidrIp(), other.cidrIp()) && Objects.equals(fromPort(), other.fromPort())
                && Objects.equals(ipProtocol(), other.ipProtocol()) && Objects.equals(toPort(), other.toPort())
                && Objects.equals(sourceSecurityGroupName(), other.sourceSecurityGroupName())
                && Objects.equals(sourceSecurityGroupOwnerId(), other.sourceSecurityGroupOwnerId());
    }

    @Override
    public String toString() {
        return ToString.builder("AuthorizeSecurityGroupEgressRequest").add("GroupId", groupId())
                .add("IpPermissions", ipPermissions()).add("CidrIp", cidrIp()).add("FromPort", fromPort())
                .add("IpProtocol", ipProtocol()).add("ToPort", toPort())
                .add("SourceSecurityGroupName", sourceSecurityGroupName())
                .add("SourceSecurityGroupOwnerId", sourceSecurityGroupOwnerId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupId":
            return Optional.of(clazz.cast(groupId()));
        case "IpPermissions":
            return Optional.of(clazz.cast(ipPermissions()));
        case "CidrIp":
            return Optional.of(clazz.cast(cidrIp()));
        case "FromPort":
            return Optional.of(clazz.cast(fromPort()));
        case "IpProtocol":
            return Optional.of(clazz.cast(ipProtocol()));
        case "ToPort":
            return Optional.of(clazz.cast(toPort()));
        case "SourceSecurityGroupName":
            return Optional.of(clazz.cast(sourceSecurityGroupName()));
        case "SourceSecurityGroupOwnerId":
            return Optional.of(clazz.cast(sourceSecurityGroupOwnerId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, AuthorizeSecurityGroupEgressRequest> {
        /**
         * <p>
         * The ID of the security group.
         * </p>
         * 
         * @param groupId
         *        The ID of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * One or more sets of IP permissions. You can't specify a destination security group and a CIDR IP address
         * range in the same set of permissions.
         * </p>
         * 
         * @param ipPermissions
         *        One or more sets of IP permissions. You can't specify a destination security group and a CIDR IP
         *        address range in the same set of permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPermissions(Collection<IpPermission> ipPermissions);

        /**
         * <p>
         * One or more sets of IP permissions. You can't specify a destination security group and a CIDR IP address
         * range in the same set of permissions.
         * </p>
         * 
         * @param ipPermissions
         *        One or more sets of IP permissions. You can't specify a destination security group and a CIDR IP
         *        address range in the same set of permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPermissions(IpPermission... ipPermissions);

        /**
         * <p>
         * Not supported. Use a set of IP permissions to specify the CIDR.
         * </p>
         * 
         * @param cidrIp
         *        Not supported. Use a set of IP permissions to specify the CIDR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrIp(String cidrIp);

        /**
         * <p>
         * Not supported. Use a set of IP permissions to specify the port.
         * </p>
         * 
         * @param fromPort
         *        Not supported. Use a set of IP permissions to specify the port.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromPort(Integer fromPort);

        /**
         * <p>
         * Not supported. Use a set of IP permissions to specify the protocol name or number.
         * </p>
         * 
         * @param ipProtocol
         *        Not supported. Use a set of IP permissions to specify the protocol name or number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipProtocol(String ipProtocol);

        /**
         * <p>
         * Not supported. Use a set of IP permissions to specify the port.
         * </p>
         * 
         * @param toPort
         *        Not supported. Use a set of IP permissions to specify the port.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toPort(Integer toPort);

        /**
         * <p>
         * Not supported. Use a set of IP permissions to specify a destination security group.
         * </p>
         * 
         * @param sourceSecurityGroupName
         *        Not supported. Use a set of IP permissions to specify a destination security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSecurityGroupName(String sourceSecurityGroupName);

        /**
         * <p>
         * Not supported. Use a set of IP permissions to specify a destination security group.
         * </p>
         * 
         * @param sourceSecurityGroupOwnerId
         *        Not supported. Use a set of IP permissions to specify a destination security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSecurityGroupOwnerId(String sourceSecurityGroupOwnerId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String groupId;

        private List<IpPermission> ipPermissions;

        private String cidrIp;

        private Integer fromPort;

        private String ipProtocol;

        private Integer toPort;

        private String sourceSecurityGroupName;

        private String sourceSecurityGroupOwnerId;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizeSecurityGroupEgressRequest model) {
            groupId(model.groupId);
            ipPermissions(model.ipPermissions);
            cidrIp(model.cidrIp);
            fromPort(model.fromPort);
            ipProtocol(model.ipProtocol);
            toPort(model.toPort);
            sourceSecurityGroupName(model.sourceSecurityGroupName);
            sourceSecurityGroupOwnerId(model.sourceSecurityGroupOwnerId);
        }

        public final String getGroupId() {
            return groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final Collection<IpPermission.Builder> getIpPermissions() {
            return ipPermissions != null ? ipPermissions.stream().map(IpPermission::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder ipPermissions(Collection<IpPermission> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copy(ipPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissions(IpPermission... ipPermissions) {
            ipPermissions(Arrays.asList(ipPermissions));
            return this;
        }

        public final void setIpPermissions(Collection<IpPermission.BuilderImpl> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copyFromBuilder(ipPermissions);
        }

        public final String getCidrIp() {
            return cidrIp;
        }

        @Override
        public final Builder cidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
            return this;
        }

        public final void setCidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
        }

        public final Integer getFromPort() {
            return fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        public final String getIpProtocol() {
            return ipProtocol;
        }

        @Override
        public final Builder ipProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        public final void setIpProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
        }

        public final Integer getToPort() {
            return toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        public final String getSourceSecurityGroupName() {
            return sourceSecurityGroupName;
        }

        @Override
        public final Builder sourceSecurityGroupName(String sourceSecurityGroupName) {
            this.sourceSecurityGroupName = sourceSecurityGroupName;
            return this;
        }

        public final void setSourceSecurityGroupName(String sourceSecurityGroupName) {
            this.sourceSecurityGroupName = sourceSecurityGroupName;
        }

        public final String getSourceSecurityGroupOwnerId() {
            return sourceSecurityGroupOwnerId;
        }

        @Override
        public final Builder sourceSecurityGroupOwnerId(String sourceSecurityGroupOwnerId) {
            this.sourceSecurityGroupOwnerId = sourceSecurityGroupOwnerId;
            return this;
        }

        public final void setSourceSecurityGroupOwnerId(String sourceSecurityGroupOwnerId) {
            this.sourceSecurityGroupOwnerId = sourceSecurityGroupOwnerId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AuthorizeSecurityGroupEgressRequest build() {
            return new AuthorizeSecurityGroupEgressRequest(this);
        }
    }
}
