/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateDefaultSubnetResponse extends EC2Response implements
        ToCopyableBuilder<CreateDefaultSubnetResponse.Builder, CreateDefaultSubnetResponse> {
    private final Subnet subnet;

    private CreateDefaultSubnetResponse(BuilderImpl builder) {
        super(builder);
        this.subnet = builder.subnet;
    }

    /**
     * <p>
     * Information about the subnet.
     * </p>
     * 
     * @return Information about the subnet.
     */
    public Subnet subnet() {
        return subnet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subnet());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDefaultSubnetResponse)) {
            return false;
        }
        CreateDefaultSubnetResponse other = (CreateDefaultSubnetResponse) obj;
        return Objects.equals(subnet(), other.subnet());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateDefaultSubnetResponse").add("Subnet", subnet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Subnet":
            return Optional.of(clazz.cast(subnet()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, CreateDefaultSubnetResponse> {
        /**
         * <p>
         * Information about the subnet.
         * </p>
         * 
         * @param subnet
         *        Information about the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnet(Subnet subnet);

        /**
         * <p>
         * Information about the subnet.
         * </p>
         * This is a convenience that creates an instance of the {@link Subnet.Builder} avoiding the need to create one
         * manually via {@link Subnet#builder()}.
         *
         * When the {@link Consumer} completes, {@link Subnet.Builder#build()} is called immediately and its result is
         * passed to {@link #subnet(Subnet)}.
         * 
         * @param subnet
         *        a consumer that will call methods on {@link Subnet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subnet(Subnet)
         */
        default Builder subnet(Consumer<Subnet.Builder> subnet) {
            return subnet(Subnet.builder().apply(subnet).build());
        }
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private Subnet subnet;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDefaultSubnetResponse model) {
            subnet(model.subnet);
        }

        public final Subnet.Builder getSubnet() {
            return subnet != null ? subnet.toBuilder() : null;
        }

        @Override
        public final Builder subnet(Subnet subnet) {
            this.subnet = subnet;
            return this;
        }

        public final void setSubnet(Subnet.BuilderImpl subnet) {
            this.subnet = subnet != null ? subnet.build() : null;
        }

        @Override
        public CreateDefaultSubnetResponse build() {
            return new CreateDefaultSubnetResponse(this);
        }
    }
}
