/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateFpgaImageRequest extends EC2Request implements
        ToCopyableBuilder<CreateFpgaImageRequest.Builder, CreateFpgaImageRequest> {
    private final StorageLocation inputStorageLocation;

    private final StorageLocation logsStorageLocation;

    private final String description;

    private final String name;

    private final String clientToken;

    private CreateFpgaImageRequest(BuilderImpl builder) {
        super(builder);
        this.inputStorageLocation = builder.inputStorageLocation;
        this.logsStorageLocation = builder.logsStorageLocation;
        this.description = builder.description;
        this.name = builder.name;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The location of the encrypted design checkpoint in Amazon S3. The input must be a tarball.
     * </p>
     * 
     * @return The location of the encrypted design checkpoint in Amazon S3. The input must be a tarball.
     */
    public StorageLocation inputStorageLocation() {
        return inputStorageLocation;
    }

    /**
     * <p>
     * The location in Amazon S3 for the output logs.
     * </p>
     * 
     * @return The location in Amazon S3 for the output logs.
     */
    public StorageLocation logsStorageLocation() {
        return logsStorageLocation;
    }

    /**
     * <p>
     * A description for the AFI.
     * </p>
     * 
     * @return A description for the AFI.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A name for the AFI.
     * </p>
     * 
     * @return A name for the AFI.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputStorageLocation());
        hashCode = 31 * hashCode + Objects.hashCode(logsStorageLocation());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFpgaImageRequest)) {
            return false;
        }
        CreateFpgaImageRequest other = (CreateFpgaImageRequest) obj;
        return Objects.equals(inputStorageLocation(), other.inputStorageLocation())
                && Objects.equals(logsStorageLocation(), other.logsStorageLocation())
                && Objects.equals(description(), other.description()) && Objects.equals(name(), other.name())
                && Objects.equals(clientToken(), other.clientToken());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateFpgaImageRequest").add("InputStorageLocation", inputStorageLocation())
                .add("LogsStorageLocation", logsStorageLocation()).add("Description", description()).add("Name", name())
                .add("ClientToken", clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputStorageLocation":
            return Optional.of(clazz.cast(inputStorageLocation()));
        case "LogsStorageLocation":
            return Optional.of(clazz.cast(logsStorageLocation()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "ClientToken":
            return Optional.of(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, CreateFpgaImageRequest> {
        /**
         * <p>
         * The location of the encrypted design checkpoint in Amazon S3. The input must be a tarball.
         * </p>
         * 
         * @param inputStorageLocation
         *        The location of the encrypted design checkpoint in Amazon S3. The input must be a tarball.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputStorageLocation(StorageLocation inputStorageLocation);

        /**
         * <p>
         * The location of the encrypted design checkpoint in Amazon S3. The input must be a tarball.
         * </p>
         * This is a convenience that creates an instance of the {@link StorageLocation.Builder} avoiding the need to
         * create one manually via {@link StorageLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link StorageLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #inputStorageLocation(StorageLocation)}.
         * 
         * @param inputStorageLocation
         *        a consumer that will call methods on {@link StorageLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputStorageLocation(StorageLocation)
         */
        default Builder inputStorageLocation(Consumer<StorageLocation.Builder> inputStorageLocation) {
            return inputStorageLocation(StorageLocation.builder().apply(inputStorageLocation).build());
        }

        /**
         * <p>
         * The location in Amazon S3 for the output logs.
         * </p>
         * 
         * @param logsStorageLocation
         *        The location in Amazon S3 for the output logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logsStorageLocation(StorageLocation logsStorageLocation);

        /**
         * <p>
         * The location in Amazon S3 for the output logs.
         * </p>
         * This is a convenience that creates an instance of the {@link StorageLocation.Builder} avoiding the need to
         * create one manually via {@link StorageLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link StorageLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #logsStorageLocation(StorageLocation)}.
         * 
         * @param logsStorageLocation
         *        a consumer that will call methods on {@link StorageLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logsStorageLocation(StorageLocation)
         */
        default Builder logsStorageLocation(Consumer<StorageLocation.Builder> logsStorageLocation) {
            return logsStorageLocation(StorageLocation.builder().apply(logsStorageLocation).build());
        }

        /**
         * <p>
         * A description for the AFI.
         * </p>
         * 
         * @param description
         *        A description for the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A name for the AFI.
         * </p>
         * 
         * @param name
         *        A name for the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private StorageLocation inputStorageLocation;

        private StorageLocation logsStorageLocation;

        private String description;

        private String name;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFpgaImageRequest model) {
            inputStorageLocation(model.inputStorageLocation);
            logsStorageLocation(model.logsStorageLocation);
            description(model.description);
            name(model.name);
            clientToken(model.clientToken);
        }

        public final StorageLocation.Builder getInputStorageLocation() {
            return inputStorageLocation != null ? inputStorageLocation.toBuilder() : null;
        }

        @Override
        public final Builder inputStorageLocation(StorageLocation inputStorageLocation) {
            this.inputStorageLocation = inputStorageLocation;
            return this;
        }

        public final void setInputStorageLocation(StorageLocation.BuilderImpl inputStorageLocation) {
            this.inputStorageLocation = inputStorageLocation != null ? inputStorageLocation.build() : null;
        }

        public final StorageLocation.Builder getLogsStorageLocation() {
            return logsStorageLocation != null ? logsStorageLocation.toBuilder() : null;
        }

        @Override
        public final Builder logsStorageLocation(StorageLocation logsStorageLocation) {
            this.logsStorageLocation = logsStorageLocation;
            return this;
        }

        public final void setLogsStorageLocation(StorageLocation.BuilderImpl logsStorageLocation) {
            this.logsStorageLocation = logsStorageLocation != null ? logsStorageLocation.build() : null;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateFpgaImageRequest build() {
            return new CreateFpgaImageRequest(this);
        }
    }
}
