/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CreateNetworkAcl.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateNetworkAclResponse extends EC2Response implements
        ToCopyableBuilder<CreateNetworkAclResponse.Builder, CreateNetworkAclResponse> {
    private final NetworkAcl networkAcl;

    private CreateNetworkAclResponse(BuilderImpl builder) {
        super(builder);
        this.networkAcl = builder.networkAcl;
    }

    /**
     * <p>
     * Information about the network ACL.
     * </p>
     * 
     * @return Information about the network ACL.
     */
    public NetworkAcl networkAcl() {
        return networkAcl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkAcl());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkAclResponse)) {
            return false;
        }
        CreateNetworkAclResponse other = (CreateNetworkAclResponse) obj;
        return Objects.equals(networkAcl(), other.networkAcl());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateNetworkAclResponse").add("NetworkAcl", networkAcl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkAcl":
            return Optional.of(clazz.cast(networkAcl()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, CreateNetworkAclResponse> {
        /**
         * <p>
         * Information about the network ACL.
         * </p>
         * 
         * @param networkAcl
         *        Information about the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAcl(NetworkAcl networkAcl);

        /**
         * <p>
         * Information about the network ACL.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkAcl.Builder} avoiding the need to create
         * one manually via {@link NetworkAcl#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkAcl.Builder#build()} is called immediately and its result
         * is passed to {@link #networkAcl(NetworkAcl)}.
         * 
         * @param networkAcl
         *        a consumer that will call methods on {@link NetworkAcl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkAcl(NetworkAcl)
         */
        default Builder networkAcl(Consumer<NetworkAcl.Builder> networkAcl) {
            return networkAcl(NetworkAcl.builder().apply(networkAcl).build());
        }
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private NetworkAcl networkAcl;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkAclResponse model) {
            networkAcl(model.networkAcl);
        }

        public final NetworkAcl.Builder getNetworkAcl() {
            return networkAcl != null ? networkAcl.toBuilder() : null;
        }

        @Override
        public final Builder networkAcl(NetworkAcl networkAcl) {
            this.networkAcl = networkAcl;
            return this;
        }

        public final void setNetworkAcl(NetworkAcl.BuilderImpl networkAcl) {
            this.networkAcl = networkAcl != null ? networkAcl.build() : null;
        }

        @Override
        public CreateNetworkAclResponse build() {
            return new CreateNetworkAclResponse(this);
        }
    }
}
