/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeEgressOnlyInternetGatewaysRequest extends EC2Request implements
        ToCopyableBuilder<DescribeEgressOnlyInternetGatewaysRequest.Builder, DescribeEgressOnlyInternetGatewaysRequest> {
    private final List<String> egressOnlyInternetGatewayIds;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeEgressOnlyInternetGatewaysRequest(BuilderImpl builder) {
        super(builder);
        this.egressOnlyInternetGatewayIds = builder.egressOnlyInternetGatewayIds;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * One or more egress-only Internet gateway IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more egress-only Internet gateway IDs.
     */
    public List<String> egressOnlyInternetGatewayIds() {
        return egressOnlyInternetGatewayIds;
    }

    /**
     * <p>
     * The maximum number of results to return for the request in a single page. The remaining results can be seen by
     * sending another request with the returned <code>NextToken</code> value. This value can be between 5 and 1000; if
     * <code>MaxResults</code> is given a value larger than 1000, only 1000 results are returned.
     * </p>
     * 
     * @return The maximum number of results to return for the request in a single page. The remaining results can be
     *         seen by sending another request with the returned <code>NextToken</code> value. This value can be between
     *         5 and 1000; if <code>MaxResults</code> is given a value larger than 1000, only 1000 results are returned.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to retrieve the next page of results.
     * </p>
     * 
     * @return The token to retrieve the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(egressOnlyInternetGatewayIds());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEgressOnlyInternetGatewaysRequest)) {
            return false;
        }
        DescribeEgressOnlyInternetGatewaysRequest other = (DescribeEgressOnlyInternetGatewaysRequest) obj;
        return Objects.equals(egressOnlyInternetGatewayIds(), other.egressOnlyInternetGatewayIds())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeEgressOnlyInternetGatewaysRequest")
                .add("EgressOnlyInternetGatewayIds", egressOnlyInternetGatewayIds()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EgressOnlyInternetGatewayIds":
            return Optional.of(clazz.cast(egressOnlyInternetGatewayIds()));
        case "MaxResults":
            return Optional.of(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, DescribeEgressOnlyInternetGatewaysRequest> {
        /**
         * <p>
         * One or more egress-only Internet gateway IDs.
         * </p>
         * 
         * @param egressOnlyInternetGatewayIds
         *        One or more egress-only Internet gateway IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressOnlyInternetGatewayIds(Collection<String> egressOnlyInternetGatewayIds);

        /**
         * <p>
         * One or more egress-only Internet gateway IDs.
         * </p>
         * 
         * @param egressOnlyInternetGatewayIds
         *        One or more egress-only Internet gateway IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressOnlyInternetGatewayIds(String... egressOnlyInternetGatewayIds);

        /**
         * <p>
         * The maximum number of results to return for the request in a single page. The remaining results can be seen
         * by sending another request with the returned <code>NextToken</code> value. This value can be between 5 and
         * 1000; if <code>MaxResults</code> is given a value larger than 1000, only 1000 results are returned.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return for the request in a single page. The remaining results can be
         *        seen by sending another request with the returned <code>NextToken</code> value. This value can be
         *        between 5 and 1000; if <code>MaxResults</code> is given a value larger than 1000, only 1000 results
         *        are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private List<String> egressOnlyInternetGatewayIds;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEgressOnlyInternetGatewaysRequest model) {
            egressOnlyInternetGatewayIds(model.egressOnlyInternetGatewayIds);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<String> getEgressOnlyInternetGatewayIds() {
            return egressOnlyInternetGatewayIds;
        }

        @Override
        public final Builder egressOnlyInternetGatewayIds(Collection<String> egressOnlyInternetGatewayIds) {
            this.egressOnlyInternetGatewayIds = EgressOnlyInternetGatewayIdListCopier.copy(egressOnlyInternetGatewayIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder egressOnlyInternetGatewayIds(String... egressOnlyInternetGatewayIds) {
            egressOnlyInternetGatewayIds(Arrays.asList(egressOnlyInternetGatewayIds));
            return this;
        }

        public final void setEgressOnlyInternetGatewayIds(Collection<String> egressOnlyInternetGatewayIds) {
            this.egressOnlyInternetGatewayIds = EgressOnlyInternetGatewayIdListCopier.copy(egressOnlyInternetGatewayIds);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeEgressOnlyInternetGatewaysRequest build() {
            return new DescribeEgressOnlyInternetGatewaysRequest(this);
        }
    }
}
