/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeHostReservationsResponse extends EC2Response implements
        ToCopyableBuilder<DescribeHostReservationsResponse.Builder, DescribeHostReservationsResponse> {
    private final List<HostReservation> hostReservationSet;

    private final String nextToken;

    private DescribeHostReservationsResponse(BuilderImpl builder) {
        super(builder);
        this.hostReservationSet = builder.hostReservationSet;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Details about the reservation's configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Details about the reservation's configuration.
     */
    public List<HostReservation> hostReservationSet() {
        return hostReservationSet;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostReservationSet());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHostReservationsResponse)) {
            return false;
        }
        DescribeHostReservationsResponse other = (DescribeHostReservationsResponse) obj;
        return Objects.equals(hostReservationSet(), other.hostReservationSet()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeHostReservationsResponse").add("HostReservationSet", hostReservationSet())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostReservationSet":
            return Optional.of(clazz.cast(hostReservationSet()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeHostReservationsResponse> {
        /**
         * <p>
         * Details about the reservation's configuration.
         * </p>
         * 
         * @param hostReservationSet
         *        Details about the reservation's configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostReservationSet(Collection<HostReservation> hostReservationSet);

        /**
         * <p>
         * Details about the reservation's configuration.
         * </p>
         * 
         * @param hostReservationSet
         *        Details about the reservation's configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostReservationSet(HostReservation... hostReservationSet);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<HostReservation> hostReservationSet;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHostReservationsResponse model) {
            hostReservationSet(model.hostReservationSet);
            nextToken(model.nextToken);
        }

        public final Collection<HostReservation.Builder> getHostReservationSet() {
            return hostReservationSet != null ? hostReservationSet.stream().map(HostReservation::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder hostReservationSet(Collection<HostReservation> hostReservationSet) {
            this.hostReservationSet = HostReservationSetCopier.copy(hostReservationSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostReservationSet(HostReservation... hostReservationSet) {
            hostReservationSet(Arrays.asList(hostReservationSet));
            return this;
        }

        public final void setHostReservationSet(Collection<HostReservation.BuilderImpl> hostReservationSet) {
            this.hostReservationSet = HostReservationSetCopier.copyFromBuilder(hostReservationSet);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeHostReservationsResponse build() {
            return new DescribeHostReservationsResponse(this);
        }
    }
}
