/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeImageAttribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeImageAttributeRequest extends EC2Request implements
        ToCopyableBuilder<DescribeImageAttributeRequest.Builder, DescribeImageAttributeRequest> {
    private final String attribute;

    private final String imageId;

    private DescribeImageAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.attribute = builder.attribute;
        this.imageId = builder.imageId;
    }

    /**
     * <p>
     * The AMI attribute.
     * </p>
     * <p>
     * <b>Note</b>: Depending on your account privileges, the <code>blockDeviceMapping</code> attribute may return a
     * <code>Client.AuthFailure</code> error. If this happens, use <a>DescribeImages</a> to get information about the
     * block device mapping for the AMI.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link ImageAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #attributeString}.
     * </p>
     * 
     * @return The AMI attribute.</p>
     *         <p>
     *         <b>Note</b>: Depending on your account privileges, the <code>blockDeviceMapping</code> attribute may
     *         return a <code>Client.AuthFailure</code> error. If this happens, use <a>DescribeImages</a> to get
     *         information about the block device mapping for the AMI.
     * @see ImageAttributeName
     */
    public ImageAttributeName attribute() {
        return ImageAttributeName.fromValue(attribute);
    }

    /**
     * <p>
     * The AMI attribute.
     * </p>
     * <p>
     * <b>Note</b>: Depending on your account privileges, the <code>blockDeviceMapping</code> attribute may return a
     * <code>Client.AuthFailure</code> error. If this happens, use <a>DescribeImages</a> to get information about the
     * block device mapping for the AMI.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link ImageAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #attributeString}.
     * </p>
     * 
     * @return The AMI attribute.</p>
     *         <p>
     *         <b>Note</b>: Depending on your account privileges, the <code>blockDeviceMapping</code> attribute may
     *         return a <code>Client.AuthFailure</code> error. If this happens, use <a>DescribeImages</a> to get
     *         information about the block device mapping for the AMI.
     * @see ImageAttributeName
     */
    public String attributeString() {
        return attribute;
    }

    /**
     * <p>
     * The ID of the AMI.
     * </p>
     * 
     * @return The ID of the AMI.
     */
    public String imageId() {
        return imageId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeString());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageAttributeRequest)) {
            return false;
        }
        DescribeImageAttributeRequest other = (DescribeImageAttributeRequest) obj;
        return Objects.equals(attributeString(), other.attributeString()) && Objects.equals(imageId(), other.imageId());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeImageAttributeRequest").add("Attribute", attributeString()).add("ImageId", imageId())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attribute":
            return Optional.of(clazz.cast(attributeString()));
        case "ImageId":
            return Optional.of(clazz.cast(imageId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, DescribeImageAttributeRequest> {
        /**
         * <p>
         * The AMI attribute.
         * </p>
         * <p>
         * <b>Note</b>: Depending on your account privileges, the <code>blockDeviceMapping</code> attribute may return a
         * <code>Client.AuthFailure</code> error. If this happens, use <a>DescribeImages</a> to get information about
         * the block device mapping for the AMI.
         * </p>
         * 
         * @param attribute
         *        The AMI attribute.</p>
         *        <p>
         *        <b>Note</b>: Depending on your account privileges, the <code>blockDeviceMapping</code> attribute may
         *        return a <code>Client.AuthFailure</code> error. If this happens, use <a>DescribeImages</a> to get
         *        information about the block device mapping for the AMI.
         * @see ImageAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageAttributeName
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The AMI attribute.
         * </p>
         * <p>
         * <b>Note</b>: Depending on your account privileges, the <code>blockDeviceMapping</code> attribute may return a
         * <code>Client.AuthFailure</code> error. If this happens, use <a>DescribeImages</a> to get information about
         * the block device mapping for the AMI.
         * </p>
         * 
         * @param attribute
         *        The AMI attribute.</p>
         *        <p>
         *        <b>Note</b>: Depending on your account privileges, the <code>blockDeviceMapping</code> attribute may
         *        return a <code>Client.AuthFailure</code> error. If this happens, use <a>DescribeImages</a> to get
         *        information about the block device mapping for the AMI.
         * @see ImageAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageAttributeName
         */
        Builder attribute(ImageAttributeName attribute);

        /**
         * <p>
         * The ID of the AMI.
         * </p>
         * 
         * @param imageId
         *        The ID of the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String attribute;

        private String imageId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImageAttributeRequest model) {
            attribute(model.attribute);
            imageId(model.imageId);
        }

        public final String getAttribute() {
            return attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(ImageAttributeName attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeImageAttributeRequest build() {
            return new DescribeImageAttributeRequest(this);
        }
    }
}
