/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribePrefixLists.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribePrefixListsRequest extends EC2Request implements
        ToCopyableBuilder<DescribePrefixListsRequest.Builder, DescribePrefixListsRequest> {
    private final List<Filter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private final List<String> prefixListIds;

    private DescribePrefixListsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.prefixListIds = builder.prefixListIds;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>prefix-list-id</code>: The ID of a prefix list.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>prefix-list-name</code>: The name of a prefix list.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>prefix-list-id</code>: The ID of a prefix list.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>prefix-list-name</code>: The name of a prefix list.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of items to return for this request. The request returns a token that you can specify in a
     * subsequent call to get the next set of results.
     * </p>
     * <p>
     * Constraint: If the value specified is greater than 1000, we return only 1000 items.
     * </p>
     * 
     * @return The maximum number of items to return for this request. The request returns a token that you can specify
     *         in a subsequent call to get the next set of results.</p>
     *         <p>
     *         Constraint: If the value specified is greater than 1000, we return only 1000 items.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a prior call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a prior call.)
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * One or more prefix list IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more prefix list IDs.
     */
    public List<String> prefixListIds() {
        return prefixListIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(prefixListIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePrefixListsRequest)) {
            return false;
        }
        DescribePrefixListsRequest other = (DescribePrefixListsRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(prefixListIds(), other.prefixListIds());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribePrefixListsRequest").add("Filters", filters()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("PrefixListIds", prefixListIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "MaxResults":
            return Optional.of(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "PrefixListIds":
            return Optional.of(clazz.cast(prefixListIds()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, DescribePrefixListsRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>prefix-list-id</code>: The ID of a prefix list.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>prefix-list-name</code>: The name of a prefix list.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>prefix-list-id</code>: The ID of a prefix list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>prefix-list-name</code>: The name of a prefix list.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>prefix-list-id</code>: The ID of a prefix list.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>prefix-list-name</code>: The name of a prefix list.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>prefix-list-id</code>: The ID of a prefix list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>prefix-list-name</code>: The name of a prefix list.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The maximum number of items to return for this request. The request returns a token that you can specify in a
         * subsequent call to get the next set of results.
         * </p>
         * <p>
         * Constraint: If the value specified is greater than 1000, we return only 1000 items.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this request. The request returns a token that you can
         *        specify in a subsequent call to get the next set of results.</p>
         *        <p>
         *        Constraint: If the value specified is greater than 1000, we return only 1000 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a prior call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a prior call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * One or more prefix list IDs.
         * </p>
         * 
         * @param prefixListIds
         *        One or more prefix list IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListIds(Collection<String> prefixListIds);

        /**
         * <p>
         * One or more prefix list IDs.
         * </p>
         * 
         * @param prefixListIds
         *        One or more prefix list IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListIds(String... prefixListIds);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private List<Filter> filters;

        private Integer maxResults;

        private String nextToken;

        private List<String> prefixListIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePrefixListsRequest model) {
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            prefixListIds(model.prefixListIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getPrefixListIds() {
            return prefixListIds;
        }

        @Override
        public final Builder prefixListIds(Collection<String> prefixListIds) {
            this.prefixListIds = ValueStringListCopier.copy(prefixListIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prefixListIds(String... prefixListIds) {
            prefixListIds(Arrays.asList(prefixListIds));
            return this;
        }

        public final void setPrefixListIds(Collection<String> prefixListIds) {
            this.prefixListIds = ValueStringListCopier.copy(prefixListIds);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribePrefixListsRequest build() {
            return new DescribePrefixListsRequest(this);
        }
    }
}
